/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Collection;
import org.bukkit.Art;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class EntityData
implements com.elmakers.mine.bukkit.api.entity.EntityData {
    protected Location location;
    protected boolean hasMoved = false;
    protected String name = null;
    protected EntityType type;
    protected Art art;
    protected BlockFace facing;
    protected Rotation rotation;
    protected ItemStack item;
    protected double health = 1.0;
    protected boolean isBaby;
    protected int fireTicks;
    protected DyeColor dyeColor;
    protected Horse.Color horseColor;
    protected Horse.Variant horseVariant;
    protected Horse.Style horseStyle;
    protected Skeleton.SkeletonType skeletonType;
    protected Ocelot.Type ocelotType;
    protected Villager.Profession villagerProfession;
    protected Collection<PotionEffect> potionEffects = null;
    protected boolean hasPotionEffects = false;
    protected Vector velocity = null;
    protected boolean hasVelocity = false;
    protected boolean isHanging = false;
    protected boolean isLiving = false;
    protected boolean isProjectile = false;

    public EntityData(Entity entity) {
        this(entity.getLocation(), entity);
    }

    public EntityData(Location location, Entity entity) {
        this.isLiving = entity instanceof LivingEntity;
        this.isHanging = entity instanceof Hanging;
        this.isProjectile = entity instanceof Projectile;
        this.type = entity.getType();
        this.location = location;
        this.fireTicks = entity.getFireTicks();
        this.velocity = entity.getVelocity();
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            this.facing = hanging.getFacing();
            this.location = location.getBlock().getLocation();
        }
        if (entity instanceof ItemFrame) {
            this.rotation = ((ItemFrame)entity).getRotation();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            this.name = li.getCustomName();
            this.health = li.getHealth();
            this.potionEffects = li.getActivePotionEffects();
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            boolean bl = this.isBaby = !ageable.isAdult();
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            this.dyeColor = colorable.getColor();
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = itemFrame.getItem();
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.horseVariant = horse.getVariant();
            this.horseColor = horse.getColor();
            this.horseStyle = horse.getStyle();
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            this.skeletonType = skeleton.getSkeletonType();
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.villagerProfession = villager.getProfession();
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.dyeColor = wolf.getCollarColor();
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            this.ocelotType = ocelot.getCatType();
        }
    }

    private Location getPaintingOffset(Location loc, Art art, BlockFace facing) {
        switch (art) {
            case ALBAN: 
            case AZTEC: 
            case AZTEC2: 
            case BOMB: 
            case KEBAB: 
            case PLANT: 
            case WASTELAND: {
                return loc;
            }
            case GRAHAM: 
            case WANDERER: {
                return loc.getBlock().getLocation().add(0.0, -1.0, 0.0);
            }
            case CREEBET: 
            case COURBET: 
            case POOL: 
            case SEA: 
            case SUNSET: 
            case DONKEYKONG: 
            case SKELETON: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, 0.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, 0.0, 0.0);
                }
                return loc;
            }
            case BUST: 
            case MATCH: 
            case SKULL_AND_ROSES: 
            case STAGE: 
            case VOID: 
            case WITHER: 
            case FIGHTERS: 
            case BURNINGSKULL: 
            case PIGSCENE: 
            case POINTER: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, -1.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, -1.0, 0.0);
                }
                return loc.add(0.0, -1.0, 0.0);
            }
        }
        return loc;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public Art getArt() {
        return this.art;
    }

    @Override
    public BlockFace getFacing() {
        return this.facing;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    protected Entity trySpawn() {
        Entity spawned = null;
        try {
            switch (this.type) {
                case PLAYER: {
                    break;
                }
                case PAINTING: {
                    Location attach = this.location.getBlock().getRelative(this.facing.getOppositeFace()).getLocation();
                    spawned = this.location.getWorld().spawn(attach, Painting.class);
                    Painting painting = (Painting)spawned;
                    Location offset = this.getPaintingOffset(this.getPaintingOffset(this.location, this.art, this.facing), this.art, this.facing);
                    painting.teleport(offset);
                    painting.setFacingDirection(this.facing, true);
                    painting.setArt(this.art, true);
                    break;
                }
                case ITEM_FRAME: {
                    Location frameAttach = this.location.getBlock().getRelative(this.facing.getOppositeFace()).getLocation();
                    spawned = CompatibilityUtils.spawnItemFrame(frameAttach, this.facing, this.rotation, this.item);
                    break;
                }
                case DROPPED_ITEM: {
                    spawned = null;
                    break;
                }
                default: {
                    spawned = this.location.getWorld().spawnEntity(this.location, this.type);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return spawned;
    }

    @Override
    public Entity spawn() {
        Entity spawned = this.trySpawn();
        if (spawned != null) {
            this.modify(spawned);
        }
        return spawned;
    }

    @Override
    public boolean modify(Entity entity) {
        Entity tryEntity;
        if (entity == null || entity.getType() != this.type) {
            return false;
        }
        entity.setFireTicks(this.fireTicks);
        if (!entity.isValid() && !(entity instanceof Player) && (tryEntity = this.trySpawn()) != null) {
            entity = tryEntity;
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.isBaby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            colorable.setColor(this.dyeColor);
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            painting.setArt(this.art, true);
            painting.setFacingDirection(this.facing, true);
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.setItem(this.item);
            itemFrame.setFacingDirection(this.facing, true);
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            horse.setVariant(this.horseVariant);
            horse.setStyle(this.horseStyle);
            horse.setColor(this.horseColor);
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            skeleton.setSkeletonType(this.skeletonType);
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.setProfession(this.villagerProfession);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setCollarColor(this.dyeColor);
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.setCatType(this.ocelotType);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            if (this.hasPotionEffects) {
                Collection currentEffects = li.getActivePotionEffects();
                for (PotionEffect effect : currentEffects) {
                    li.removePotionEffect(effect.getType());
                }
                if (this.potionEffects != null) {
                    for (PotionEffect effect : this.potionEffects) {
                        li.addPotionEffect(effect);
                    }
                }
            }
            if (this.name != null && this.name.length() > 0) {
                li.setCustomName(this.name);
            }
            try {
                li.setHealth(Math.min(this.health, li.getMaxHealth()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.hasMoved) {
            entity.teleport(this.location);
        }
        if (this.hasVelocity) {
            entity.setVelocity(this.velocity);
        }
        return true;
    }

    @Override
    public void setHasMoved(boolean moved) {
        this.hasMoved = moved;
    }

    public void setHasPotionEffects(boolean changed) {
        this.hasPotionEffects = changed;
    }

    public void setHasVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    public boolean isHanging() {
        return this.isHanging;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }
}

