/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectRepeating;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectTrail
extends EffectRepeating {
    protected Double length;
    protected double size;
    protected Vector direction;

    public EffectTrail() {
    }

    public EffectTrail(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        this.iterations = 8;
        super.load(plugin, configuration);
        this.length = ConfigurationUtils.getDouble(configuration, "length", this.length);
    }

    @Override
    public void play() {
        this.size = this.length != null ? this.length : (this.target != null ? this.origin.distance(this.target) : 0.0);
        if (this.size < 1.0) {
            this.stop();
            return;
        }
        this.direction = this.getDirection();
        super.play();
    }

    @Override
    public void iterate() {
        Vector delta = this.direction.clone();
        Location current = null;
        if (this.playAtOrigin) {
            current = this.origin.clone();
            current.add(delta.multiply(this.scale(this.size) + 1.0));
            this.playEffect(current, this.getOriginEntity(), this.target, this.getTargetEntity());
        }
        if (this.playAtTarget && this.target != null) {
            current = this.target.clone();
            current.add(delta.multiply(-this.scale(this.size) + 1.0));
            this.playEffect(current, this.getTargetEntity(), this.origin, this.getOriginEntity());
        }
    }

    @Override
    protected void checkLocations() {
        if (this.target == null) {
            Vector delta = this.origin.getDirection().clone().normalize();
            this.target = this.origin.clone();
            this.target.add(delta.multiply(this.size + 1.0));
        }
        super.checkLocations();
    }
}

