/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EffectLibManager {
    private static EffectManager effectManager;
    private static final Map<String, String> nameMap;

    public static EffectLibManager initialize(Plugin plugin) {
        if (effectManager == null) {
            effectManager = new EffectManager(plugin);
        }
        return new EffectLibManager();
    }

    public Effect play(ConfigurationSection configuration, EffectPlayer player, Location origin, Entity originEntity, Location target, Entity targetEntity) {
        if (originEntity != null && originEntity instanceof Player) {
            nameMap.put("$name", ((Player)originEntity).getName());
        } else if (originEntity != null && originEntity instanceof LivingEntity) {
            nameMap.put("$name", ((LivingEntity)originEntity).getCustomName());
        } else {
            nameMap.put("$name", "Unknown");
        }
        if (targetEntity != null && targetEntity instanceof Player) {
            nameMap.put("$target", ((Player)targetEntity).getName());
        } else if (originEntity != null && targetEntity instanceof LivingEntity) {
            nameMap.put("$target", ((LivingEntity)targetEntity).getCustomName());
        } else {
            nameMap.put("$target", "Unknown");
        }
        Effect effect = null;
        String effectClass = configuration.getString("class");
        ParticleEffect particleEffect = player.overrideParticle(null);
        String effectOverride = player.getParticleOverrideName();
        ConfigurationSection parameters = configuration;
        if (particleEffect != null && effectOverride != null && !effectOverride.isEmpty() && configuration.contains(effectOverride)) {
            parameters = new MemoryConfiguration();
            Set keys = configuration.getKeys(false);
            for (String key : keys) {
                parameters.set(key, configuration.get(key));
            }
            parameters.set(effectOverride, (Object)particleEffect.name());
        }
        try {
            effect = effectManager.start(effectClass, parameters, origin, target, originEntity, targetEntity, nameMap);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().warning("Error playing effects of class: " + effectClass);
            ex.printStackTrace();
        }
        return effect;
    }

    public void cancel(Collection<Effect> effects) {
        for (Effect effect : effects) {
            try {
                effect.cancel();
            }
            catch (Throwable ex) {
                Bukkit.getLogger().warning("Error cancelling effects");
                ex.printStackTrace();
            }
        }
    }

    static {
        nameMap = new HashMap<String, String>();
    }
}

