/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.batch;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ReplaceMaterialAction
extends SimpleBlockAction {
    protected BrushSpell spell;
    protected Mage mage;
    protected MaterialBrush brush;
    protected Set<MaterialAndData> replaceable = new HashSet<MaterialAndData>();
    private boolean spawnFallingBlocks = false;
    private Vector fallingBlockVelocity = null;

    public ReplaceMaterialAction(BrushSpell spell, Block targetBlock) {
        super(spell.getMage().getController(), spell.getUndoList());
        this.spell = spell;
        this.mage = spell.getMage();
        this.brush = spell.getBrush();
        if (targetBlock != null) {
            this.replaceable.add(new MaterialAndData(targetBlock));
        }
    }

    public ReplaceMaterialAction(BrushSpell spell) {
        this(spell, null);
    }

    public void addReplaceable(Material material) {
        this.replaceable.add(new MaterialAndData(material));
    }

    public void addReplaceable(Material material, byte data) {
        this.replaceable.add(new MaterialAndData(material, data));
    }

    @Override
    public SpellResult perform(Block block) {
        if (this.brush == null) {
            return SpellResult.FAIL;
        }
        if (!this.spell.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.spell.isIndestructible(block)) {
            return SpellResult.FAIL;
        }
        if (this.replaceable == null || this.replaceable.contains(new MaterialAndData(block))) {
            Material previousMaterial = block.getType();
            byte previousData = block.getData();
            if (this.brush.isDifferent(block)) {
                this.brush.update(this.mage, block.getLocation());
                this.brush.modify(block);
                this.mage.getController().updateBlock(block);
                if (this.spawnFallingBlocks) {
                    FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                    falling.setDropItem(false);
                    if (this.fallingBlockVelocity != null) {
                        falling.setVelocity(this.fallingBlockVelocity);
                    }
                }
            }
            super.perform(block);
            return SpellResult.CAST;
        }
        return SpellResult.FAIL;
    }
}

