/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import org.apache.commons.lang.StringUtils;
import org.bukkit.Color;

public class ColorHD
implements Cloneable {
    private static long BYTES_PER_COMPONENT = 6L;
    private static long BITS_PER_COMPONENT = BYTES_PER_COMPONENT * 8L;
    private static long COMPONENT_SHIFT = BITS_PER_COMPONENT - 8L;
    private static long BIT_MASK = (1L << (int)BITS_PER_COMPONENT) - 1L;
    private final long red;
    private final long green;
    private final long blue;
    private final Color color;

    public ColorHD(long r, long g, long b) {
        this.red = r & BIT_MASK;
        this.blue = b & BIT_MASK;
        this.green = g & BIT_MASK;
        Color testCreate = null;
        try {
            testCreate = Color.fromRGB((int)((int)(this.red >> (int)COMPONENT_SHIFT)), (int)((int)(this.green >> (int)COMPONENT_SHIFT)), (int)((int)(this.blue >> (int)COMPONENT_SHIFT)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.color = testCreate;
    }

    public ColorHD(Color color) {
        this(color.getRed() << (int)COMPONENT_SHIFT, color.getGreen() << (int)COMPONENT_SHIFT, color.getBlue() << (int)COMPONENT_SHIFT);
    }

    public ColorHD(String hexColor) {
        if (hexColor == null || hexColor.length() == 0) {
            this.red = 0L;
            this.green = 0L;
            this.blue = 0L;
        } else if (hexColor.equals("random")) {
            this.red = (long)(Math.random() * (double)BIT_MASK);
            this.green = (long)(Math.random() * (double)BIT_MASK);
            this.blue = (long)(Math.random() * (double)BIT_MASK);
        } else if (hexColor.length() > 6 && hexColor.contains(",")) {
            String[] pieces = StringUtils.split((String)hexColor, (String)",");
            long r = 0L;
            long g = 0L;
            long b = 0L;
            if (pieces.length == 3) {
                try {
                    r = Long.parseLong(pieces[0], 16);
                    g = Long.parseLong(pieces[1], 16);
                    b = Long.parseLong(pieces[2], 16);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.red = r;
            this.green = g;
            this.blue = b;
        } else {
            long effectColor = 0L;
            try {
                effectColor = Integer.parseInt(hexColor, 16);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.red = (effectColor >> 16 & 0xFFL) << (int)COMPONENT_SHIFT;
            this.green = (effectColor >> 8 & 0xFFL) << (int)COMPONENT_SHIFT;
            this.blue = (effectColor & 0xFFL) << (int)COMPONENT_SHIFT;
        }
        Color testCreate = null;
        try {
            testCreate = Color.fromRGB((int)((int)(this.red >> (int)COMPONENT_SHIFT)), (int)((int)(this.green >> (int)COMPONENT_SHIFT)), (int)((int)(this.blue >> (int)COMPONENT_SHIFT)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.color = testCreate;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return Long.toHexString(this.red) + "," + Long.toHexString(this.green) + "," + Long.toHexString(this.blue);
    }

    public Object clone() {
        return new ColorHD(this.red, this.green, this.blue);
    }

    public ColorHD mixColor(long r, long g, long b, double weight) {
        double totalWeight = weight + 1.0;
        double totalRed = (double)this.red + (double)r * weight;
        double totalGreen = (double)this.green + (double)g * weight;
        double totalBlue = (double)this.blue + (double)b * weight;
        return new ColorHD((long)(totalRed / totalWeight), (long)(totalGreen / totalWeight), (long)(totalBlue / totalWeight));
    }

    public ColorHD mixColor(ColorHD other, double weight) {
        return this.mixColor(other.red, other.green, other.blue, weight);
    }

    public ColorHD mixColor(Color other, double weight) {
        if (other == null) {
            return this;
        }
        return this.mixColor(this.color.getRed() << (int)COMPONENT_SHIFT, this.color.getGreen() << (int)COMPONENT_SHIFT, this.color.getBlue() << (int)COMPONENT_SHIFT, weight);
    }

    public static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }
}

