/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class DisarmSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasEntity() || !(target.getEntity() instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity entity = (LivingEntity)target.getEntity();
        EntityEquipment equipment = entity.getEquipment();
        ItemStack stack = equipment.getItemInHand();
        if (stack == null || stack.getType() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        if (Wand.isWand(stack) && this.controller.isMage((Entity)entity)) {
            Mage targetMage = this.controller.getMage((Entity)entity);
            if (!this.mage.isSuperPowered() && this.isSuperProtected(targetMage)) {
                return SpellResult.NO_TARGET;
            }
            if (targetMage != null && targetMage.getActiveWand() != null) {
                targetMage.getActiveWand().deactivate();
            }
        }
        Integer targetSlot = null;
        PlayerInventory targetInventory = null;
        if (entity instanceof Player && parameters.getBoolean("keep_in_inventory", false)) {
            Player targetPlayer = (Player)entity;
            targetInventory = targetPlayer.getInventory();
            int currentSlot = targetInventory.getHeldItemSlot();
            ItemStack[] contents = targetInventory.getContents();
            for (int i = contents.length - 1; i >= 0; --i) {
                if (i == currentSlot || contents[i] != null && contents[i].getType() != Material.AIR) continue;
                targetSlot = i;
                break;
            }
        }
        equipment.setItemInHand(null);
        if (targetSlot != null && targetInventory != null) {
            targetInventory.setItem(targetSlot.intValue(), stack);
        } else {
            Location location = entity.getLocation();
            location.setY(location.getY() + 1.0);
            Item item = entity.getWorld().dropItemNaturally(location, stack);
            Vector velocity = item.getVelocity();
            velocity.setY(velocity.getY() * 5.0);
            item.setVelocity(velocity);
        }
        return SpellResult.CAST;
    }
}

