/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WandCommandExecutor
extends MagicTabExecutor {
    public WandCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (commandLabel.equalsIgnoreCase("wandp")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /wandp [player] [wand name/command]");
                return true;
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + args[0] + " is not online");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processWandCommand("wandp", sender, player, args2);
        }
        if (commandLabel.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "Magic.commands.wand.list")) {
                this.sendNoPermission(sender);
                return true;
            }
            this.onWandList(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (commandLabel.equalsIgnoreCase("wand")) {
            return this.processWandCommand("wand", sender, player, args);
        }
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String subCommand;
        Player player;
        ArrayList<String> options = new ArrayList<String>();
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (commandName.equalsIgnoreCase("wandp")) {
            if (args.length > 0) {
                player = Bukkit.getPlayer((String)args[0]);
            }
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                Collections.sort(options);
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "add");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "remove");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "name");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "fill");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "configure");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "override");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "organize");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "combine");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "upgrade");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "describe");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "enchant");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "unenchant");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "duplicate");
            this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".", "unlock");
            Collection<String> allWands = this.api.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".wand.", wandKey, true);
            }
        }
        if (args.length == 2) {
            subCommand = args[0];
            String subCommandPNode = "Magic.commands." + commandName + "." + subCommand;
            if (!this.api.hasPermission(sender, subCommandPNode)) {
                return options;
            }
            subCommandPNode = subCommandPNode + ".";
            if (subCommand.equalsIgnoreCase("add")) {
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates();
                for (SpellTemplate spell : spellList) {
                    this.addIfPermissible(sender, options, subCommandPNode, spell.getKey(), true);
                }
                this.addIfPermissible(sender, options, subCommandPNode, "material", true);
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                for (String key : Wand.PROPERTY_KEYS) {
                    options.add(key);
                }
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
                if (player != null) {
                    Mage mage = this.api.getMage((CommandSender)player);
                    activeWand = mage.getActiveWand();
                }
                if (activeWand != null) {
                    Collection<String> spellNames = activeWand.getSpells();
                    for (String spellName : spellNames) {
                        options.add(spellName);
                    }
                    options.add("material");
                }
            }
            if (subCommand.equalsIgnoreCase("combine")) {
                Collection<String> allWands = this.api.getWandKeys();
                for (String wandKey : allWands) {
                    this.addIfPermissible(sender, options, "Magic.commands." + commandName + ".combine.", wandKey, true);
                }
            }
        }
        if (args.length == 3) {
            String subCommandPNode;
            subCommand = args[0];
            String subCommand2 = args[1];
            String commandPNode = "Magic.commands." + commandName + "." + subCommand;
            if (!this.api.hasPermission(sender, commandPNode)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("upgrade")) {
                if (subCommand2.equals("effect_sound")) {
                    Sound[] sounds;
                    for (Sound sound : sounds = Sound.values()) {
                        options.add(sound.name().toLowerCase());
                    }
                } else if (subCommand2.equals("effect_particle")) {
                    ParticleEffect[] particleTypes;
                    for (ParticleEffect particleType : particleTypes = ParticleEffect.values()) {
                        options.add(particleType.name().toLowerCase());
                    }
                }
            }
            if (!this.api.hasPermission(sender, subCommandPNode = "Magic.commands." + commandName + "." + subCommand + "." + subCommand2)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("remove") && subCommand2.equalsIgnoreCase("material")) {
                com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
                if (player != null) {
                    Mage mage = this.api.getMage((CommandSender)player);
                    activeWand = mage.getActiveWand();
                }
                if (activeWand != null) {
                    Collection<String> materialNames = activeWand.getBrushes();
                    for (String materialName : materialNames) {
                        options.add(materialName);
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("material")) {
                options.addAll(this.api.getBrushes());
            }
        }
        Collections.sort(options);
        return options;
    }

    protected boolean processWandCommand(String command, CommandSender sender, Player player, String[] args) {
        String subCommand = "";
        String[] args2 = args;
        if (args.length > 0) {
            subCommand = args[0];
            args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
        }
        if (subCommand.equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandList(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0 && args2[0].equals("material") && !this.api.hasPermission(sender, "Magic.commands.wand.add." + args2[0], true)) {
                return true;
            }
            if (args2.length > 0 && !this.api.hasPermission(sender, "Magic.commands.wand.add.spell." + args2[0], true)) {
                return true;
            }
            this.onWandAdd(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, false);
            return true;
        }
        if (subCommand.equalsIgnoreCase("override")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOverride(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("enchant")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0) {
                this.onWandEnchant(sender, player, args2[0]);
            } else {
                this.onWandEnchant(sender, player);
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("unenchant")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnenchant(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("duplicate")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDuplicate(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unlock")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnlock(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("combine")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args.length > 0 && !this.api.hasPermission(sender, "Magic.commands." + command + ".combine." + args[0], true)) {
                return true;
            }
            this.onWandCombine(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDescribe(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("upgrade")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, true);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("fill")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandFill(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRemove(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("name")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandName(sender, player, args2);
            return true;
        }
        if (subCommand.length() == 0) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command)) {
                return true;
            }
            if (!this.api.hasPermission(sender, "Magic.commands." + command + ".wand.default", true)) {
                return true;
            }
        } else if (!this.api.hasPermission(sender, "Magic.commands." + command + ".wand." + subCommand, true)) {
            return true;
        }
        return this.onWand(sender, player, args);
    }

    public boolean onWandList(CommandSender sender) {
        Collection<ConfigurationSection> templates = Wand.getWandTemplates();
        TreeMap<String, ConfigurationSection> nameMap = new TreeMap<String, ConfigurationSection>();
        for (ConfigurationSection templateConfig : templates) {
            nameMap.put(templateConfig.getString("key"), templateConfig);
        }
        for (ConfigurationSection templateConfig : nameMap.values()) {
            if (templateConfig.getBoolean("hidden", false)) continue;
            String key = templateConfig.getString("key");
            String name = Messages.get("wands." + key + ".name", Messages.get("wand.default_name"));
            String description = Messages.get("wands." + key + ".description", "");
            description = ChatColor.YELLOW + description;
            if (!name.equals(key)) {
                description = ChatColor.BLUE + name + ChatColor.WHITE + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + key + ChatColor.WHITE + " : " + description);
        }
        return true;
    }

    public boolean onWandDescribe(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true, true, sender != player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.describe(sender);
        return true;
    }

    public boolean onWandOrganize(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.closeInventory();
        wand.organizeInventory(mage);
        mage.sendMessage(Messages.get("wand.reorganized"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_reorganized", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player, String levelString) {
        if (!this.checkWand(sender, player)) {
            return false;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        int xpLevels = 0;
        boolean useXp = levelString.equalsIgnoreCase("xp");
        if (useXp) {
            xpLevels = mage.getLevel();
        } else {
            try {
                xpLevels = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                sender.sendMessage("Invalid parameter: " + levelString);
            }
        }
        int levels = wand.enchant(xpLevels);
        if (levels > 0 && useXp) {
            mage.setLevel(Math.max(0, mage.getLevel() - levels));
        }
        if (sender != player) {
            if (levels > 0) {
                sender.sendMessage(Messages.getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(Messages.getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player) {
        Mage mage = this.api.getMage((CommandSender)player);
        ItemStack heldItem = player.getItemInHand();
        if (heldItem == null || heldItem.getType() == Material.AIR) {
            mage.sendMessage(Messages.get("wand.no_item"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_item", "$name", player.getName()));
            }
            return false;
        }
        if (this.api.isWand(heldItem) || this.api.isSpell(heldItem) || this.api.isBrush(heldItem)) {
            sender.sendMessage(Messages.getParameterized("wand.already_enchanted", "$item", MaterialBrush.getMaterialName(heldItem.getType(), (byte)heldItem.getDurability())));
            return false;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.api.createWand(heldItem.getType(), heldItem.getDurability());
        player.setItemInHand(wand.getItem());
        wand.activate(mage);
        mage.sendMessage(Messages.getParameterized("wand.enchanted", "$item", MaterialBrush.getMaterialName(heldItem.getType(), (byte)heldItem.getDurability())));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_enchanted", "$item", MaterialBrush.getMaterialName(heldItem.getType(), (byte)heldItem.getDurability()), "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnenchant(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (wand == null || !this.api.isWand(player.getItemInHand())) {
            mage.sendMessage(Messages.get("wand.no_wand"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        wand.deactivate();
        wand.unenchant();
        player.setItemInHand(wand.getItem());
        mage.sendMessage(Messages.get("wand.unenchanted"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_unenchanted", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDuplicate(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, false, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        com.elmakers.mine.bukkit.api.wand.Wand newWand = wand.duplicate();
        this.api.giveItemToPlayer(player, newWand.getItem());
        mage.sendMessage(Messages.get("wand.duplicated"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_duplicated", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnlock(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true, true, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.unlock();
        mage.sendMessage(Messages.get("wand.unlocked"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_unlocked", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandOverride(CommandSender sender, Player player, String[] parameters) {
        if (!this.checkWand(sender, player, true, true, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (parameters.length == 0) {
            Map<String, String> overrides = wand.getOverrides();
            if (overrides.size() == 0) {
                sender.sendMessage(ChatColor.DARK_AQUA + "This wand has no overrides");
            } else {
                for (Map.Entry<String, String> override : overrides.entrySet()) {
                    sender.sendMessage(ChatColor.AQUA + override.getKey() + ChatColor.WHITE + " = " + ChatColor.DARK_AQUA + override.getValue());
                }
            }
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        if (parameters.length == 1) {
            wand.removeOverride(parameters[0]);
            sender.sendMessage(ChatColor.DARK_AQUA + "Removed override " + parameters[0]);
            return true;
        }
        wand.setOverride(parameters[0], parameters[1]);
        sender.sendMessage(ChatColor.DARK_AQUA + "Added override " + ChatColor.AQUA + parameters[0] + ChatColor.WHITE + " = " + ChatColor.DARK_AQUA + parameters[1]);
        return true;
    }

    public boolean onWandConfigure(CommandSender sender, Player player, String[] parameters, boolean safe) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand configure <property> <value>");
            sender.sendMessage("Properties: " + StringUtils.join((Object[])Wand.PROPERTY_KEYS, (String)", "));
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        HashMap<String, Object> node = new HashMap<String, Object>();
        String value = "";
        for (int i = 1; i < parameters.length; ++i) {
            if (i != 1) {
                value = value + " ";
            }
            value = value + parameters[i];
        }
        node.put(parameters[0], value);
        wand.deactivate();
        if (safe) {
            wand.upgrade(node);
        } else {
            wand.configure(node);
        }
        wand.activate(mage);
        mage.sendMessage(Messages.get("wand.reconfigured"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_reconfigured", "$name", player.getName()));
        }
        return true;
    }

    protected boolean checkWand(CommandSender sender, Player player) {
        return this.checkWand(sender, player, false, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable) {
        return this.checkWand(sender, player, skipModifiable, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound) {
        return this.checkWand(sender, player, skipModifiable, skipBound, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound, boolean quiet) {
        boolean bypassLocked;
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (wand == null) {
            if (!quiet) {
                mage.sendMessage(Messages.get("wand.no_wand"));
            }
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        boolean bl = bypassLocked = sender instanceof Player && this.api.hasPermission(sender, "Magic.wand.override_locked");
        if (!skipModifiable && wand.isLocked() && !bypassLocked) {
            if (!quiet) {
                mage.sendMessage(Messages.get("wand.unmodifiable"));
            }
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        if (!skipBound && !wand.canUse(mage.getPlayer())) {
            if (!quiet) {
                mage.sendMessage(Messages.get("wand.bound_to_other"));
            }
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean onWandCombine(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand combine <wandname>");
            return false;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        String wandName = parameters[0];
        com.elmakers.mine.bukkit.api.wand.Wand newWand = this.api.createWand(wandName);
        if (newWand == null) {
            sender.sendMessage(Messages.getParameterized("wand.unknown_template", "$name", wandName));
            return false;
        }
        wand.deactivate();
        boolean result = wand.add(newWand);
        wand.activate(mage);
        if (sender != player) {
            if (result) {
                sender.sendMessage(Messages.getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(Messages.getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandFill(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.fill(player);
        mage.sendMessage(Messages.get("wand.filled"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_filled", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandAdd(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand add <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand add material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (!MaterialBrush.isValidMaterial(materialKey, false)) {
                sender.sendMessage(materialKey + " is not a valid material");
                return true;
            }
            if (wand.addBrush(materialKey)) {
                wand.setActiveBrush(materialKey);
                mage.sendMessage("Material '" + materialKey + "' has been added to your wand");
                if (sender != player) {
                    sender.sendMessage("Added material '" + materialKey + "' to " + player.getName() + "'s wand");
                }
            } else {
                wand.setActiveBrush(materialKey);
                mage.sendMessage("Material activated: " + materialKey);
                if (sender != player) {
                    sender.sendMessage(player.getName() + "'s wand already has material " + materialKey);
                }
            }
            return true;
        }
        Spell spell = mage.getSpell(spellName);
        if (spell == null) {
            sender.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        if (wand.addSpell(spellName)) {
            wand.setActiveSpell(spellName);
            mage.sendMessage("Spell '" + spell.getName() + "' has been added to your wand");
            if (sender != player) {
                sender.sendMessage("Added '" + spell.getName() + "' to " + player.getName() + "'s wand");
            }
        } else {
            wand.setActiveSpell(spellName);
            mage.sendMessage(spell.getName() + " activated");
            if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand already has " + spell.getName());
            }
        }
        return true;
    }

    public boolean onWandRemove(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand remove <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand remove material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (wand.removeBrush(materialKey)) {
                mage.sendMessage("Material '" + materialKey + "' has been removed from your wand");
                if (sender != player) {
                    sender.sendMessage("Removed material '" + materialKey + "' from " + player.getName() + "'s wand");
                }
            } else if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand does not have material " + materialKey);
            }
            return true;
        }
        if (wand.removeSpell(spellName)) {
            mage.sendMessage("Spell '" + spellName + "' has been removed from your wand");
            if (sender != player) {
                sender.sendMessage("Removed '" + spellName + "' from " + player.getName() + "'s wand");
            }
        } else if (sender != player) {
            sender.sendMessage(player.getName() + "'s wand does not have " + spellName);
        }
        return true;
    }

    public boolean onWandName(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand name <name>");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.setName(StringUtils.join((Object[])parameters, (String)" "));
        mage.sendMessage(Messages.get("wand.renamed"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_renamed", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWand(CommandSender sender, Player player, String[] parameters) {
        String wandName = null;
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        return this.giveWand(sender, player, wandName, false, true, false, false);
    }
}

