/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class EffectVariable
extends EffectPlayer {
    private Map<Double, Collection<EffectPlayer>> brightnessMap = new TreeMap<Double, Collection<EffectPlayer>>();
    private Collection<EffectPlayer> playing = new ArrayList<EffectPlayer>();

    @Override
    public void cancel() {
        super.cancel();
        for (EffectPlayer player : this.playing) {
            player.cancel();
        }
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        block8: {
            super.load(plugin, configuration);
            Object testObject = configuration.get("brightness");
            if (testObject == null) break block8;
            if (testObject instanceof Map) {
                Map dataMap = (Map)testObject;
                for (Map.Entry entry : dataMap.entrySet()) {
                    try {
                        String key = (String)entry.getKey();
                        double level = Double.parseDouble(key);
                        MemoryConfiguration brightness = new MemoryConfiguration();
                        brightness.set(key, entry.getValue());
                        this.brightnessMap.put(level, EffectPlayer.loadEffects(plugin, (ConfigurationSection)brightness, key));
                    }
                    catch (Exception ex) {}
                }
            } else {
                ConfigurationSection brightness = configuration.getConfigurationSection("brightness");
                Set keys = brightness.getKeys(false);
                for (String key : keys) {
                    try {
                        double level = Double.parseDouble(key);
                        this.brightnessMap.put(level, EffectPlayer.loadEffects(plugin, brightness, key));
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    @Override
    public void play() {
        this.playing.clear();
        if (this.brightnessMap.size() > 0) {
            double brightness = 0.0;
            Color color = this.getColor1();
            if (color != null) {
                brightness = (double)color.getRed() / 255.0 + (double)color.getBlue() / 255.0 + (double)color.getGreen() / 255.0;
            }
            for (Map.Entry<Double, Collection<EffectPlayer>> entry : this.brightnessMap.entrySet()) {
                if (!(brightness < entry.getKey())) continue;
                for (EffectPlayer player : entry.getValue()) {
                    player.setScale(this.scale);
                    player.setMaterial(this.getWorkingMaterial());
                    player.setColor(this.getColor1());
                    player.setParticleOverride(this.particleOverride);
                    player.start(this.origin, this.originEntity == null ? null : (Entity)this.originEntity.get(), this.target, this.targetEntity == null ? null : (Entity)this.targetEntity.get());
                    this.playing.add(player);
                }
            }
        }
    }
}

