/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EffectLibManager {
    private static EffectManager effectManager;
    private static final Map<String, String> nameMap;

    public static EffectLibManager initialize(Plugin plugin) {
        if (effectManager == null) {
            effectManager = new EffectManager(plugin);
        }
        return new EffectLibManager();
    }

    public Effect[] play(ConfigurationSection configuration, EffectPlayer player, Location origin, Location target) {
        Entity sourcePlayer = player.getOriginEntity();
        Entity sourceEntity = player.playAtOrigin ? player.getOriginEntity() : null;
        Entity targetEntity = player.playAtTarget ? player.getTargetEntity() : null;
        origin = player.playAtOrigin ? origin : null;
        Object object = target = player.playAtTarget ? target : null;
        if (sourcePlayer != null && sourcePlayer instanceof Player) {
            nameMap.put("$name", ((Player)sourcePlayer).getName());
        } else {
            nameMap.put("$name", "Unknown");
        }
        Effect[] effects = null;
        String effectClass = configuration.getString("class");
        ParticleEffect effect = player.overrideParticle(null);
        String effectOverride = player.getParticleOverrideName();
        ConfigurationSection parameters = configuration;
        if (effect != null && effectOverride != null && !effectOverride.isEmpty() && configuration.contains(effectOverride)) {
            parameters = new MemoryConfiguration();
            Set keys = configuration.getKeys(false);
            for (String key : keys) {
                parameters.set(key, configuration.get(key));
            }
            parameters.set(effectOverride, (Object)effect.name());
        }
        try {
            effects = effectManager.start(effectClass, parameters, origin, target, sourceEntity, targetEntity, nameMap);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().warning("Error playing effects of class: " + effectClass);
            ex.printStackTrace();
        }
        return effects;
    }

    public void cancel(Effect[] effects) {
        for (Effect effect : effects) {
            try {
                effect.cancel();
            }
            catch (Throwable ex) {
                Bukkit.getLogger().warning("Error cancelling effects");
                ex.printStackTrace();
            }
        }
    }

    static {
        nameMap = new HashMap<String, String>();
    }
}

