/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class UndoBatch
implements com.elmakers.mine.bukkit.api.block.UndoBatch {
    protected final MageController controller;
    private UndoList trackUndoBlocks;
    private static final BlockData[] template = new BlockData[0];
    private final BlockData[] undoBlocks;
    private int undoIndex = 0;
    private boolean finishedAttachables = false;
    protected boolean finished = false;
    protected boolean applyPhysics = false;
    private final Set<Material> attachables;
    private final Set<Material> attachablesWall;
    private final Set<Material> attachablesDouble;
    private final Set<Material> delayed;

    public UndoBatch(UndoList blockList) {
        Mage mage = blockList.getOwner();
        this.controller = mage.getController();
        this.trackUndoBlocks = new UndoList(mage, blockList.getSpell(), "Undo");
        this.trackUndoBlocks.setBypass(true);
        this.applyPhysics = blockList.getApplyPhysics();
        this.undoBlocks = blockList.toArray(template);
        ArrayUtils.reverse((Object[])this.undoBlocks);
        this.attachables = this.controller.getMaterialSet("attachable");
        this.attachablesWall = this.controller.getMaterialSet("attachable_wall");
        this.attachablesDouble = this.controller.getMaterialSet("attachable_double");
        this.delayed = this.controller.getMaterialSet("delayed");
    }

    @Override
    public int size() {
        return this.undoBlocks == null ? 0 : this.undoBlocks.length;
    }

    @Override
    public int remaining() {
        return this.undoBlocks == null ? 0 : this.undoBlocks.length - this.undoIndex;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks;
        for (processedBlocks = 0; this.undoBlocks != null && this.undoIndex < this.undoBlocks.length && processedBlocks < maxBlocks; ++processedBlocks) {
            boolean isAttachable;
            BlockData blockData = this.undoBlocks[this.undoIndex];
            Block block = blockData.getBlock();
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                break;
            }
            Material material = block.getType();
            boolean bl = isAttachable = this.attachables.contains(material) || this.attachablesWall.contains(material) || this.attachablesDouble.contains(material) || this.delayed.contains(material);
            if (isAttachable && !this.finishedAttachables || !isAttachable && this.finishedAttachables) {
                this.trackUndoBlocks.add(blockData);
                if (!UndoList.undo(blockData, this.applyPhysics)) break;
            }
            ++this.undoIndex;
        }
        if (this.undoBlocks == null || this.undoIndex >= this.undoBlocks.length && this.finishedAttachables) {
            this.finish();
        } else if (this.undoIndex >= this.undoBlocks.length) {
            this.finishedAttachables = true;
            this.undoIndex = 0;
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.controller.update(this.trackUndoBlocks);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

