/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class UndoQueue
implements com.elmakers.mine.bukkit.api.block.UndoQueue {
    private final Mage owner;
    private UndoList head = null;
    private UndoList tail = null;
    private int size = 0;
    private int maxSize = 0;

    public UndoQueue(Mage mage) {
        this.owner = mage;
    }

    @Override
    public void add(com.elmakers.mine.bukkit.api.block.UndoList blocks) {
        UndoList expired;
        if (!(blocks instanceof UndoList)) {
            return;
        }
        UndoList addList = (UndoList)blocks;
        if (this.maxSize > 0 && this.size > this.maxSize && (expired = this.tail) != null) {
            if (expired.isScheduled()) {
                expired.undo();
            } else {
                expired.commit();
            }
        }
        addList.setUndoQueue(this);
        ++this.size;
        if (this.head == null) {
            this.head = addList;
            this.tail = addList;
        } else {
            addList.setPrevious(this.head);
            this.head.setNext(addList);
            this.head = addList;
        }
        if (addList.isScheduled()) {
            this.owner.getController().scheduleUndo(addList);
        }
    }

    public void removed(UndoList list) {
        if (list == this.head) {
            this.head = list.getPrevious();
        }
        if (list == this.tail) {
            this.tail = list.getNext();
        }
        --this.size;
    }

    @Override
    public int undoScheduled() {
        int undid = 0;
        UndoList nextList = this.tail;
        while (nextList != null) {
            UndoList checkList = nextList;
            nextList = nextList.getNext();
            if (!checkList.isScheduled()) continue;
            checkList.undo(true);
            ++undid;
        }
        return undid;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public UndoList getLast() {
        return this.head;
    }

    @Override
    public UndoList getLast(Block target) {
        for (UndoList checkList = this.head; checkList != null; checkList = checkList.getPrevious()) {
            if (!checkList.contains(target)) continue;
            return checkList;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public UndoList undo() {
        return this.undoRecent(0);
    }

    public UndoList undo(Block target) {
        return this.undoRecent(target, 0);
    }

    @Override
    public UndoList undoRecent(int timeout) {
        if (this.head == null) {
            return null;
        }
        if (timeout > 0 && System.currentTimeMillis() - (long)timeout > this.head.getModifiedTime()) {
            return null;
        }
        UndoList undid = this.head;
        undid.undo();
        return undid;
    }

    @Override
    public UndoList undoRecent(Block block, int timeout) {
        UndoList lastActionOnTarget = this.getLast(block);
        if (lastActionOnTarget == null) {
            return null;
        }
        if (timeout > 0 && System.currentTimeMillis() - (long)timeout > lastActionOnTarget.getModifiedTime()) {
            return null;
        }
        lastActionOnTarget.undo();
        return lastActionOnTarget;
    }

    public void load(ConfigurationSection node) {
        try {
            if (node == null) {
                return;
            }
            Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(node, "undo");
            if (nodeList != null) {
                for (ConfigurationSection listNode : nodeList) {
                    UndoList list = new UndoList(this.owner, null);
                    list.load(listNode);
                    this.add(list);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.owner.getController().getLogger().warning("Failed to load undo data: " + ex.getMessage());
        }
    }

    public void save(ConfigurationSection node) {
        MageController controller = this.owner.getController();
        int maxSize = controller.getMaxUndoPersistSize();
        try {
            int discarded = 0;
            ArrayList<Map> nodeList = new ArrayList<Map>();
            for (UndoList list = this.tail; list != null; list = list.getNext()) {
                if (maxSize > 0 && list.size() > maxSize) {
                    ++discarded;
                    continue;
                }
                MemoryConfiguration listNode = new MemoryConfiguration();
                list.save((ConfigurationSection)listNode);
                nodeList.add(listNode.getValues(true));
            }
            if (discarded > 0) {
                controller.getLogger().info("Not saving " + discarded + " undo batches for mage " + this.owner.getName() + ", over max size of " + maxSize);
            }
            node.set("undo", nodeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            controller.getLogger().warning("Failed to save undo data: " + ex.getMessage());
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean commit() {
        for (UndoList nextList = this.tail; nextList != null; nextList = nextList.getNext()) {
            UndoList list = nextList;
            list.commit();
        }
        this.head = null;
        this.tail = null;
        this.size = 0;
        return true;
    }
}

