/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.utility.Messages;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class Automaton
extends BlockData
implements com.elmakers.mine.bukkit.api.magic.Automaton {
    private String message;
    private String name;
    private long createdAt;

    public Automaton(ConfigurationSection node) {
        super(node);
        this.name = node.getString("name");
        this.message = node.getString("message");
        this.createdAt = node.getLong("created", 0L);
    }

    public Automaton(Block block, String name, String message) {
        super(block);
        this.name = name;
        this.message = message;
        this.createdAt = System.currentTimeMillis();
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("name", (Object)this.name);
        node.set("message", (Object)this.message);
        node.set("created", (Object)this.createdAt);
    }

    public String getMessage() {
        if (this.message == null || this.message.length() == 0 || this.name == null || this.name.length() == 0) {
            return "";
        }
        String contents = Messages.get(this.message);
        if (contents == null || contents.length() == 0) {
            return "";
        }
        return contents.replace("$name", this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getCreatedTime() {
        return this.createdAt;
    }
}

