/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Art;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends NMSUtils {
    @Deprecated
    public static Location setDirection(Location location, Vector vector) {
        double _2PI = Math.PI * 2;
        double x = vector.getX();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            location.setPitch(vector.getY() > 0.0 ? -90.0f : 90.0f);
            return location;
        }
        double theta = Math.atan2(-x, z);
        location.setYaw((float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2)));
        double x2 = NumberConversions.square((double)x);
        double z2 = NumberConversions.square((double)z);
        double xz = Math.sqrt(x2 + z2);
        location.setPitch((float)Math.toDegrees(Math.atan(-vector.getY() / xz)));
        return location;
    }

    public static void applyPotionEffects(LivingEntity entity, Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            CompatibilityUtils.applyPotionEffect(entity, effect);
        }
    }

    public static void applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        boolean applyEffect = true;
        Collection currentEffects = entity.getActivePotionEffects();
        for (PotionEffect currentEffect : currentEffects) {
            if (!currentEffect.getType().equals((Object)effect.getType())) continue;
            if (effect.getAmplifier() < 0) {
                applyEffect = false;
                entity.removePotionEffect(effect.getType());
                break;
            }
            if (currentEffect.getAmplifier() <= effect.getAmplifier()) continue;
            applyEffect = false;
            break;
        }
        if (applyEffect) {
            entity.addPotionEffect(effect, true);
        }
    }

    public static boolean hasMetadata(ItemStack itemStack, Plugin plugin, String key) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object bukkitRoot = CompatibilityUtils.getNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return false;
        }
        Object pluginsRoot = CompatibilityUtils.getNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return false;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.getNode(pluginsRoot, pluginName);
        return pluginRoot != null && CompatibilityUtils.containsNode(pluginRoot, key);
    }

    public static String getMetadata(ItemStack itemStack, Plugin plugin, String key) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return null;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return null;
        }
        Object bukkitRoot = CompatibilityUtils.getNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return null;
        }
        Object pluginsRoot = CompatibilityUtils.getNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return null;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.getNode(pluginsRoot, pluginName);
        if (pluginRoot == null) {
            return null;
        }
        return CompatibilityUtils.getMeta(pluginRoot, key);
    }

    public static boolean setMetadata(ItemStack itemStack, Plugin plugin, String key, String value) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object bukkitRoot = CompatibilityUtils.createNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return false;
        }
        Object pluginsRoot = CompatibilityUtils.createNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return false;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.createNode(pluginsRoot, pluginName);
        if (pluginRoot == null) {
            return false;
        }
        CompatibilityUtils.setMeta(pluginRoot, key, value);
        return true;
    }

    public static boolean removeMetadata(ItemStack itemStack, Plugin plugin, String key) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object bukkitRoot = CompatibilityUtils.createNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return false;
        }
        Object pluginsRoot = CompatibilityUtils.createNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return false;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.createNode(pluginsRoot, pluginName);
        if (pluginRoot == null) {
            return false;
        }
        CompatibilityUtils.removeMeta(pluginRoot, key);
        return true;
    }

    public static Object getMetadataNode(ItemStack itemStack, Plugin plugin, String key) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return null;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return null;
        }
        Object bukkitRoot = CompatibilityUtils.getNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return null;
        }
        Object pluginsRoot = CompatibilityUtils.getNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return null;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.getNode(pluginsRoot, pluginName);
        return CompatibilityUtils.getNode(pluginRoot, key);
    }

    public static Object createMetadataNode(ItemStack itemStack, Plugin plugin, String key) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return null;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return null;
        }
        Object bukkitRoot = CompatibilityUtils.createNode(tag, "bukkit");
        if (bukkitRoot == null) {
            return null;
        }
        Object pluginsRoot = CompatibilityUtils.createNode(bukkitRoot, "plugins");
        if (pluginsRoot == null) {
            return null;
        }
        String pluginName = plugin.getName();
        Object pluginRoot = CompatibilityUtils.createNode(pluginsRoot, pluginName);
        return CompatibilityUtils.createNode(pluginRoot, key);
    }

    public static void removeCustomData(ItemStack itemStack) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return;
        }
        CompatibilityUtils.removeMeta(tag, "bukkit");
        CompatibilityUtils.removeMeta(tag, "wand");
        CompatibilityUtils.removeMeta(tag, "spell");
        CompatibilityUtils.removeMeta(tag, "brush");
    }

    public static boolean setDisplayName(ItemStack itemStack, String displayName) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        CompatibilityUtils.setMeta(displayNode, "Name", displayName);
        return true;
    }

    protected static Object getTagString(String value) {
        try {
            if (class_NBTTagList_legacy_consructor != null) {
                return class_NBTTagList_legacy_consructor.newInstance("", value);
            }
            return class_NBTTagList_consructor.newInstance(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setLore(ItemStack itemStack, Collection<String> lore) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        try {
            Object loreList = class_NBTTagList.newInstance();
            for (String value : lore) {
                Object nbtString = CompatibilityUtils.getTagString(value);
                class_NBTTagList_addMethod.invoke(loreList, nbtString);
            }
            class_NBTTagCompound_setMethod.invoke(displayNode, "Lore", loreList);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            inventory = (Inventory)class_CraftInventoryCustom_constructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static void addPotionEffect(LivingEntity entity, Color color) {
        CompatibilityUtils.addPotionEffect(entity, color.asRGB());
    }

    public static void clearPotionEffect(LivingEntity entity) {
        CompatibilityUtils.addPotionEffect(entity, 0);
    }

    public static void setInvulnerable(Entity entity) {
        CompatibilityUtils.setInvulnerable(entity, true);
    }

    public static void setInvulnerable(Entity entity, boolean flag) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_invulnerableField.set(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removePotionEffect(LivingEntity entity) {
        CompatibilityUtils.addPotionEffect(entity, 0);
    }

    public static Painting spawnPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        try {
            Constructor paintingConstructor = class_EntityPainting.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = paintingConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), CompatibilityUtils.getFacing(facing));
            if (newEntity != null) {
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Painting)) {
                    return null;
                }
                newPainting = (Painting)bukkitEntity;
                newPainting.setArt(art, true);
                newPainting.setFacingDirection(facing, true);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newPainting;
    }

    public static ItemFrame spawnItemFrame(Location location, BlockFace facing, ItemStack item) {
        ItemFrame newItemFrame = null;
        try {
            Constructor itemFrameConstructor = class_EntityItemFrame.getConstructor(class_World, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = itemFrameConstructor.newInstance(worldHandle, location.getBlockX(), location.getBlockY(), location.getBlockZ(), CompatibilityUtils.getFacing(facing));
            if (newEntity != null) {
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ItemFrame)) {
                    return null;
                }
                newItemFrame = (ItemFrame)bukkitEntity;
                newItemFrame.setItem(CompatibilityUtils.getCopy(item));
                newItemFrame.setFacingDirection(facing, true);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newItemFrame;
    }

    public static void watch(Object entityHandle, int key, Object data) {
        try {
            Method getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            Object dataWatcher = getDataWatcherMethod.invoke(entityHandle, new Object[0]);
            class_DataWatcher_watchMethod.invoke(dataWatcher, key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void watch(Entity entity, int key, Object data) {
        try {
            Method geHandleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            CompatibilityUtils.watch(geHandleMethod.invoke((Object)entity, new Object[0]), key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addPotionEffect(LivingEntity entity, int color) {
        CompatibilityUtils.watch((Entity)entity, 7, (Object)color);
    }

    public static List<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
        try {
            Object bb = class_AxisAlignedBB_createBBMethod.invoke(null, location.getX() - x, location.getY() - y, location.getZ() - z, location.getX() + x, location.getY() + y, location.getZ() + z);
            List entityList = (List)class_World_getEntitiesMethod.invoke(worldHandle, null, bb);
            ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
            for (Object entity : entityList) {
                bukkitEntityList.add((Entity)class_Entity_getBukkitEntityMethod.invoke(entity, new Object[0]));
            }
            return bukkitEntityList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Minecart spawnCustomMinecart(Location location, MaterialAndData display, int offset) {
        Minecart newMinecart = null;
        try {
            Constructor minecartConstructor = class_EntityMinecartRideable.getConstructor(class_World, Double.TYPE, Double.TYPE, Double.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Method setPositionRotationMethod = class_Entity.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = minecartConstructor.newInstance(worldHandle, location.getX(), location.getY(), location.getZ());
            if (newEntity != null) {
                setPositionRotationMethod.invoke(newEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                int materialId = display.getMaterial().getId() & 0xFFFF | display.getData() << 16;
                CompatibilityUtils.watch(newEntity, 20, (Object)materialId);
                CompatibilityUtils.watch(newEntity, 21, (Object)offset);
                CompatibilityUtils.watch(newEntity, 22, (Object)1);
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Minecart)) {
                    return null;
                }
                newMinecart = (Minecart)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newMinecart;
    }

    public static Class<? extends Runnable> getTaskClass(BukkitTask task) {
        Class taskClass = null;
        try {
            Method getTaskClassMethod = class_CraftTask.getDeclaredMethod("getTaskClass", new Class[0]);
            getTaskClassMethod.setAccessible(true);
            taskClass = (Class)getTaskClassMethod.invoke((Object)task, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return taskClass;
    }

    public static Runnable getTaskRunnable(BukkitTask task) {
        Runnable runnable = null;
        try {
            Field taskField = class_CraftTask.getDeclaredField("task");
            taskField.setAccessible(true);
            runnable = (Runnable)taskField.get(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return runnable;
    }

    public static void ageItem(Item item, int ticksToAge) {
        try {
            Class<?> itemClass = CompatibilityUtils.getBukkitClass("net.minecraft.server.EntityItem");
            Object handle = CompatibilityUtils.getHandle((Entity)item);
            Field ageField = itemClass.getDeclaredField("age");
            ageField.setAccessible(true);
            ageField.set(handle, ticksToAge);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

