/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectSpell
extends UndoableSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget() || !target.hasEntity()) {
            return SpellResult.NO_TARGET;
        }
        ArrayList<LivingEntity> targetEntities = new ArrayList<LivingEntity>();
        Entity targetedEntity = target.getEntity();
        if (target.hasEntity() && targetedEntity instanceof LivingEntity) {
            targetEntities.add((LivingEntity)targetedEntity);
        }
        int radius = parameters.getInt("radius", 0);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        if (radius > 0) {
            List<Entity> entities = CompatibilityUtils.getNearbyEntities(this.location, radius, radius, radius);
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || entity == targetedEntity) continue;
                targetEntities.add((LivingEntity)entity);
            }
        }
        if (targetEntities.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int fallProtection = parameters.getInt("fall_protection", 0);
        Integer duration = null;
        if (parameters.contains("duration")) {
            duration = parameters.getInt("duration");
        }
        Collection<PotionEffect> effects = PotionEffectSpell.getPotionEffects(parameters, duration);
        for (LivingEntity targetEntity : targetEntities) {
            Mage targetMage;
            Mage mage = targetMage = this.controller.isMage((Entity)targetEntity) ? this.controller.getMage((Entity)targetEntity) : null;
            if (targetMage != null && fallProtection > 0) {
                targetMage.enableFallProtection(fallProtection);
            }
            if (targetEntity != this.mage.getEntity() && targetMage != null) {
                if (this.isSuperProtected(targetMage)) continue;
                if (parameters.getBoolean("deactivate_target_mage")) {
                    targetMage.deactivateAllSpells(true, false);
                }
            }
            if (parameters.contains("damage")) {
                this.registerModified((Entity)targetEntity);
                targetEntity.damage(parameters.getDouble("damage") * (double)this.mage.getDamageMultiplier());
            } else {
                this.registerPotionEffects((Entity)targetEntity);
            }
            CompatibilityUtils.applyPotionEffects(targetEntity, effects);
            if (!parameters.contains("remove_effects")) continue;
            List removeKeys = parameters.getStringList("remove_effects");
            for (String removeKey : removeKeys) {
                PotionEffectType removeType = PotionEffectType.getByName((String)removeKey);
                targetEntity.removePotionEffect(removeType);
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

