/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;

public class FamiliarSpell
extends UndoableSpell
implements Listener {
    private final LinkedList<WeightedPair<String>> entityTypeProbability = new LinkedList();
    private final Random rand = new Random();
    private PlayerFamiliar familiars = new PlayerFamiliar();
    private int spawnCount = 0;
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.EGG;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block originalTarget;
        this.spawnCount = 0;
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = originalTarget = target.getBlock();
        LivingEntity targetEntity = null;
        boolean hasFamiliar = this.familiars.hasFamiliar();
        boolean track = parameters.getBoolean("track", true);
        if (hasFamiliar && track) {
            boolean isFamiliar;
            boolean bl = isFamiliar = target.hasEntity() && this.familiars.isFamiliar(target.getEntity());
            if (isFamiliar) {
                this.checkListener();
                this.familiars.releaseFamiliar(target.getEntity());
                return SpellResult.COST_FREE;
            }
            this.familiars.releaseFamiliar();
        }
        if (target.hasEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
            Entity e = target.getEntity();
            if (e instanceof LivingEntity) {
                targetEntity = (LivingEntity)e;
            }
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        EntityType famType = null;
        int famCount = parameters.getInt("count", 1);
        String famTypeName = parameters.getString("type", "");
        if (famTypeName != null) {
            try {
                famType = EntityType.fromName((String)famTypeName);
            }
            catch (Throwable ex) {
                this.mage.sendMessage("Unknown entity type: " + famTypeName);
                return SpellResult.FAIL;
            }
        }
        if (originalTarget.getType() == Material.WATER || originalTarget.getType() == Material.STATIONARY_WATER) {
            famType = EntityType.SQUID;
        }
        boolean spawnBaby = parameters.getBoolean("baby", false);
        ArrayList<LivingEntity> newFamiliars = new ArrayList<LivingEntity>();
        Location centerLoc = targetBlock.getLocation();
        for (int i = 0; i < famCount; ++i) {
            EntityType entityType = famType;
            if (entityType == null) {
                String randomType = (String)RandomUtils.weightedRandom(this.entityTypeProbability);
                try {
                    entityType = EntityType.fromName((String)randomType);
                }
                catch (Throwable ex) {
                    this.mage.sendMessage("Unknown entity type: " + randomType);
                    return SpellResult.FAIL;
                }
            }
            if (parameters.contains("reason")) {
                String reasonText = parameters.getString("reason").toUpperCase();
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
                }
                catch (Exception ex) {
                    this.mage.sendMessage("Unknown spawn reason: " + reasonText);
                    return SpellResult.FAIL;
                }
            }
            Location targetLoc = centerLoc.clone();
            if (famCount > 1) {
                targetLoc.setX(targetLoc.getX() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
                targetLoc.setZ(targetLoc.getZ() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
            }
            if (entityType == null) continue;
            LivingEntity entity = this.spawnFamiliar(targetLoc, entityType, targetEntity);
            if (entity != null) {
                if (spawnBaby && entity instanceof Ageable) {
                    Ageable ageable = (Ageable)entity;
                    ageable.setBaby();
                }
                newFamiliars.add(entity);
                ++this.spawnCount;
                this.registerForUndo((Entity)entity);
            }
            this.registerForUndo();
        }
        if (track) {
            this.familiars.setFamiliars(newFamiliars);
            this.checkListener();
        }
        return SpellResult.CAST;
    }

    protected LivingEntity spawnFamiliar(Location target, EntityType famType, LivingEntity targetEntity) {
        LivingEntity familiar = null;
        try {
            Entity famEntity;
            World world = this.getWorld();
            try {
                Method spawnMethod = world.getClass().getMethod("spawn", Location.class, Class.class, CreatureSpawnEvent.SpawnReason.class);
                famEntity = (Entity)spawnMethod.invoke((Object)world, target, famType.getEntityClass(), this.spawnReason);
            }
            catch (Exception ex) {
                famEntity = this.getWorld().spawnEntity(target, famType);
            }
            if (famEntity == null || !(famEntity instanceof LivingEntity)) {
                return null;
            }
            familiar = (LivingEntity)famEntity;
            if (familiar instanceof Skeleton) {
                Skeleton skellie = (Skeleton)familiar;
                skellie.getEquipment().setItemInHand(new ItemStack(Material.BOW));
            }
            if (targetEntity != null && familiar instanceof Creature) {
                ((Creature)familiar).setTarget(targetEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return familiar;
    }

    protected void checkListener() {
        if (this.familiars.hasFamiliar()) {
            this.mage.registerEvent(SpellEventType.PLAYER_QUIT, this);
        } else {
            this.mage.unregisterEvent(SpellEventType.PLAYER_QUIT, this);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerEvent event) {
        if (this.familiars.hasFamiliar()) {
            this.familiars.releaseFamiliar();
            this.checkListener();
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.spawnCount));
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        super.loadTemplate(template);
        if (template.contains("entity_types")) {
            RandomUtils.populateStringProbabilityMap(this.entityTypeProbability, template.getConfigurationSection("entity_types"), 0, 0, 0.0f);
        } else {
            this.entityTypeProbability.add(new WeightedPair<String>(Float.valueOf(100.0f), "pig"));
        }
    }

    public class PlayerFamiliar {
        public List<LivingEntity> familiars = null;

        public boolean hasFamiliar() {
            return this.familiars != null;
        }

        public void setFamiliars(List<LivingEntity> f) {
            this.familiars = f;
        }

        public void releaseFamiliar() {
            if (this.familiars != null) {
                for (LivingEntity familiar : this.familiars) {
                    familiar.setHealth(0.0);
                }
                this.familiars = null;
            }
        }

        public void releaseFamiliar(Entity entity) {
            if (this.familiars != null) {
                ArrayList<LivingEntity> iterate = new ArrayList<LivingEntity>(this.familiars);
                for (LivingEntity familiar : iterate) {
                    if (familiar.getUniqueId() != entity.getUniqueId()) continue;
                    familiar.setHealth(0.0);
                    this.familiars.remove(familiar);
                }
                this.familiars = null;
            }
        }

        public boolean isFamiliar(Entity e) {
            if (this.familiars == null) {
                return false;
            }
            for (LivingEntity c : this.familiars) {
                if (c.getEntityId() != e.getEntityId()) continue;
                return true;
            }
            return false;
        }
    }
}

