/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.RandomUtils;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.util.Vector;

public class BigBangLocationEffect
extends LocationEffect {
    public FireworkEffect firework;
    public int intensity = 2;
    public float radius = 2.0f;
    public int explosions = 10;
    public int soundInterval = 5;
    protected int step = 0;

    public BigBangLocationEffect(EffectManager effectManager, Location location) {
        super(effectManager, location);
        this.type = EffectType.REPEATING;
        this.period = 2;
        this.iterations = 400;
        FireworkEffect.Builder b = FireworkEffect.builder();
        b.withColor(Color.RED).withColor(Color.ORANGE).withColor(Color.BLACK);
        b.withFade(Color.BLACK);
        b.trail(true);
        this.firework = b.build();
    }

    @Override
    public void onRun() {
        for (int i = 0; i < this.explosions; ++i) {
            Vector v = RandomUtils.getRandomVector().multiply(this.radius);
            this.detonate(v);
            if (this.step % this.soundInterval != 0) continue;
            this.location.getWorld().playSound(this.location, Sound.EXPLODE, 100.0f, 1.0f);
        }
        ++this.step;
    }

    protected void detonate(Vector v) {
        Firework fw = (Firework)this.location.getWorld().spawnEntity(this.location.add(v), EntityType.FIREWORK);
        this.location.subtract(v);
        FireworkMeta meta = fw.getFireworkMeta();
        meta.setPower(0);
        for (int i = 0; i < this.intensity; ++i) {
            meta.addEffect(this.firework);
        }
        fw.setFireworkMeta(meta);
        fw.detonate();
    }
}

