/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.Disposable;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public final class EffectManager
implements Disposable {
    private final Plugin owningPlugin;
    private final Map<Effect, BukkitTask> effects;
    private static List<EffectManager> effectManagers;
    private boolean disposed;
    private boolean disposeOnTermination;

    public static void initialize() {
        effectManagers = new ArrayList<EffectManager>();
    }

    public static List<EffectManager> getManagers() {
        if (effectManagers == null) {
            EffectManager.initialize();
        }
        return effectManagers;
    }

    public static void disposeAll() {
        if (effectManagers != null) {
            Iterator<EffectManager> i = effectManagers.iterator();
            while (i.hasNext()) {
                EffectManager em = i.next();
                i.remove();
                em.dispose();
            }
        }
    }

    public EffectManager(Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        this.effects = new HashMap<Effect, BukkitTask>();
        this.disposed = false;
        this.disposeOnTermination = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Effect effect) {
        if (this.disposed) {
            throw new IllegalStateException("EffectManager is disposed and not able to accept any effects.");
        }
        if (this.disposeOnTermination) {
            throw new IllegalStateException("EffectManager is awaiting termination to dispose and not able to accept any effects.");
        }
        if (this.effects.containsKey(effect)) {
            effect.cancel(false);
        }
        BukkitScheduler s = Bukkit.getScheduler();
        BukkitTask task = null;
        switch (effect.type) {
            case INSTANT: {
                task = s.runTask(this.owningPlugin, (Runnable)effect);
                break;
            }
            case DELAYED: {
                task = s.runTaskLater(this.owningPlugin, (Runnable)effect, (long)effect.delay);
                break;
            }
            case REPEATING: {
                task = s.runTaskTimer(this.owningPlugin, (Runnable)effect, (long)effect.delay, (long)effect.period);
            }
        }
        EffectManager effectManager = this;
        synchronized (effectManager) {
            this.effects.put(effect, task);
        }
    }

    public Effect[] start(String effectClass, ConfigurationSection parameters, Location origin, Location target) {
        return this.start(effectClass, parameters, origin, target, null, null);
    }

    public Effect[] start(String effectClass, ConfigurationSection parameters, Location origin, Location target, Entity originEntity, Entity targetEntity) {
        return this.start(effectClass, parameters, origin, target, originEntity, targetEntity);
    }

    public Effect[] start(String effectClass, ConfigurationSection parameters, Location origin, Location target, Entity originEntity, Entity targetEntity, Map<String, String> textMap) {
        Class<?> effectLibClass = null;
        try {
            if (!effectClass.contains(".")) {
                effectClass = "com.elmakers.mine.bukkit.slikey.effectlib.effect." + effectClass;
            }
            effectLibClass = Class.forName(effectClass);
        }
        catch (Throwable ex) {
            this.owningPlugin.getLogger().info("Error loading EffectLib class: " + effectClass + ": " + ex.getMessage());
            return null;
        }
        Effect[] effects = this.tryPointConstructor(effectLibClass, origin, target);
        if (effects == null && (effects = this.tryEntityConstructor(effectLibClass, originEntity, targetEntity)) == null) {
            effects = this.tryLineConstructor(effectLibClass, origin, target);
        }
        if (effects == null) {
            return null;
        }
        Set keys = parameters.getKeys(false);
        for (Effect effect : effects) {
            for (String key : keys) {
                if (key.equals("class") || this.setField(effect, key, parameters, textMap)) continue;
                this.owningPlugin.getLogger().warning("Unable to assign EffectLib property " + key + " of class " + effectLibClass.getName());
            }
            try {
                Method startMethod = effectLibClass.getMethod("start", new Class[0]);
                startMethod.invoke((Object)effect, new Object[0]);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return effects;
    }

    protected boolean setField(Object effect, String key, ConfigurationSection section, Map<String, String> textMap) {
        try {
            Field field = effect.getClass().getField(key);
            if (field.getType().equals(Integer.TYPE)) {
                field.set(effect, section.getInt(key));
            } else if (field.getType().equals(Float.TYPE)) {
                field.set(effect, Float.valueOf((float)section.getDouble(key)));
            } else if (field.getType().equals(Double.TYPE)) {
                field.set(effect, section.getDouble(key));
            } else if (field.getType().equals(Boolean.TYPE)) {
                field.set(effect, section.getBoolean(key));
            } else if (field.getType().equals(Long.TYPE)) {
                field.set(effect, section.getLong(key));
            } else if (field.getType().isAssignableFrom(String.class)) {
                String value = section.getString(key);
                if (textMap != null) {
                    for (Map.Entry<String, String> replaceEntry : textMap.entrySet()) {
                        value = value.replace(replaceEntry.getKey(), replaceEntry.getValue());
                    }
                }
                field.set(effect, value);
            } else if (field.getType().isAssignableFrom(ParticleEffect.class)) {
                String typeName = section.getString(key);
                ParticleEffect particleType = ParticleEffect.valueOf(typeName.toUpperCase());
                field.set(effect, (Object)particleType);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected Effect[] tryPointConstructor(Class<? extends Effect> effectLibClass, Location origin, Location target) {
        if (origin == null && target == null) {
            return null;
        }
        Effect[] players = null;
        try {
            Constructor<? extends Effect> constructor = effectLibClass.getConstructor(EffectManager.class, Location.class);
            if (target != null && origin != null) {
                players = new Effect[]{constructor.newInstance(this, target), constructor.newInstance(this, origin)};
            } else if (target != null) {
                players = new Effect[]{constructor.newInstance(this, target)};
            } else if (origin != null) {
                players = new Effect[]{constructor.newInstance(this, origin)};
            }
        }
        catch (Exception ex) {
            players = null;
        }
        return players;
    }

    protected Effect[] tryEntityConstructor(Class<? extends Effect> effectLibClass, Entity origin, Entity target) {
        if (target == null && origin == null) {
            return null;
        }
        Effect[] players = null;
        try {
            Constructor<? extends Effect> constructor = effectLibClass.getConstructor(EffectManager.class, Entity.class);
            if (target != null && origin != null) {
                players = new Effect[]{constructor.newInstance(this, target), constructor.newInstance(this, origin)};
            } else if (target != null) {
                players = new Effect[]{constructor.newInstance(this, target)};
            } else if (origin != null) {
                players = new Effect[]{constructor.newInstance(this, origin)};
            }
        }
        catch (Exception ex) {
            players = null;
        }
        return players;
    }

    protected Effect[] tryLineConstructor(Class<? extends Effect> effectLibClass, Location origin, Location target) {
        if (origin == null || target == null) {
            return null;
        }
        Effect[] players = null;
        try {
            Constructor<? extends Effect> constructor = effectLibClass.getConstructor(EffectManager.class, Location.class, Location.class);
            players = new Effect[]{constructor.newInstance(this, origin, target)};
        }
        catch (Exception ex) {
            players = null;
        }
        return players;
    }

    public void cancel(boolean callback) {
        for (Map.Entry<Effect, BukkitTask> entry : this.effects.entrySet()) {
            entry.getKey().cancel(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(Effect effect) {
        EffectManager effectManager = this;
        synchronized (effectManager) {
            BukkitTask existingTask = this.effects.get(effect);
            if (existingTask != null) {
                existingTask.cancel();
            }
            this.effects.remove(effect);
        }
        if (effect.callback != null) {
            Bukkit.getScheduler().runTask(this.owningPlugin, effect.callback);
        }
        if (this.disposeOnTermination && this.effects.size() == 0) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.cancel(false);
        if (effectManagers != null) {
            effectManagers.remove(this);
        }
    }

    public void disposeOnTermination() {
        this.disposeOnTermination = true;
        if (this.effects.size() == 0) {
            this.dispose();
        }
    }
}

