/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.Schematic;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.BufferedMapCanvas;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialBrush {
    public static final String ERASE_MATERIAL_KEY = "erase";
    public static final String COPY_MATERIAL_KEY = "copy";
    public static final String CLONE_MATERIAL_KEY = "clone";
    public static final String REPLICATE_MATERIAL_KEY = "replicate";
    public static final String MAP_MATERIAL_KEY = "map";
    public static final String SCHEMATIC_MATERIAL_KEY = "schematic";
    public static final String[] SPECIAL_MATERIAL_KEYS = new String[]{"erase", "copy", "clone", "replicate", "map"};
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.SUGAR;
    public static Material CloneMaterial = Material.NETHER_STALK;
    public static Material ReplicateMaterial = Material.PUMPKIN_SEEDS;
    public static Material MapMaterial = Material.MAP;
    public static Material SchematicMaterial = Material.PAPER;
    public static boolean SchematicsEnabled = false;
    public static final Material DEFAULT_MATERIAL = Material.DIRT;
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneSource = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private Vector targetOffset = null;
    private String targetWorldName = null;
    private final Mage mage;
    private short mapId = (short)-1;
    private BufferedMapCanvas mapCanvas = null;
    private Material mapMaterialBase = Material.STAINED_CLAY;
    private Schematic schematic;
    private String schematicName = "";
    private boolean fillWithAir = true;
    private Vector orientVector = null;

    public MaterialBrush(Mage mage, Material material, byte data) {
        super(material, data);
        this.mage = mage;
    }

    public MaterialBrush(Mage mage, Location location, String materialKey) {
        super(DEFAULT_MATERIAL, (byte)0);
        this.mage = mage;
        this.update(materialKey);
        this.activate(location, materialKey);
    }

    public static String getMaterialKey(Material material) {
        return MaterialBrush.getMaterialKey(material, true);
    }

    public static String getMaterialKey(Material material, boolean allowItems) {
        String materialKey = null;
        if (material == null) {
            return null;
        }
        if (material == EraseMaterial) {
            materialKey = ERASE_MATERIAL_KEY;
        } else if (material == CopyMaterial) {
            materialKey = COPY_MATERIAL_KEY;
        } else if (material == CloneMaterial) {
            materialKey = CLONE_MATERIAL_KEY;
        } else if (material == MapMaterial) {
            materialKey = MAP_MATERIAL_KEY;
        } else if (material == ReplicateMaterial) {
            materialKey = REPLICATE_MATERIAL_KEY;
        } else if (SchematicsEnabled && material == SchematicMaterial) {
            materialKey = SCHEMATIC_MATERIAL_KEY;
        } else if (allowItems || material.isBlock()) {
            materialKey = material.name().toLowerCase();
        }
        return materialKey;
    }

    public static String getMaterialKey(Material material, byte data) {
        return MaterialBrush.getMaterialKey(material, data, true);
    }

    public static String getMaterialKey(Material material, byte data, boolean allowItems) {
        String materialKey = MaterialBrush.getMaterialKey(material, allowItems);
        if (materialKey == null) {
            return null;
        }
        if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        return materialKey;
    }

    public static String getMaterialKey(MaterialAndData materialData) {
        return MaterialBrush.getMaterialKey(materialData.getMaterial(), materialData.getData(), true);
    }

    public static String getMaterialKey(MaterialAndData materialData, boolean allowItems) {
        return MaterialBrush.getMaterialKey(materialData.getMaterial(), materialData.getData(), allowItems);
    }

    public static boolean isSpecialMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        return COPY_MATERIAL_KEY.equals(materialKey = MaterialBrush.splitMaterialKey(materialKey)[0]) || ERASE_MATERIAL_KEY.equals(materialKey) || REPLICATE_MATERIAL_KEY.equals(materialKey) || CLONE_MATERIAL_KEY.equals(materialKey) || MAP_MATERIAL_KEY.equals(materialKey) || SchematicsEnabled && SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static String getMaterialName(MaterialAndData material) {
        return MaterialBrush.getMaterialName(MaterialBrush.getMaterialKey(material));
    }

    public static String getMaterialName(Material material, byte data) {
        return MaterialBrush.getMaterialName(MaterialBrush.getMaterialKey(material, data));
    }

    public static String getMaterialName(String materialKey) {
        if (materialKey == null) {
            return null;
        }
        String materialName = materialKey;
        String[] namePieces = MaterialBrush.splitMaterialKey(materialName);
        if (namePieces.length == 0) {
            return null;
        }
        materialName = namePieces[0];
        if (materialName.startsWith(SCHEMATIC_MATERIAL_KEY) && namePieces.length > 1) {
            materialName = namePieces[1];
        } else if (!MaterialBrush.isSpecialMaterialKey(materialKey)) {
            return MaterialAndData.getMaterialName(materialKey);
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    @Override
    public String getName() {
        String brushKey = this.getKey();
        switch (this.mode) {
            case CLONE: {
                brushKey = CLONE_MATERIAL_KEY;
                break;
            }
            case REPLICATE: {
                brushKey = REPLICATE_MATERIAL_KEY;
                break;
            }
            case COPY: {
                brushKey = COPY_MATERIAL_KEY;
                break;
            }
            case MAP: {
                brushKey = MAP_MATERIAL_KEY;
                break;
            }
            case SCHEMATIC: {
                brushKey = "schematic:" + this.schematicName;
                break;
            }
        }
        return MaterialBrush.getMaterialName(brushKey);
    }

    public static MaterialAndData parseMaterialKey(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey, true);
    }

    public static MaterialAndData parseMaterialKey(String materialKey, boolean allowItems) {
        if (materialKey == null || materialKey.length() == 0) {
            return null;
        }
        Material material = DEFAULT_MATERIAL;
        byte data = 0;
        String customName = "";
        String[] pieces = MaterialBrush.splitMaterialKey(materialKey);
        if (materialKey.equals(ERASE_MATERIAL_KEY)) {
            material = EraseMaterial;
        } else if (materialKey.equals(COPY_MATERIAL_KEY)) {
            material = CopyMaterial;
        } else if (materialKey.equals(CLONE_MATERIAL_KEY)) {
            material = CloneMaterial;
        } else if (materialKey.equals(REPLICATE_MATERIAL_KEY)) {
            material = ReplicateMaterial;
        } else if (materialKey.equals(MAP_MATERIAL_KEY)) {
            material = MapMaterial;
        } else if (SchematicsEnabled && pieces[0].equals(SCHEMATIC_MATERIAL_KEY) && pieces.length > 1) {
            material = SchematicMaterial;
            customName = pieces[1];
        } else {
            MaterialAndData basic = new MaterialAndData(materialKey);
            if (!allowItems && !basic.getMaterial().isBlock()) {
                return null;
            }
            return basic;
        }
        return new MaterialAndData(material, data, customName);
    }

    public static boolean isValidMaterial(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey) != null;
    }

    public static boolean isValidMaterial(String materialKey, boolean allowItems) {
        return MaterialBrush.parseMaterialKey(materialKey, allowItems) != null;
    }

    @Override
    public void setMaterial(Material material, byte data) {
        if (!this.mage.isRestricted(material) && material.isBlock()) {
            super.setMaterial(material, data);
            this.mode = BrushMode.MATERIAL;
            this.isValid = true;
        } else {
            this.isValid = false;
        }
        this.fillWithAir = true;
    }

    public void enableCloning() {
        if (this.mode != BrushMode.CLONE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.CLONE;
        }
    }

    public void enableErase() {
        if (this.mode != BrushMode.ERASE) {
            this.setMaterial(Material.AIR);
            this.mode = BrushMode.ERASE;
            this.fillWithAir = true;
        }
    }

    public void enableMap() {
        this.fillWithAir = false;
        this.mode = BrushMode.MAP;
        if (this.material == Material.WOOL || this.material == Material.STAINED_CLAY || this.material.getId() == 95 || this.material.getId() == 160 || this.material == Material.CARPET) {
            this.mapMaterialBase = this.material;
        }
    }

    public void enableSchematic(String name) {
        if (this.mode != BrushMode.SCHEMATIC) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.SCHEMATIC;
        }
        this.schematicName = name;
        this.schematic = null;
    }

    public void clearSchematic() {
        this.schematic = null;
    }

    public void enableReplication() {
        if (this.mode != BrushMode.REPLICATE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.REPLICATE;
        }
    }

    @Override
    public void setData(byte data) {
        this.data = data;
    }

    public void setMapId(short mapId) {
        this.mapCanvas = null;
        this.mapId = mapId;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneSource = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void clearCloneLocation() {
        this.cloneSource = null;
        this.materialTarget = null;
    }

    public void clearCloneTarget() {
        this.cloneTarget = null;
        this.targetOffset = null;
        this.targetWorldName = null;
    }

    public void setTargetOffset(Vector offset, String worldName) {
        this.targetOffset = offset.clone();
        this.targetWorldName = worldName;
    }

    public boolean hasCloneTarget() {
        return this.cloneSource != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    @Override
    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public Location toTargetLocation(Location target) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneSource.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        return translated;
    }

    public Location fromTargetLocation(World targetWorld, Location target) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        translated.setX((double)translated.getBlockX());
        translated.setY((double)translated.getBlockY());
        translated.setZ((double)translated.getBlockZ());
        Vector cloneVector = new Vector(this.cloneSource.getBlockX(), this.cloneSource.getBlockY(), this.cloneSource.getBlockZ());
        translated.subtract(cloneVector);
        Vector cloneTargetVector = new Vector(this.cloneTarget.getBlockX(), this.cloneTarget.getBlockY(), this.cloneTarget.getBlockZ());
        translated.add(cloneTargetVector);
        translated.setWorld(targetWorld);
        return translated;
    }

    @Override
    public boolean update(Mage fromMage, Location target) {
        Vector diff;
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            if (this.cloneSource == null) {
                this.isValid = false;
                return true;
            }
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            if (this.materialTarget.getY() < 0.0 || this.materialTarget.getY() > (double)fromMage.getController().getMaxY()) {
                this.isValid = false;
            } else {
                Block block = this.materialTarget.getBlock();
                if (!block.getChunk().isLoaded()) {
                    return false;
                }
                this.updateFrom(block, fromMage.getRestrictedMaterials());
                boolean bl = this.isValid = this.fillWithAir || this.material != Material.AIR;
            }
        }
        if (this.mode == BrushMode.SCHEMATIC) {
            if (this.schematic == null) {
                if (this.schematicName.length() == 0) {
                    this.isValid = false;
                    return true;
                }
                this.schematic = this.mage.getController().loadSchematic(this.schematicName);
                if (this.schematic == null) {
                    this.schematicName = "";
                    this.isValid = false;
                    return true;
                }
            }
            if (this.cloneTarget == null) {
                this.isValid = false;
                return true;
            }
            diff = target.toVector().subtract(this.cloneTarget.toVector());
            com.elmakers.mine.bukkit.api.block.MaterialAndData newMaterial = this.schematic.getBlock(diff);
            if (newMaterial == null) {
                this.isValid = false;
            } else {
                this.updateFrom(newMaterial);
                boolean bl = this.isValid = this.fillWithAir || newMaterial.getMaterial() != Material.AIR;
            }
        }
        if (this.mode == BrushMode.MAP && this.mapId >= 0) {
            if (this.mapCanvas == null && fromMage != null) {
                try {
                    MapView mapView = Bukkit.getMap((short)this.mapId);
                    if (mapView != null) {
                        Player player = fromMage.getPlayer();
                        List renderers = mapView.getRenderers();
                        if (renderers.size() > 0 && player != null) {
                            this.mapCanvas = new BufferedMapCanvas();
                            MapRenderer renderer = (MapRenderer)renderers.get(0);
                            renderer.initialize(mapView);
                            renderer.render(mapView, (MapCanvas)this.mapCanvas, player);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.isValid = false;
            if (this.mapCanvas != null && this.cloneTarget != null) {
                diff = target.toVector().subtract(this.cloneTarget.toVector());
                DyeColor mapColor = DyeColor.WHITE;
                mapColor = this.orientVector.getBlockY() > this.orientVector.getBlockZ() || this.orientVector.getBlockY() > this.orientVector.getBlockX() ? (this.orientVector.getBlockX() > this.orientVector.getBlockZ() ? this.mapCanvas.getDyeColor(Math.abs(diff.getBlockX() * 8 + BufferedMapCanvas.CANVAS_WIDTH / 2) % BufferedMapCanvas.CANVAS_WIDTH, Math.abs(-diff.getBlockY() * 8 + BufferedMapCanvas.CANVAS_HEIGHT / 2) % BufferedMapCanvas.CANVAS_HEIGHT) : this.mapCanvas.getDyeColor(Math.abs(diff.getBlockZ() * 8 + BufferedMapCanvas.CANVAS_WIDTH / 2) % BufferedMapCanvas.CANVAS_WIDTH, Math.abs(-diff.getBlockY() * 8 + BufferedMapCanvas.CANVAS_HEIGHT / 2) % BufferedMapCanvas.CANVAS_HEIGHT)) : this.mapCanvas.getDyeColor(Math.abs(diff.getBlockX() * 8 + BufferedMapCanvas.CANVAS_WIDTH / 2) % BufferedMapCanvas.CANVAS_WIDTH, Math.abs(diff.getBlockZ() * 8 + BufferedMapCanvas.CANVAS_HEIGHT / 2) % BufferedMapCanvas.CANVAS_HEIGHT);
                if (mapColor != null) {
                    super.setMaterial(this.mapMaterialBase, mapColor.getData());
                    this.isValid = true;
                }
            }
        }
        return true;
    }

    @Override
    public void prepare() {
        Block block;
        if (this.cloneSource != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    public void load(ConfigurationSection node) {
        try {
            this.cloneSource = ConfigurationUtils.getLocation(node, "clone_location");
            this.cloneTarget = ConfigurationUtils.getLocation(node, "clone_target");
            this.materialTarget = ConfigurationUtils.getLocation(node, "material_target");
            this.schematicName = node.getString(SCHEMATIC_MATERIAL_KEY, this.schematicName);
            this.mapId = (short)node.getInt("map_id", (int)this.mapId);
            this.material = ConfigurationUtils.getMaterial(node, "material", this.material);
            this.data = (byte)node.getInt("data", (int)this.data.byteValue());
            this.customName = node.getString("extra_data", this.customName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mage.getController().getLogger().warning("Failed to load brush data: " + ex.getMessage());
        }
    }

    public void save(ConfigurationSection node) {
        try {
            if (this.cloneSource != null) {
                node.set("clone_location", (Object)ConfigurationUtils.fromLocation(this.cloneSource));
            }
            if (this.cloneTarget != null) {
                node.set("clone_target", (Object)ConfigurationUtils.fromLocation(this.cloneTarget));
            }
            if (this.materialTarget != null) {
                node.set("material_target", (Object)ConfigurationUtils.fromLocation(this.materialTarget));
            }
            node.set("map_id", (Object)this.mapId);
            node.set("material", (Object)ConfigurationUtils.fromMaterial(this.material));
            node.set("data", (Object)this.data);
            node.set("extra_data", (Object)this.customName);
            node.set(SCHEMATIC_MATERIAL_KEY, (Object)this.schematicName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mage.getController().getLogger().warning("Failed to save brush data: " + ex.getMessage());
        }
    }

    @Override
    public boolean hasEntities() {
        return this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE;
    }

    @Override
    public Collection<Entity> getTargetEntities() {
        if (this.cloneTarget == null) {
            return null;
        }
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            ArrayList<Entity> targetData = new ArrayList<Entity>();
            World targetWorld = this.cloneTarget.getWorld();
            List targetEntities = targetWorld.getEntities();
            for (Entity entity : targetEntities) {
                if (entity instanceof Player || !this.mage.getController().isNPC(entity)) continue;
                targetData.add(entity);
            }
            return targetData;
        }
        return null;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities() {
        if (this.cloneTarget == null || this.cloneSource == null) {
            return null;
        }
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData> copyEntities = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
            World sourceWorld = this.cloneSource.getWorld();
            List entities = sourceWorld.getEntities();
            for (Entity entity : entities) {
                if (entity instanceof Player || entity instanceof Item) continue;
                Location entityLocation = entity.getLocation();
                Location translated = this.fromTargetLocation(this.cloneTarget.getWorld(), entityLocation);
                EntityData entityData = new EntityData(translated, entity);
                copyEntities.add(entityData);
            }
            return copyEntities;
        }
        if (this.mode == BrushMode.SCHEMATIC && this.schematic != null) {
            return this.schematic.getEntities();
        }
        return null;
    }

    @Override
    public void activate(Location location, String material) {
        String materialKey = MaterialBrush.splitMaterialKey(material)[0];
        if (materialKey.equals(CLONE_MATERIAL_KEY) || materialKey.equals(REPLICATE_MATERIAL_KEY) && location != null) {
            Location cloneFrom = location.clone();
            cloneFrom.setY(cloneFrom.getY() - 1.0);
            this.setCloneLocation(cloneFrom);
        } else if (materialKey.equals(MAP_MATERIAL_KEY) || materialKey.equals(SCHEMATIC_MATERIAL_KEY)) {
            this.clearCloneTarget();
        }
    }

    @Override
    public void update(String activeMaterial) {
        String[] pieces = MaterialBrush.splitMaterialKey(activeMaterial);
        if (activeMaterial.equals(COPY_MATERIAL_KEY)) {
            this.enableCopying();
        } else if (activeMaterial.equals(CLONE_MATERIAL_KEY)) {
            this.enableCloning();
        } else if (activeMaterial.equals(REPLICATE_MATERIAL_KEY)) {
            this.enableReplication();
        } else if (activeMaterial.equals(MAP_MATERIAL_KEY)) {
            this.enableMap();
        } else if (activeMaterial.equals(ERASE_MATERIAL_KEY)) {
            this.enableErase();
        } else if (pieces.length > 1 && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
            this.enableSchematic(pieces[1]);
        } else {
            MaterialAndData material = MaterialBrush.parseMaterialKey(activeMaterial);
            if (material != null) {
                this.setMaterial(material.getMaterial(), material.getData());
            }
        }
    }

    @Override
    public void setTarget(Location target) {
        this.setTarget(target, target);
    }

    @Override
    public void setTarget(Location target, Location center) {
        this.orientVector = target.toVector().subtract(center.toVector());
        this.orientVector.setX(Math.abs(this.orientVector.getX()));
        this.orientVector.setY(Math.abs(this.orientVector.getY()));
        this.orientVector.setZ(Math.abs(this.orientVector.getZ()));
        if (this.mode == BrushMode.REPLICATE || this.mode == BrushMode.CLONE || this.mode == BrushMode.MAP || this.mode == BrushMode.SCHEMATIC) {
            if (this.cloneTarget == null || this.mode == BrushMode.CLONE || !center.getWorld().getName().equals(this.cloneTarget.getWorld().getName())) {
                this.cloneTarget = center;
                if (this.targetOffset != null) {
                    this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                }
            } else if (this.mode == BrushMode.SCHEMATIC) {
                if (this.schematic == null && this.schematicName != null) {
                    this.schematic = this.mage.getController().loadSchematic(this.schematicName);
                }
                boolean recenter = true;
                if (this.schematic != null) {
                    Vector diff = target.toVector().subtract(this.cloneTarget.toVector());
                    boolean bl = recenter = !this.schematic.contains(diff);
                }
                if (recenter) {
                    this.cloneTarget = center;
                    if (this.targetOffset != null) {
                        this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                    }
                }
            }
            if (this.cloneSource == null) {
                this.cloneSource = this.cloneTarget.clone();
                if (this.targetWorldName != null && this.targetWorldName.length() > 0) {
                    World sourceWorld = this.cloneSource.getWorld();
                    this.cloneSource.setWorld(ConfigurationUtils.overrideWorld(this.targetWorldName, sourceWorld, this.mage.getController().canCreateWorlds()));
                }
            }
            if (this.materialTarget == null) {
                this.materialTarget = this.cloneTarget;
            }
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            if (this.targetOffset != null) {
                Location targetLocation = block.getLocation();
                targetLocation = targetLocation.add(this.targetOffset);
                block = targetLocation.getBlock();
            }
            this.updateFrom(block, this.mage.getRestrictedMaterials());
        }
    }

    private static enum BrushMode {
        MATERIAL,
        ERASE,
        COPY,
        CLONE,
        REPLICATE,
        MAP,
        SCHEMATIC;

    }
}

