/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected Material material;
    protected Byte data;
    protected String[] signLines = null;
    protected String commandLine = null;
    protected String customName = null;
    protected ItemStack[] inventoryContents = null;
    protected boolean isValid = true;
    public Material DEFAULT_MATERIAL;

    public MaterialAndData() {
        this.material = this.DEFAULT_MATERIAL = Material.AIR;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, byte data) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = item.getType();
        this.data = (byte)item.getDurability();
    }

    public MaterialAndData(Block block) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(other);
    }

    public MaterialAndData(Material material, byte data, String customName) {
        this(material, data);
        this.customName = customName;
    }

    public MaterialAndData(String materialKey) {
        this();
        if (materialKey == null || materialKey.length() == 0) {
            this.isValid = false;
            return;
        }
        String[] pieces = MaterialAndData.splitMaterialKey(materialKey);
        try {
            if (pieces.length > 0) {
                if (pieces[0].equals("*")) {
                    this.material = null;
                } else {
                    try {
                        Integer id = Integer.parseInt(pieces[0]);
                        this.material = Material.getMaterial((int)id);
                    }
                    catch (Exception ex) {
                        this.material = Material.getMaterial((String)pieces[0].toUpperCase());
                    }
                }
            }
        }
        catch (Exception ex) {
            this.material = null;
        }
        try {
            if (pieces.length > 1) {
                this.data = pieces[1].equals("*") ? null : Byte.valueOf(Byte.parseByte(pieces[1]));
            }
        }
        catch (Exception ex) {
            if (this.material == Material.SKULL || this.material == Material.MOB_SPAWNER) {
                this.customName = pieces[1];
                this.data = 3;
            }
            if (this.material == Material.SKULL || this.material == Material.MOB_SPAWNER) {
                this.customName = pieces[1];
                this.data = 0;
            }
            this.data = 0;
            this.customName = "";
        }
        if (this.material == null) {
            this.isValid = false;
            this.material = this.DEFAULT_MATERIAL;
            this.data = 0;
            this.customName = "";
        }
    }

    public int hashCode() {
        return this.material.getId() << 8 | this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialAndData)) {
            return false;
        }
        MaterialAndData other = (MaterialAndData)obj;
        return other.data == this.data && other.material == this.material;
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.commandLine = o.commandLine;
            this.inventoryContents = o.inventoryContents;
            this.signLines = o.signLines;
            this.customName = o.customName;
            this.isValid = o.isValid;
        }
    }

    @Override
    public void setMaterial(Material material, byte data) {
        this.material = material;
        this.data = data;
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.customName = null;
        this.isValid = true;
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (byte)0);
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFrom(block, null);
    }

    public void updateFrom(Block block, Set<Material> restrictedMaterials) {
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        Material blockMaterial = block.getType();
        if (restrictedMaterials != null && restrictedMaterials.contains(blockMaterial)) {
            this.isValid = false;
            return;
        }
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.customName = null;
        try {
            BlockState blockState = block.getState();
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                this.signLines = sign.getLines();
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.commandLine = command.getCommand();
                this.customName = command.getName();
            } else if (blockState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)blockState;
                Inventory holderInventory = holder.getInventory();
                this.inventoryContents = holderInventory.getContents();
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                this.customName = skull.getOwner();
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.customName = spawner.getCreatureTypeName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.material = blockMaterial;
        this.data = block.getData();
        this.isValid = true;
    }

    public static void removeMetadata(Block block, String key) {
        List metadata = block.getMetadata(key);
        for (MetadataValue value : metadata) {
            block.removeMetadata(key, value.getOwningPlugin());
        }
    }

    @Override
    public void modify(Block block) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState blockState;
            MaterialAndData.removeMetadata(block, "breakable");
            MaterialAndData.removeMetadata(block, "backfire");
            BlockState oldState = block.getState();
            if (oldState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)oldState;
                Inventory inventory = holder.getInventory();
                inventory.clear();
            }
            if (this.material != null) {
                block.setType(this.material);
            }
            if (this.data != null) {
                block.setData(this.data.byteValue());
            }
            if ((blockState = block.getState()) instanceof Sign && this.signLines != null) {
                Sign sign = (Sign)blockState;
                for (int i = 0; i < this.signLines.length; ++i) {
                    sign.setLine(i, this.signLines[i]);
                }
                sign.update();
            } else if (blockState instanceof CommandBlock && this.commandLine != null) {
                CommandBlock command = (CommandBlock)blockState;
                command.setCommand(this.commandLine);
                if (this.customName != null) {
                    command.setName(this.customName);
                }
                command.update();
            } else if (blockState instanceof InventoryHolder && this.inventoryContents != null) {
                InventoryHolder holder = (InventoryHolder)blockState;
                Inventory newInventory = holder.getInventory();
                int maxSize = Math.min(newInventory.getSize(), this.inventoryContents.length);
                for (int i = 0; i < maxSize; ++i) {
                    ItemStack item = this.inventoryContents[i];
                    if ((item = NMSUtils.getCopy(item)) == null) continue;
                    newInventory.setItem(i, item);
                }
            } else if (blockState instanceof Skull && this.customName != null) {
                Skull skull = (Skull)blockState;
                skull.setOwner(this.customName);
                skull.update();
            } else if (blockState instanceof CreatureSpawner && this.customName != null && this.customName.length() > 0) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                spawner.setCreatureTypeByName(this.customName);
                spawner.update();
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Error updating block state: " + ex.getMessage());
        }
    }

    @Override
    public byte getData() {
        return this.data;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        String materialKey;
        String string = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (this.data == null) {
            materialKey = materialKey + ":*";
        } else if (this.material == Material.SKULL && this.data == 3 && this.customName != null && this.customName.length() > 0) {
            materialKey = materialKey + ":" + this.customName;
        } else if (this.material == Material.MOB_SPAWNER && this.customName != null && this.customName.length() > 0) {
            materialKey = materialKey + ":" + this.customName;
        } else if (this.data != 0) {
            materialKey = materialKey + ":" + this.data;
        }
        return materialKey;
    }

    @Override
    public boolean is(Block block) {
        return this.material == block.getType() && this.data.byteValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Block block) {
        CommandBlock command;
        Material blockMaterial = block.getType();
        byte blockData = block.getData();
        if (this.material != null && blockMaterial != this.material || this.data != null && blockData != this.data) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign && this.signLines != null) {
            Sign sign = (Sign)blockState;
            String[] currentLines = sign.getLines();
            for (int i = 0; i < this.signLines.length; ++i) {
                if (currentLines[i].equals(this.signLines[i])) continue;
                return true;
            }
        } else if (blockState instanceof CommandBlock && this.commandLine != null ? !(command = (CommandBlock)blockState).getCommand().equals(this.commandLine) : blockState instanceof InventoryHolder && this.inventoryContents != null) {
            return true;
        }
        return false;
    }

    @Override
    public void setSignLines(String[] lines) {
        this.signLines = (String[])lines.clone();
    }

    @Override
    public String[] getSignLines() {
        return (String[])this.signLines.clone();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setInventoryContents(ItemStack[] contents) {
        this.inventoryContents = contents;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        return new ItemStack(this.material, amount, 0, this.data);
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|");
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":");
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getName() {
        return MaterialAndData.getMaterialName(this.getKey());
    }

    public static String getMaterialName(String materialKey) {
        if (materialKey == null) {
            return null;
        }
        String materialName = materialKey;
        String[] namePieces = MaterialAndData.splitMaterialKey(materialName);
        if (namePieces.length == 0) {
            return null;
        }
        materialName = namePieces[0];
        MaterialAndData materialAndData = new MaterialAndData(materialKey);
        if (!materialAndData.isValid()) {
            return null;
        }
        Material material = materialAndData.getMaterial();
        byte data = materialAndData.getData();
        String customName = materialAndData.getCustomName();
        if (material == Material.CARPET || material.getId() == 95 || material.getId() == 159 || material.getId() == 160 || material == Material.WOOL) {
            DyeColor color = DyeColor.getByWoolData((byte)data);
            if (color != null) {
                materialName = color.name().toLowerCase().replace('_', ' ') + " " + materialName;
            }
        } else if (material == Material.WOOD || material == Material.LOG || material == Material.SAPLING || material == Material.LEAVES) {
            TreeSpecies treeSpecies = TreeSpecies.getByData((byte)data);
            if (treeSpecies != null) {
                materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
            }
        } else {
            materialName = (material == Material.SKULL || material == Material.MOB_SPAWNER) && customName != null && customName.length() > 0 ? materialName + " (" + customName + ")" : material.name();
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    @Override
    public void setCommandLine(String command) {
        this.commandLine = command;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine;
    }

    @Override
    public void setData(byte data) {
        this.data = data;
    }
}

