/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.UndoList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class BoundingBox
implements com.elmakers.mine.bukkit.api.block.BoundingBox {
    protected static final Vector UNIT_VECTOR = new Vector(1, 1, 1);
    protected BlockVector max;
    protected BlockVector min;

    public BoundingBox() {
    }

    public BoundingBox(Vector p1, Vector p2) {
        this.min = new BlockVector(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
        this.max = new BlockVector(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public BoundingBox(BlockVector min, BlockVector max) {
        this.min = min;
        this.max = max;
    }

    public BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.min = new BlockVector(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        this.max = new BlockVector(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public BoundingBox centered(Vector newCenter) {
        return this;
    }

    public BoundingBox contain(Vector newPoint) {
        if (this.contains(newPoint)) {
            return this;
        }
        BlockVector newMin = new BlockVector(Vector.getMinimum((Vector)this.min, (Vector)newPoint));
        BlockVector newMax = new BlockVector(Vector.getMaximum((Vector)this.max, (Vector)newPoint));
        this.min = newMin;
        this.max = newMax;
        return this;
    }

    @Override
    public boolean contains(Vector p) {
        return p.isInAABB((Vector)this.min, (Vector)this.max);
    }

    @Override
    public boolean contains(Vector p, int threshold) {
        if (threshold == 0) {
            return this.contains(p);
        }
        Vector adjustedMin = UNIT_VECTOR.clone().multiply(-threshold).add((Vector)this.min);
        Vector adjustedMax = UNIT_VECTOR.clone().multiply(threshold).add((Vector)this.max);
        return p.isInAABB(adjustedMin, adjustedMax);
    }

    public void fill(World world, Material material) {
        this.fill(world, material, null, null);
    }

    public void fill(World world, Material material, Set<Material> destructable) {
        this.fill(world, material, destructable, null);
    }

    public void fill(World world, Material material, Set<Material> destructable, UndoList affected) {
        for (int x = this.min.getBlockX(); x < this.max.getBlockX(); ++x) {
            for (int y = this.min.getBlockY(); y < this.max.getBlockY(); ++y) {
                for (int z = this.min.getBlockZ(); z < this.max.getBlockZ(); ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (destructable == null) {
                        if (affected != null) {
                            affected.add(block);
                        }
                        block.setType(material);
                        continue;
                    }
                    Material blockType = block.getType();
                    if (!destructable.contains(blockType)) continue;
                    if (affected != null) {
                        affected.add(block);
                    }
                    block.setType(material);
                }
            }
        }
    }

    public void getBlocks(World world, List<Block> blocks) {
        for (int x = this.min.getBlockX(); x < this.max.getBlockX(); ++x) {
            for (int y = this.min.getBlockY(); y < this.max.getBlockY(); ++y) {
                for (int z = this.min.getBlockZ(); z < this.max.getBlockZ(); ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    blocks.add(block);
                }
            }
        }
    }

    @Override
    public BlockVector getCenter() {
        Vector center = new Vector(this.min.getX(), this.min.getY(), this.min.getZ());
        center = center.getMidpoint((Vector)this.max);
        return new BlockVector(center);
    }

    public BoundingBox getFace(BlockFace face) {
        return this.getFace(face, 1, 0);
    }

    public BoundingBox getFace(BlockFace face, int thickness, int offset) {
        switch (face) {
            case UP: {
                return new BoundingBox(this.min.getBlockX(), this.max.getBlockY() + offset, this.min.getBlockZ(), this.max.getBlockX(), this.max.getBlockY() + offset + thickness, this.max.getBlockZ());
            }
            case DOWN: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY() - offset - thickness, this.min.getBlockZ(), this.max.getBlockX(), this.min.getBlockY() - offset, this.max.getBlockZ());
            }
            case WEST: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY(), this.max.getBlockZ() + offset, this.max.getBlockX(), this.max.getBlockY(), this.max.getBlockZ() + offset + thickness);
            }
            case EAST: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY(), this.min.getBlockZ() - offset - thickness, this.max.getBlockX(), this.max.getBlockY(), this.min.getBlockZ() - offset);
            }
            case SOUTH: {
                return new BoundingBox(this.max.getBlockX() + offset, this.min.getBlockY(), this.min.getBlockZ(), this.max.getBlockX() + offset + thickness, this.max.getBlockY(), this.max.getBlockZ());
            }
            case NORTH: {
                return new BoundingBox(this.min.getBlockX() - offset - thickness, this.min.getBlockY(), this.min.getBlockZ(), this.min.getBlockX() - offset, this.max.getBlockY(), this.max.getBlockZ());
            }
        }
        return null;
    }

    @Override
    public BlockVector getMax() {
        return this.max;
    }

    @Override
    public BlockVector getMin() {
        return this.min;
    }

    public int getSizeX() {
        return this.max.getBlockX() - this.min.getBlockX();
    }

    public int getSizeY() {
        return this.max.getBlockY() - this.min.getBlockY();
    }

    public int getSizeZ() {
        return this.max.getBlockZ() - this.min.getBlockZ();
    }

    public BoundingBox scale(double scale) {
        return new BoundingBox(this.min, this.max);
    }

    public void setMax(BlockVector max) {
        this.max = max;
    }

    public void setMin(BlockVector min) {
        this.min = min;
    }

    public BoundingBox translate(BlockVector direction) {
        return this;
    }
}

