/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.wand.WandLevel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public class WandUpgradePath {
    private static Map<String, WandUpgradePath> paths = new HashMap<String, WandUpgradePath>();
    private TreeMap<Integer, WandLevel> levelMap = null;
    private int[] levels = null;
    private final String key;

    public WandUpgradePath(String key, ConfigurationSection template) {
        this.key = key;
        this.levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        this.levels = new int[levelStrings.length];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = Integer.parseInt(levelStrings[i]);
        }
        for (int level = 1; level <= this.levels[this.levels.length - 1]; ++level) {
            int levelIndex;
            int nextLevelIndex = 0;
            float distance = 1.0f;
            for (levelIndex = 0; levelIndex < this.levels.length; ++levelIndex) {
                if (level == this.levels[levelIndex] || levelIndex == this.levels.length - 1) {
                    nextLevelIndex = levelIndex;
                    distance = 0.0f;
                    break;
                }
                if (level <= this.levels[levelIndex]) continue;
                nextLevelIndex = levelIndex + 1;
                int previousLevel = this.levels[levelIndex];
                int nextLevel = this.levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
            this.levelMap.put(level, new WandLevel(template, levelIndex, nextLevelIndex, distance));
        }
    }

    public String getKey() {
        return this.key;
    }

    public WandLevel getLevel(int level) {
        if (this.levelMap == null) {
            return null;
        }
        if (!this.levelMap.containsKey(level)) {
            if (level > this.levelMap.lastKey()) {
                return this.levelMap.lastEntry().getValue();
            }
            return this.levelMap.firstEntry().getValue();
        }
        return this.levelMap.get(level);
    }

    public static void loadPaths(ConfigurationSection configuration) {
        paths.clear();
        Set pathKeys = configuration.getKeys(false);
        for (String key : pathKeys) {
            WandUpgradePath path = new WandUpgradePath(key, configuration.getConfigurationSection(key));
            paths.put(key, path);
        }
    }

    public static Set<String> getPathKeys() {
        return paths.keySet();
    }

    public static WandUpgradePath getPath(String key) {
        return paths.get(key);
    }

    public int getMaxLevel() {
        if (this.levels == null) {
            return 0;
        }
        return Math.min(this.levels[this.levels.length - 1], WandLevel.maxLevel);
    }

    public Set<Integer> getLevels() {
        if (this.levels == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        int[] arr$ = this.levels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer level = arr$[i$];
            if (level < WandLevel.minLevel || level > WandLevel.maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }
}

