/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class PushSpell
extends UndoableSpell {
    private int DEFAULT_ITEM_MAGNITUDE = 1;
    private int DEFAULT_ENTITY_MAGNITUDE = 3;
    private int DEFAULT_MAX_ALL_DISTANCE = 20;

    public void forceAll(Entity sourceEntity, double mutliplier, boolean pull, int entityMagnitude, int itemMagnitude, int maxAllDistance, double damage) {
        float maxDistance = (float)maxAllDistance * this.mage.getRangeMultiplier();
        float maxDistanceSquared = maxDistance * maxDistance;
        List entities = this.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            if (target == sourceEntity || this.controller.isNPC(target) || (playerLocation = this.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)maxDistanceSquared) continue;
            Location to = pull ? targetLocation : playerLocation;
            Location from = pull ? playerLocation : targetLocation;
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(target, mutliplier, from, to, magnitude, damage);
            this.getCurrentTarget().setEntity(target);
        }
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean push = false;
        boolean pull = false;
        Entity sourceEntity = this.mage.getEntity();
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        if (push) {
            multiplier *= (double)this.mage.getDamageMultiplier();
        }
        int count = parameters.getInt("count", 0);
        boolean allowAll = parameters.getBoolean("allow_area", true);
        boolean forceArea = parameters.getBoolean("area", false);
        int itemMagnitude = parameters.getInt("item_force", this.DEFAULT_ITEM_MAGNITUDE);
        int entityMagnitude = parameters.getInt("entity_force", this.DEFAULT_ENTITY_MAGNITUDE);
        int maxAllDistance = parameters.getInt("area_range", this.DEFAULT_MAX_ALL_DISTANCE);
        double damage = parameters.getDouble("damage", 0.0) * (double)this.mage.getDamageMultiplier();
        List<Target> targets = this.getAllTargetEntities();
        if (allowAll && (forceArea || this.isLookingDown() || this.isLookingUp())) {
            this.forceAll(sourceEntity, multiplier, pull, entityMagnitude, itemMagnitude, maxAllDistance, damage);
            return SpellResult.AREA;
        }
        if (targets.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int pushed = 0;
        for (Target target : targets) {
            Entity targetEntity = target.getEntity();
            Location to = pull ? target.getLocation() : this.getLocation();
            Location from = pull ? this.getLocation() : target.getLocation();
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.getCurrentTarget().setEntity(targetEntity);
            this.forceEntity(targetEntity, multiplier, from, to, magnitude, damage);
            if (count <= 0 || ++pushed < count) continue;
            break;
        }
        return SpellResult.CAST;
    }

    protected void forceEntity(Entity target, double multiplier, Location from, Location to, int magnitude, double damage) {
        Vector fromVector;
        Mage targetMage;
        if (this.controller.isMage(target) && this.isSuperProtected(targetMage = this.controller.getMage(target))) {
            return;
        }
        if (target instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)target;
            this.registerModified((Entity)li);
            if (damage > 0.0) {
                li.damage(damage);
            }
        }
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }
}

