/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class LevitateSpell
extends TargetingSpell
implements Listener {
    private static final float defaultFlySpeed = 0.1f;
    private long levitateEnded;
    private final long safetyLength = 10000L;
    private static final int minRingEffectRange = 1;
    private static final int maxRingEffectRange = 8;
    private static final int maxDamageAmount = 150;
    private float flySpeed = 0.0f;
    private int flyDelay = 2;
    private int startDelay = 0;
    private int autoDeactivateHeight = 0;
    private int boostTicksRemaining = 0;
    private double castBoost = 0.0;
    private int boostTicks = 0;
    private double yBoost = 2.0;
    private float thrustSpeed = 0.0f;
    private int thrustFrequency = 1;
    private ThrustAction thrust;
    private double crashDistance = 0.0;
    private double slowMultiplier = 1.0;
    private Collection<PotionEffect> crashEffects;

    protected void thrust() {
        boolean checkHeight;
        if (this.thrustSpeed == 0.0f) {
            return;
        }
        Entity entity = this.mage.getEntity();
        if (entity == null) {
            return;
        }
        boolean bl = checkHeight = this.autoDeactivateHeight > 0;
        if (checkHeight && this.mage.isPlayer()) {
            checkHeight = this.mage.getPlayer().isSneaking();
        }
        if (checkHeight) {
            int height;
            Block block = entity.getLocation().getBlock();
            for (height = 0; height < this.autoDeactivateHeight && block.getType() == Material.AIR; ++height) {
                block = block.getRelative(BlockFace.DOWN);
            }
            if (height < this.autoDeactivateHeight) {
                this.land();
                return;
            }
        }
        Vector direction = entity.getLocation().getDirection();
        direction.normalize();
        if (this.crashDistance > 0.0) {
            Vector threshold = direction.clone().multiply(this.crashDistance);
            if (this.checkForCrash(this.mage.getEyeLocation(), threshold)) {
                return;
            }
            if (this.checkForCrash(this.mage.getLocation(), threshold)) {
                return;
            }
        }
        double boost = this.thrustSpeed;
        if (this.mage.getPlayer().isSneaking()) {
            boost *= this.slowMultiplier;
        } else if (this.boostTicksRemaining > 0) {
            boost += this.castBoost;
            --this.boostTicksRemaining;
        }
        direction.multiply(boost);
        entity.setVelocity(direction);
    }

    protected boolean checkForCrash(Location source, Vector threshold) {
        Block facingBlock = source.getBlock();
        Block targetBlock = source.add(threshold).getBlock();
        if (!targetBlock.equals(facingBlock) && targetBlock.getType() != Material.AIR) {
            this.deactivate(true, false);
            this.sendMessage(this.getMessage("crash"));
            this.mage.deactivateAllSpells();
            this.playEffects("crash");
            LivingEntity livingEntity = this.mage.getLivingEntity();
            if (this.crashEffects != null && livingEntity != null && this.crashEffects.size() > 0) {
                CompatibilityUtils.applyPotionEffects(livingEntity, this.crashEffects);
            }
            return true;
        }
        return false;
    }

    protected boolean checkActive() {
        if (!this.isActive()) {
            return false;
        }
        Entity entity = this.mage.getEntity();
        if (entity == null || entity.isDead()) {
            return false;
        }
        return !(entity instanceof Player) || ((Player)entity).isOnline();
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Player player = this.mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.startDelay = parameters.getInt("start_delay", 0);
        this.slowMultiplier = parameters.getDouble("slow", 1.0);
        this.castBoost = parameters.getDouble("boost", 0.0);
        this.yBoost = parameters.getDouble("y_boost", 2.0);
        this.flySpeed = (float)parameters.getDouble("speed", 0.0);
        this.thrustSpeed = (float)parameters.getDouble("thrust", 0.0);
        this.thrustFrequency = parameters.getInt("thrust_interval", this.thrustFrequency);
        this.autoDeactivateHeight = parameters.getInt("auto_deactivate", 0);
        this.boostTicks = parameters.getInt("boost_ticks", 1);
        this.crashDistance = parameters.getDouble("crash_distance", 0.0);
        this.crashEffects = LevitateSpell.getPotionEffects(parameters);
        this.thrustSpeed *= this.mage.getRadiusMultiplier();
        this.castBoost *= (double)this.mage.getRadiusMultiplier();
        if (this.isActive()) {
            if (this.castBoost != 0.0) {
                this.boostTicksRemaining += this.boostTicks;
                return SpellResult.AREA;
            }
            this.land();
            return SpellResult.COST_FREE;
        }
        this.activate();
        return SpellResult.CAST;
    }

    public void land() {
        this.deactivate(true, false);
    }

    @Override
    public void onDeactivate() {
        Player player;
        if (this.thrust != null) {
            this.thrust.stop();
            this.thrust = null;
        }
        if ((player = this.mage.getPlayer()) == null) {
            return;
        }
        if (this.flySpeed > 0.0f) {
            player.setFlySpeed(0.1f);
        }
        player.setFlying(false);
        player.setAllowFlight(false);
        this.mage.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.levitateEnded = System.currentTimeMillis();
    }

    @Override
    public void onActivate() {
        final Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.flySpeed > 0.0f) {
            player.setFlySpeed(this.flySpeed * 0.1f);
        }
        if (this.thrustSpeed > 0.0f) {
            if (this.thrust != null) {
                this.thrust.stop();
            }
            this.thrust = new ThrustAction(this, this.thrustFrequency + this.flyDelay + this.startDelay, this.thrustFrequency);
        }
        Vector velocity = player.getVelocity();
        velocity.setY(velocity.getY() + this.yBoost);
        player.setVelocity(velocity);
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                player.setAllowFlight(true);
                player.setFlying(true);
            }
        }, (long)this.flyDelay);
    }

    @Override
    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.mage.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.levitateEnded == 0L) {
            return;
        }
        if (this.levitateEnded + 10000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.levitateEnded = 0L;
            int ringEffectRange = (int)Math.ceil(7.0 * event.getDamage() / 150.0 + 1.0);
            ringEffectRange = Math.min(8, ringEffectRange);
            this.playEffects("land", ringEffectRange);
        }
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        Block block = this.mage.getEntity().getLocation().getBlock();
        block = block.getRelative(BlockFace.DOWN);
        return new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    public class ThrustAction
    implements Runnable {
        private final LevitateSpell spell;
        private final int taskId;

        public ThrustAction(LevitateSpell spell, int delay, int interval) {
            Plugin plugin = spell.getMage().getController().getPlugin();
            this.spell = spell;
            BukkitScheduler scheduler = Bukkit.getScheduler();
            this.taskId = scheduler.scheduleSyncRepeatingTask(plugin, (Runnable)this, (long)delay, (long)interval);
        }

        public void stop() {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }

        @Override
        public void run() {
            if (!this.spell.checkActive()) {
                return;
            }
            Entity entity = this.spell.getMage().getEntity();
            if (entity == null || entity.isDead()) {
                this.spell.land();
                return;
            }
            if (entity instanceof Player && !((Player)entity).isOnline()) {
                this.spell.land();
                return;
            }
            this.spell.thrust();
        }
    }
}

