/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FrostSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ELEMENTAL_DAMAGE = 10;
    private static final int DEFALT_ENTITY_DAMAGE = 10;
    private static final int DEFAULT_SLOWNESS = 1;
    private static final int DEFAULT_SLOWNESS_DURATION = 200;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInt("player_damage", 1);
        int entityDamage = parameters.getInt("entity_damage", 10);
        int defaultRadius = parameters.getInt("radius", 2);
        int slowness = parameters.getInt("slowness", 1);
        int slownessDuration = parameters.getInt("slowness_duration", 200);
        Material iceMaterial = ConfigurationUtils.getMaterial(parameters, "ice", Material.ICE);
        if (target.hasEntity()) {
            Entity targetEntity = target.getEntity();
            if (targetEntity instanceof LivingEntity) {
                this.registerModified(targetEntity);
                LivingEntity li = (LivingEntity)targetEntity;
                if (slowness > 0) {
                    PotionEffect effect = new PotionEffect(PotionEffectType.SLOW, slownessDuration, slowness, false);
                    li.addPotionEffect(effect);
                }
                if (li instanceof Player) {
                    li.damage((double)playerDamage, this.mage.getEntity());
                } else {
                    li.damage((double)entityDamage, this.mage.getEntity());
                }
            } else if (this.controller.isElemental(targetEntity)) {
                this.controller.damageElemental(targetEntity, parameters.getDouble("elemental_damage", 10.0), 0, this.mage.getCommandSender());
            }
        }
        if (!this.hasBuildPermission(target.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", defaultRadius);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        FrostAction action = new FrostAction(this.controller, this.getUndoList(), iceMaterial);
        if (radius <= 1) {
            action.perform(target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FrostAction
    extends SimpleBlockAction {
        private Material iceMaterial;

        public FrostAction(MageController controller, UndoList undoList, Material iceMaterial) {
            super(controller, undoList);
            this.iceMaterial = iceMaterial;
        }

        @Override
        public SpellResult perform(Block block) {
            if (FrostSpell.this.isTransparent(block.getType())) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.SNOW;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                material = this.iceMaterial;
            } else if (block.getType() == Material.LAVA) {
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                material = Material.AIR;
            } else if (block.getType() == Material.SNOW) {
                material = Material.SNOW;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            if (block.getType() == Material.SNOW && material == Material.SNOW) {
                if (block.getData() < 7) {
                    block.setData((byte)(block.getData() + 1));
                }
            } else {
                block.setType(material);
            }
            return SpellResult.CAST;
        }
    }
}

