/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class LineLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int particles = 100;
    protected final Vector link;
    protected final float lenght;

    public LineLocationEffect(EffectManager effectManager, Location start, Location stop) {
        super(effectManager, start);
        this.link = stop.toVector().subtract(start.toVector());
        this.lenght = (float)this.link.length();
        this.link.normalize();
        this.type = EffectType.INSTANT;
        this.period = 5;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        for (int i = 0; i < this.particles; ++i) {
            float ratio = (float)i * this.lenght / (float)this.particles;
            Vector v = this.link.clone().multiply(ratio);
            this.location.add(v);
            this.particle.display(this.location, this.visibleRange);
            this.location.subtract(v);
        }
    }
}

