/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import org.apache.commons.lang.Validate;

public abstract class Effect
implements Runnable {
    public EffectType type = EffectType.INSTANT;
    public int delay = 0;
    public int period = 1;
    public int iterations = 0;
    public Runnable callback = null;
    public float visibleRange = 32.0f;
    private boolean done = false;
    private final EffectManager effectManager;

    public Effect(EffectManager effectManager) {
        Validate.notNull((Object)effectManager, (String)"EffectManager cannot be null!");
        this.effectManager = effectManager;
    }

    public final void cancel() {
        this.cancel(true);
    }

    public final void cancel(boolean callback) {
        if (callback) {
            this.done();
        } else {
            this.done = true;
        }
    }

    private void done() {
        this.done = true;
        this.effectManager.done(this);
    }

    public final boolean isDone() {
        return this.done;
    }

    public abstract void onRun();

    @Override
    public final void run() {
        if (this.done) {
            return;
        }
        this.onRun();
        if (this.type == EffectType.REPEATING) {
            if (this.iterations == -1) {
                return;
            }
            --this.iterations;
            if (this.iterations < 1) {
                this.done();
            }
        } else {
            this.done();
        }
    }

    public final void start() {
        this.effectManager.start(this);
    }

    public final void infinite() {
        this.type = EffectType.REPEATING;
        this.iterations = -1;
    }
}

