/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardManager {
    private boolean enabled = false;
    private WorldGuardPlugin worldGuard = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.worldGuard != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin wgPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
                if (wgPlugin instanceof WorldGuardPlugin) {
                    this.worldGuard = (WorldGuardPlugin)wgPlugin;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.worldGuard == null) {
                plugin.getLogger().info("WorldGuard not found, region protection and pvp checks will not be used.");
            } else {
                plugin.getLogger().info("WorldGuard found, will respect build permissions for construction spells");
            }
        } else {
            plugin.getLogger().info("Region manager disabled, region protection and pvp checks will not be used.");
            this.worldGuard = null;
        }
    }

    public boolean isPVPAllowed(Location location) {
        if (!this.enabled || this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null || checkSet.size() == 0) {
            return true;
        }
        return checkSet.allows(DefaultFlag.PVP);
    }

    public boolean isPassthrough(Location location) {
        if (!this.enabled || this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null || checkSet.size() == 0) {
            return true;
        }
        return checkSet.allows(DefaultFlag.PASSTHROUGH);
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.worldGuard != null) {
            if (player == null) {
                return this.isPassthrough(block.getLocation());
            }
            return this.worldGuard.canBuild(player, block);
        }
        return true;
    }
}

