/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class MagicTabExecutor
implements TabExecutor {
    protected MagicAPI api;

    public MagicTabExecutor(MagicAPI api) {
        this.api = api;
    }

    public abstract List<String> onTabComplete(CommandSender var1, String var2, String[] var3);

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String completeCommand = args.length > 0 ? args[args.length - 1] : "";
        completeCommand = completeCommand.toLowerCase();
        List<String> allOptions = this.onTabComplete(sender, command.getName(), args);
        ArrayList<String> options = new ArrayList<String>();
        for (String option : allOptions) {
            String lowercase = option.toLowerCase();
            if (!lowercase.startsWith(completeCommand)) continue;
            options.add(option);
        }
        return options;
    }

    public static String getMagicVersion() {
        String result = "Unknown-Version";
        InputStream stream = MagicTabExecutor.class.getClassLoader().getResourceAsStream("META-INF/maven/com.elmakers.mine.bukkit.plugins/Magic/pom.properties");
        Properties properties = new Properties();
        if (stream != null) {
            try {
                properties.load(stream);
                result = properties.getProperty("version");
            }
            catch (IOException ex) {
                Bukkit.getLogger().warning("Could not get Magic version");
            }
        }
        return result;
    }

    protected void sendNoPermission(CommandSender sender) {
        if (sender != null) {
            sender.sendMessage(ChatColor.RED + "You are not allowed to use that command.");
        }
    }

    protected void addIfPermissible(CommandSender sender, List<String> options, String permissionPrefix, String option) {
        if (this.api.hasPermission(sender, permissionPrefix + option)) {
            options.add(option);
        }
    }

    protected void addIfPermissible(CommandSender sender, List<String> options, String permissionPrefix, String option, boolean defaultPermission) {
        if (this.api.hasPermission(sender, permissionPrefix + option, defaultPermission)) {
            options.add(option);
        }
    }

    public boolean giveWand(CommandSender sender, Player player, String wandKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        Wand wand;
        Mage mage = this.api.getMage((CommandSender)player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if ((wand = this.api.createWand(wandKey)) != null) {
            if (giveItem) {
                this.api.giveItemToPlayer(player, wand.getItem());
                if (sender != player && !quiet) {
                    sender.sendMessage("Gave wand " + wand.getName() + " to " + player.getName());
                }
            }
            if (showWorth) {
                this.showWorth(sender, wand.getItem());
            }
        } else {
            if (!quiet) {
                sender.sendMessage(Messages.getParameterized("wand.unknown_template", "$name", wandKey));
            }
            return false;
        }
        return true;
    }

    protected void showWorth(CommandSender sender, ItemStack item) {
        if (this.api.isWand(item) || this.api.isUpgrade(item)) {
            Wand wand = this.api.getWand(item);
            if (wand == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            sender.sendMessage(ChatColor.AQUA + "WIP: Wand " + ChatColor.GOLD + wand.getName() + ChatColor.AQUA + " is worth " + ChatColor.GREEN + wand.getWorth());
        } else if (this.api.isSpell(item)) {
            SpellTemplate template = this.api.getSpellTemplate(this.api.getSpell(item));
            if (template == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            sender.sendMessage(ChatColor.AQUA + "WIP: Spell " + ChatColor.GOLD + template.getName() + ChatColor.AQUA + " is worth " + ChatColor.GREEN + template.getWorth());
        } else if (this.api.isBrush(item)) {
            String materialBrush = this.api.getBrush(item);
            if (materialBrush == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            int brushWorth = 500;
            sender.sendMessage(ChatColor.AQUA + "WIP: Brush " + ChatColor.GOLD + materialBrush + ChatColor.AQUA + " is worth " + ChatColor.GREEN + brushWorth);
        } else {
            sender.sendMessage("I'm not sure what that's worth, sorry!");
        }
    }
}

