/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.effect.ParticleType;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.UnknownWandException;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandOrganizer;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Wand
implements CostReducer,
com.elmakers.mine.bukkit.api.wand.Wand {
    public static Plugin metadataProvider;
    public static final int INVENTORY_SIZE = 27;
    public static final int HOTBAR_SIZE = 9;
    public static final float DEFAULT_SPELL_COLOR_MIX_WEIGHT = 1.0E-4f;
    public static final float DEFAULT_WAND_COLOR_MIX_WEIGHT = 1.0f;
    public static final String[] PROPERTY_KEYS;
    public static final String[] HIDDEN_PROPERTY_KEYS;
    public static final String[] ALL_PROPERTY_KEYS;
    protected ItemStack item;
    protected MagicController controller;
    protected Mage mage;
    private String id = "";
    private Inventory hotbar;
    private List<Inventory> inventories;
    private Set<String> spells = new HashSet<String>();
    private Set<String> brushes = new HashSet<String>();
    private String activeSpell = "";
    private String activeMaterial = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String ownerId = "";
    private String template = "";
    private String path = "";
    private boolean bound = false;
    private boolean indestructible = false;
    private boolean keep = false;
    private boolean autoOrganize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private boolean randomize = false;
    private boolean rename = false;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = null;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private boolean locked = false;
    private boolean forceUpgrade = false;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private float healthRegeneration = 0.0f;
    private PotionEffect healthRegenEffect = null;
    private float hungerRegeneration = 0.0f;
    private PotionEffect hungerRegenEffect = null;
    private ColorHD effectColor = null;
    private float effectColorSpellMixWeight = 1.0E-4f;
    private float effectColorMixWeight = 1.0f;
    private ParticleType effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private int effectParticleCounter = 0;
    private boolean effectBubbles = false;
    private EffectRing effectPlayer = null;
    private Sound effectSound = null;
    private int effectSoundInterval = 0;
    private int effectSoundCounter = 0;
    private float effectSoundVolume = 0.0f;
    private float effectSoundPitch = 0.0f;
    private float speedIncrease = 0.0f;
    private PotionEffect hasteEffect = null;
    private int quietLevel = 0;
    private String[] castParameters = null;
    private int storedXpLevel = 0;
    private int storedXp = 0;
    private float storedXpProgress = 0.0f;
    private WandMode mode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private Inventory displayInventory = null;
    private boolean suspendSave = false;
    protected static Map<String, ConfigurationSection> wandTemplates;
    public static boolean displayManaAsBar;
    public static boolean retainLevelDisplay;
    public static Material DefaultUpgradeMaterial;
    public static Material DefaultWandMaterial;
    public static Material EnchantableWandMaterial;
    public static boolean EnableGlow;

    public Wand(MagicController controller, ItemStack itemStack) {
        this.controller = controller;
        this.hotbar = CompatibilityUtils.createInventory(null, 9, "Wand");
        this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(itemStack.getType(), (byte)itemStack.getDurability());
        this.inventories = new ArrayList<Inventory>();
        this.item = itemStack;
        this.indestructible = controller.getIndestructibleWands();
        this.loadState();
    }

    public Wand(MagicController controller) {
        this(controller, DefaultWandMaterial, 0);
    }

    protected Wand(MagicController controller, String templateName) throws UnknownWandException {
        this(controller);
        this.suspendSave = true;
        String wandName = Messages.get("wand.default_name");
        String wandDescription = "";
        if ((templateName == null || templateName.length() == 0) && wandTemplates.containsKey("default")) {
            templateName = "default";
        }
        if (templateName != null && templateName.length() > 0) {
            int level = 0;
            if (templateName.contains("(")) {
                String levelString = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                try {
                    level = Integer.parseInt(levelString);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
                templateName = templateName.substring(0, templateName.indexOf(40));
            }
            if (!wandTemplates.containsKey(templateName)) {
                throw new UnknownWandException(templateName);
            }
            ConfigurationSection wandConfig = wandTemplates.get(templateName);
            wandName = wandConfig.getString("name", wandName);
            wandName = Messages.get("wands." + templateName + ".name", wandName);
            wandDescription = wandConfig.getString("description", wandDescription);
            wandDescription = Messages.get("wands." + templateName + ".description", wandDescription);
            this.loadProperties(wandConfig);
            if (level > 0) {
                boolean wasLocked = this.locked;
                this.locked = false;
                this.randomize(level, false);
                this.locked = wasLocked;
            }
        }
        this.setDescription(wandDescription);
        this.setName(wandName);
        if (!this.randomize) {
            this.randomize();
        }
        this.setTemplate(templateName);
        this.suspendSave = false;
        this.saveState();
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, InventoryUtils.makeReal(new ItemStack(icon, 1, iconData)));
        this.wandName = Messages.get("wand.default_name");
        this.updateName();
        this.saveState();
    }

    @Override
    public void unenchant() {
        this.item = new ItemStack(this.item.getType(), 1, this.item.getDurability());
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material, data));
    }

    public void setIcon(com.elmakers.mine.bukkit.block.MaterialAndData materialData) {
        this.icon = materialData;
        if (this.icon != null) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData());
        }
    }

    @Override
    public void makeUpgrade() {
        if (!this.isUpgrade) {
            this.isUpgrade = true;
            String oldName = this.wandName;
            this.wandName = Messages.get("wand.upgrade_name");
            this.wandName = this.wandName.replace("$name", oldName);
            this.description = Messages.get("wand.upgrade_default_description");
            if (this.template != null && this.template.length() > 0) {
                this.description = Messages.get("wands." + this.template + ".upgrade_description", this.description);
            }
            this.setIcon(DefaultUpgradeMaterial, (byte)0);
            this.saveState();
            this.updateName(true);
            this.updateLore();
        }
    }

    protected void activateBrush(String materialKey) {
        MaterialBrush brush;
        this.setActiveBrush(materialKey);
        if (materialKey != null && (brush = this.mage.getBrush()) != null) {
            brush.activate(this.mage.getLocation(), materialKey);
        }
    }

    public void activateBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.activateBrush(Wand.getBrush(itemStack));
    }

    public String getLostId() {
        return this.id;
    }

    public void clearLostId() {
        if (this.id != null) {
            this.id = null;
            this.saveState();
        }
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getExperience() {
        return this.xp;
    }

    public void removeExperience(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public float getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public float getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    public boolean isIndestructible() {
        return this.indestructible;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    @Override
    public boolean usesMana() {
        return this.xpMax > 0 && this.xpRegeneration > 0 && !this.isCostFree();
    }

    public float getCooldownReduction() {
        return this.controller.getCooldownReduction() + this.cooldownReduction * WandLevel.maxCooldownReduction;
    }

    @Override
    public float getCostReduction() {
        if (this.isCostFree()) {
            return 1.0f;
        }
        return this.controller.getCostReduction() + this.costReduction * WandLevel.maxCostReduction;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public boolean isSuperProtected() {
        return this.damageReduction > 1.0f;
    }

    public boolean isSuperPowered() {
        return this.power > 1.0f;
    }

    public boolean isCostFree() {
        return this.costReduction > 1.0f;
    }

    public boolean isCooldownFree() {
        return this.cooldownReduction > 1.0f;
    }

    public float getDamageReduction() {
        return this.damageReduction * WandLevel.maxDamageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical * WandLevel.maxDamageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles * WandLevel.maxDamageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling * WandLevel.maxDamageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire * WandLevel.maxDamageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions * WandLevel.maxDamageReductionExplosions;
    }

    public int getUses() {
        return this.uses;
    }

    @Override
    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public long getWorth() {
        long worth = 0L;
        Collection spells = this.getSpells();
        for (String spellKey : spells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell == null) continue;
            worth += spell.getWorth();
        }
        return worth;
    }

    @Override
    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
    }

    public String getTemplate() {
        return this.template;
    }

    public WandUpgradePath getPath() {
        String pathKey = this.path;
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return WandUpgradePath.getPath(pathKey);
    }

    public boolean hasPath() {
        return this.path != null && this.path.length() > 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    public void tryToOwn(Player player) {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            if (this.owner != null && !this.owner.equals(player.getName())) {
                return;
            }
            this.takeOwnership(player);
        }
    }

    protected void takeOwnership(Player player) {
        this.takeOwnership(player, this.controller != null && this.controller.bindWands(), this.controller != null && this.controller.keepWands());
    }

    public void takeOwnership(Player player, boolean setBound, boolean setKeep) {
        this.owner = player.getName();
        this.ownerId = player.getUniqueId().toString();
        if (setBound) {
            this.bound = true;
        }
        if (setKeep) {
            this.keep = true;
        }
        this.updateLore();
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        return this.spells;
    }

    protected String getSpellString() {
        TreeSet<String> spellNames = new TreeSet<String>();
        List<Inventory> allInventories = this.getAllInventories();
        int index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int i = 0; i < items.length; ++i) {
                if (items[i] != null && Wand.isSpell(items[i])) {
                    String spellName = Wand.getSpell(items[i]) + "@" + index;
                    spellNames.add(spellName);
                }
                ++index;
            }
        }
        return StringUtils.join(spellNames, (String)",");
    }

    public Set<String> getBrushes() {
        return this.brushes;
    }

    protected String getMaterialString() {
        TreeSet<String> materialNames = new TreeSet<String>();
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        int index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int i = 0; i < items.length; ++i) {
                String materialKey;
                if (items[i] != null && Wand.isBrush(items[i]) && (materialKey = Wand.getBrush(items[i])) != null) {
                    materialKey = materialKey + "@" + index;
                    materialNames.add(materialKey);
                }
                ++index;
            }
        }
        return StringUtils.join(materialNames, (String)",");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 0) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        Integer selectedItem = null;
        if (this.getMode() == WandMode.INVENTORY && this.mage != null && this.mage.getPlayer() != null) {
            selectedItem = this.mage.getPlayer().getInventory().getHeldItemSlot();
            ItemStack existingHotbar = this.hotbar.getItem(selectedItem.intValue());
            if (existingHotbar != null && existingHotbar.getType() != Material.AIR && !Wand.isWand(existingHotbar)) {
                this.hotbar.setItem(selectedItem.intValue(), this.item);
                this.addToInventory(existingHotbar);
            }
            this.hotbar.setItem(selectedItem.intValue(), this.item);
        }
        List<Inventory> checkInventories = this.getAllInventories();
        boolean added = false;
        for (Inventory inventory : checkInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = CompatibilityUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
        if (selectedItem != null) {
            this.hotbar.setItem(selectedItem.intValue(), null);
        }
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null) {
            this.displayInventory = CompatibilityUtils.createInventory(null, 36, "Wand");
        }
        return this.displayInventory;
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = this.hotbar;
        if (slot >= 9) {
            int inventoryIndex = (slot - 9) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        if (slot < 9) {
            return slot;
        }
        return (slot - 9) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] materialNames;
        String[] spellNames;
        this.hotbar.clear();
        this.inventories.clear();
        this.spells.clear();
        this.brushes.clear();
        spellString = spellString.replaceAll("[\\]\\[]", "");
        for (String spellName : spellNames = StringUtils.split((String)spellString, (String)"|,")) {
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            String spellKey = pieces[0].trim();
            this.spells.add(spellKey);
            ItemStack itemStack = this.createSpellIcon(spellKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create spell icon for key " + spellKey);
                continue;
            }
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.activeSpell = spellKey;
            }
            this.addToInventory(itemStack, slot);
        }
        materialString = materialString.replaceAll("[\\]\\[]", "");
        for (String materialName : materialNames = StringUtils.split((String)materialString, (String)"|,")) {
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            this.brushes.add(materialKey);
            ItemStack itemStack = this.createBrushIcon(materialKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create material icon for key " + materialKey);
                continue;
            }
            if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
                this.activeMaterial = materialKey;
            }
            this.addToInventory(itemStack, slot);
        }
        this.hasInventory = spellNames.length + materialNames.length > 1;
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        SpellTemplate spell = controller.getSpellTemplate(spellKey);
        if (spell == null) {
            return null;
        }
        MaterialAndData icon = spell.getIcon();
        if (icon == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
            return null;
        }
        ItemStack itemStack = null;
        ItemStack originalItemStack = null;
        try {
            originalItemStack = new ItemStack(icon.getMaterial(), 1, 0, Byte.valueOf(icon.getData()));
            itemStack = InventoryUtils.makeReal(originalItemStack);
        }
        catch (Exception ex) {
            itemStack = null;
        }
        if (itemStack == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spellKey + " with material " + icon.getMaterial().name());
            return originalItemStack;
        }
        Wand.updateSpellItem(itemStack, spell, wand, wand == null ? null : wand.activeMaterial, isItem);
        return itemStack;
    }

    protected ItemStack createSpellIcon(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, this, false);
    }

    private String getActiveWandName(String materialKey) {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell, materialKey);
    }

    protected ItemStack createBrushIcon(String materialKey) {
        return Wand.createBrushItem(materialKey, this.controller, this, false);
    }

    public static ItemStack createBrushItem(String materialKey, MagicController controller, Wand wand, boolean isItem) {
        com.elmakers.mine.bukkit.block.MaterialAndData brushData = com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey, false);
        if (brushData == null) {
            return null;
        }
        Material material = brushData.getMaterial();
        if (material == null || material == Material.AIR) {
            return null;
        }
        byte dataId = brushData.getData();
        ItemStack originalItemStack = new ItemStack(material, 1, 0, Byte.valueOf(dataId));
        ItemStack itemStack = InventoryUtils.makeReal(originalItemStack);
        if (itemStack == null) {
            controller.getPlugin().getLogger().warning("Unable to create material icon for " + material.name() + ": " + materialKey);
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (material != null) {
            lore.add(ChatColor.GRAY + Messages.get("wand.building_material_info").replace("$material", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
            if (material == com.elmakers.mine.bukkit.block.MaterialBrush.EraseMaterial) {
                lore.add(Messages.get("wand.erase_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.CopyMaterial) {
                lore.add(Messages.get("wand.copy_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.CloneMaterial) {
                lore.add(Messages.get("wand.clone_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.ReplicateMaterial) {
                lore.add(Messages.get("wand.replicate_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.MapMaterial) {
                lore.add(Messages.get("wand.map_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.SchematicMaterial) {
                lore.add(Messages.get("wand.schematic_material_description").replace("$schematic", brushData.getCustomName()));
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + Messages.get("wand.building_material_description"));
            }
        }
        if (isItem) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.brush_item_description"));
        }
        CompatibilityUtils.setLore(itemStack, lore);
        Wand.updateBrushItem(itemStack, materialKey, wand);
        return itemStack;
    }

    protected void saveState() {
        if (this.suspendSave || this.item == null) {
            return;
        }
        MemoryConfiguration stateNode = new MemoryConfiguration();
        this.saveProperties((ConfigurationSection)stateNode);
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        if (wandNode == null) {
            this.controller.getLogger().warning("Failed to save legacy wand state for wand id " + this.id + " to : " + this.item + " of class " + this.item.getClass());
        } else {
            InventoryUtils.saveTagsToNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
        }
        Object magicNode = CompatibilityUtils.createMetadataNode(this.item, metadataProvider, this.isUpgrade ? "upgrade" : "wand");
        if (magicNode == null) {
            this.controller.getLogger().warning("Failed to save wand state for wand id " + this.id + " to : " + this.item + " of class " + this.item.getClass());
            return;
        }
        if (this.isUpgrade) {
            CompatibilityUtils.removeMetadata(this.item, metadataProvider, "wand");
        } else {
            CompatibilityUtils.removeMetadata(this.item, metadataProvider, "upgrade");
        }
        CompatibilityUtils.removeMetadata(this.item, metadataProvider, "spell");
        CompatibilityUtils.removeMetadata(this.item, metadataProvider, "brush");
        InventoryUtils.saveTagsToNBT((ConfigurationSection)stateNode, magicNode, ALL_PROPERTY_KEYS);
    }

    protected void loadState() {
        boolean isUpgrade;
        if (this.item == null) {
            return;
        }
        boolean isWand = CompatibilityUtils.hasMetadata(this.item, metadataProvider, "wand");
        boolean bl = isUpgrade = !isWand && CompatibilityUtils.hasMetadata(this.item, metadataProvider, "upgrade");
        if (isWand || isUpgrade) {
            Object magicNode = CompatibilityUtils.getMetadataNode(this.item, metadataProvider, isUpgrade ? "upgrade" : "wand");
            if (magicNode == null) {
                return;
            }
            MemoryConfiguration stateNode = new MemoryConfiguration();
            InventoryUtils.loadTagsFromNBT((ConfigurationSection)stateNode, magicNode, ALL_PROPERTY_KEYS);
            this.loadProperties((ConfigurationSection)stateNode);
        } else {
            Object wandNode = InventoryUtils.getNode(this.item, "wand");
            if (wandNode == null) {
                return;
            }
            MemoryConfiguration stateNode = new MemoryConfiguration();
            InventoryUtils.loadTagsFromNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
            this.loadProperties((ConfigurationSection)stateNode);
        }
    }

    public void saveProperties(ConfigurationSection node) {
        node.set("id", (Object)this.id);
        node.set("materials", (Object)this.getMaterialString());
        node.set("spells", (Object)this.getSpellString());
        node.set("active_spell", (Object)this.activeSpell);
        node.set("active_material", (Object)this.activeMaterial);
        node.set("name", (Object)this.wandName);
        node.set("description", (Object)this.description);
        node.set("owner", (Object)this.owner);
        node.set("owner_id", (Object)this.ownerId);
        node.set("cost_reduction", (Object)Float.valueOf(this.costReduction));
        node.set("cooldown_reduction", (Object)Float.valueOf(this.cooldownReduction));
        node.set("power", (Object)Float.valueOf(this.power));
        node.set("protection", (Object)Float.valueOf(this.damageReduction));
        node.set("protection_physical", (Object)Float.valueOf(this.damageReductionPhysical));
        node.set("protection_projectiles", (Object)Float.valueOf(this.damageReductionProjectiles));
        node.set("protection_falling", (Object)Float.valueOf(this.damageReductionFalling));
        node.set("protection_fire", (Object)Float.valueOf(this.damageReductionFire));
        node.set("protection_explosions", (Object)Float.valueOf(this.damageReductionExplosions));
        node.set("haste", (Object)Float.valueOf(this.speedIncrease));
        node.set("xp", (Object)this.xp);
        node.set("xp_regeneration", (Object)this.xpRegeneration);
        node.set("xp_max", (Object)this.xpMax);
        node.set("health_regeneration", (Object)Float.valueOf(this.healthRegeneration));
        node.set("hunger_regeneration", (Object)Float.valueOf(this.hungerRegeneration));
        node.set("uses", (Object)this.uses);
        node.set("locked", (Object)this.locked);
        node.set("effect_color", (Object)(this.effectColor == null ? "none" : this.effectColor.toString()));
        node.set("effect_bubbles", (Object)this.effectBubbles);
        node.set("effect_particle_data", (Object)Float.toString(this.effectParticleData));
        node.set("effect_particle_count", (Object)this.effectParticleCount);
        node.set("effect_particle_interval", (Object)this.effectParticleInterval);
        node.set("effect_sound_interval", (Object)this.effectSoundInterval);
        node.set("effect_sound_volume", (Object)Float.toString(this.effectSoundVolume));
        node.set("effect_sound_pitch", (Object)Float.toString(this.effectSoundPitch));
        node.set("quiet", (Object)this.quietLevel);
        node.set("keep", (Object)this.keep);
        node.set("randomize", (Object)this.randomize);
        node.set("rename", (Object)this.rename);
        node.set("bound", (Object)this.bound);
        node.set("force", (Object)this.forceUpgrade);
        node.set("indestructible", (Object)this.indestructible);
        node.set("fill", (Object)this.autoFill);
        node.set("upgrade", (Object)this.isUpgrade);
        node.set("organize", (Object)this.autoOrganize);
        if (this.castParameters != null && this.castParameters.length > 0) {
            node.set("overrides", (Object)StringUtils.join((Object[])this.castParameters, (char)' '));
        } else {
            node.set("overrides", null);
        }
        if (this.effectSound != null) {
            node.set("effect_sound", (Object)this.effectSound.name());
        } else {
            node.set("effectSound", null);
        }
        if (this.effectParticle != null) {
            node.set("effect_particle", (Object)this.effectParticle.name());
        } else {
            node.set("effect_particle", null);
        }
        if (this.mode != null) {
            node.set("mode", (Object)this.mode.name());
        } else {
            node.set("mode", null);
        }
        if (this.icon != null) {
            String iconKey = com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialKey(this.icon);
            if (iconKey != null && iconKey.length() > 0) {
                node.set("icon", (Object)iconKey);
            } else {
                node.set("icon", null);
            }
        } else {
            node.set("icon", null);
        }
        if (this.template != null && this.template.length() > 0) {
            node.set("template", (Object)this.template);
        } else {
            node.set("template", null);
        }
        if (this.path != null && this.path.length() > 0) {
            node.set("path", (Object)this.path);
        } else {
            node.set("path", null);
        }
    }

    public void loadProperties(ConfigurationSection wandConfig) {
        this.loadProperties(wandConfig, false);
    }

    public void setEffectColor(String hexColor) {
        if (hexColor.contains(".")) {
            hexColor = hexColor.substring(0, hexColor.indexOf(46));
        }
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        this.effectColor = new ColorHD(hexColor);
    }

    public void loadProperties(ConfigurationSection wandConfig, boolean safe) {
        this.locked = wandConfig.getBoolean("locked", this.locked);
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", (double)this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", (double)this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", (double)this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", (double)this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", (double)this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", (double)this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", (double)this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", (double)this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpRegeneration = safe ? Math.max(_xpRegeneration, this.xpRegeneration) : _xpRegeneration;
        int _xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xpMax = safe ? Math.max(_xpMax, this.xpMax) : _xpMax;
        int _xp = wandConfig.getInt("xp", this.xp);
        this.xp = safe ? Math.max(_xp, this.xp) : _xp;
        float _healthRegeneration = (float)wandConfig.getDouble("health_regeneration", (double)this.healthRegeneration);
        this.healthRegeneration = safe ? Math.max(_healthRegeneration, this.healthRegeneration) : _healthRegeneration;
        float _hungerRegeneration = (float)wandConfig.getDouble("hunger_regeneration", (double)this.hungerRegeneration);
        this.hungerRegeneration = safe ? Math.max(_hungerRegeneration, this.hungerRegeneration) : _hungerRegeneration;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        float _speedIncrease = (float)wandConfig.getDouble("haste", (double)this.speedIncrease);
        float f = this.speedIncrease = safe ? Math.max(_speedIncrease, this.speedIncrease) : _speedIncrease;
        if (wandConfig.contains("effect_color") && !safe) {
            this.setEffectColor(wandConfig.getString("effect_color"));
        }
        if (!safe) {
            this.id = wandConfig.getString("id", this.id);
            this.isUpgrade = wandConfig.getBoolean("upgrade", this.isUpgrade);
            this.quietLevel = wandConfig.getInt("quiet", this.quietLevel);
            this.effectBubbles = wandConfig.getBoolean("effect_bubbles", this.effectBubbles);
            this.keep = wandConfig.getBoolean("keep", this.keep);
            this.indestructible = wandConfig.getBoolean("indestructible", this.indestructible);
            this.bound = wandConfig.getBoolean("bound", this.bound);
            this.forceUpgrade = wandConfig.getBoolean("force", this.forceUpgrade);
            this.autoOrganize = wandConfig.getBoolean("organize", this.autoOrganize);
            this.autoFill = wandConfig.getBoolean("fill", this.autoFill);
            this.randomize = wandConfig.getBoolean("randomize", this.randomize);
            this.rename = wandConfig.getBoolean("rename", this.rename);
            if (wandConfig.contains("effect_particle")) {
                this.parseParticleEffect(wandConfig.getString("effect_particle"));
                this.effectParticleData = 0.0f;
            }
            if (wandConfig.contains("effect_sound")) {
                this.parseSoundEffect(wandConfig.getString("effect_sound"));
            }
            this.effectParticleData = (float)wandConfig.getDouble("effect_particle_data", (double)this.effectParticleData);
            this.effectParticleCount = wandConfig.getInt("effect_particle_count", this.effectParticleCount);
            this.effectParticleInterval = wandConfig.getInt("effect_particle_interval", this.effectParticleInterval);
            this.effectSoundInterval = wandConfig.getInt("effect_sound_interval", this.effectSoundInterval);
            this.effectSoundVolume = (float)wandConfig.getDouble("effect_sound_volume", (double)this.effectSoundVolume);
            this.effectSoundPitch = (float)wandConfig.getDouble("effect_sound_pitch", (double)this.effectSoundPitch);
            this.setMode(Wand.parseWandMode(wandConfig.getString("mode"), this.mode));
            this.owner = wandConfig.getString("owner", this.owner);
            this.ownerId = wandConfig.getString("owner_id", this.ownerId);
            this.wandName = wandConfig.getString("name", this.wandName);
            this.description = wandConfig.getString("description", this.description);
            this.template = wandConfig.getString("template", this.template);
            this.path = wandConfig.getString("path", this.path);
            this.activeSpell = wandConfig.getString("active_spell", this.activeSpell);
            this.activeMaterial = wandConfig.getString("active_material", this.activeMaterial);
            String wandMaterials = wandConfig.getString("materials", "");
            String wandSpells = wandConfig.getString("spells", "");
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                wandMaterials = wandMaterials.length() == 0 ? this.getMaterialString() : wandMaterials;
                wandSpells = wandSpells.length() == 0 ? this.getSpellString() : wandSpells;
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
            if (wandConfig.contains("randomize_icon")) {
                this.setIcon(ConfigurationUtils.toMaterialAndData(wandConfig.getString("randomize_icon")));
                this.randomize = true;
            } else if (!this.randomize && wandConfig.contains("icon")) {
                String iconKey = wandConfig.getString("icon");
                if (iconKey.contains(",")) {
                    Random r = new Random();
                    String[] keys = StringUtils.split((String)iconKey, (char)',');
                    iconKey = keys[r.nextInt(keys.length)];
                }
                this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            }
            this.castParameters = null;
            String overrides = wandConfig.getString("overrides", null);
            if (overrides != null && !overrides.isEmpty()) {
                this.castParameters = StringUtils.split((String)overrides, (char)' ');
            }
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
            this.effectSoundVolume = 0.0f;
            this.effectSoundPitch = 0.0f;
        } else {
            this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
            this.effectSoundVolume = this.effectSoundVolume < 0.01f ? 0.8f : this.effectSoundVolume;
            float f2 = this.effectSoundPitch = this.effectSoundPitch < 0.01f ? 1.1f : this.effectSoundPitch;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        } else {
            this.effectParticleInterval = this.effectParticleInterval == 0 ? 2 : this.effectParticleInterval;
            int n = this.effectParticleCount = this.effectParticleCount == 0 ? 1 : this.effectParticleCount;
        }
        if (this.xpRegeneration <= 0 || this.xpMax <= 0 || this.costReduction >= 1.0f) {
            this.xpMax = 0;
            this.xpRegeneration = 0;
            this.xp = 0;
        }
        this.checkActiveMaterial();
        this.updateName();
        this.updateLore();
    }

    protected void parseSoundEffect(String effectSoundName) {
        if (effectSoundName.length() > 0) {
            String testName = effectSoundName.toUpperCase().replace("_", "");
            try {
                for (Sound testType : Sound.values()) {
                    String testTypeName = testType.name().replace("_", "");
                    if (!testTypeName.equals(testName)) continue;
                    this.effectSound = testType;
                }
            }
            catch (Exception ex) {
                this.effectSound = null;
            }
        } else {
            this.effectSound = null;
        }
    }

    protected void parseParticleEffect(String effectParticleName) {
        if (effectParticleName.length() > 0) {
            String testName = effectParticleName.toUpperCase().replace("_", "");
            try {
                for (ParticleType testType : ParticleType.values()) {
                    String testTypeName = testType.name().replace("_", "");
                    if (!testTypeName.equals(testName)) continue;
                    this.effectParticle = testType;
                }
            }
            catch (Exception ex) {
                this.effectParticle = null;
            }
        } else {
            this.effectParticle = null;
        }
    }

    @Override
    public void describe(CommandSender sender) {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + this.owner);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + "(No Owner)");
        }
        for (String key : PROPERTY_KEYS) {
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value == null || value.length() <= 0) continue;
            sender.sendMessage(key + ": " + value);
        }
    }

    private static String getBrushDisplayName(String materialKey) {
        String materialName = com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey);
        if (materialName == null) {
            materialName = "none";
        }
        return ChatColor.GRAY + materialName;
    }

    private static String getSpellDisplayName(SpellTemplate spell, String materialKey) {
        String name = "";
        if (spell != null) {
            name = materialKey != null && spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride() ? ChatColor.GOLD + spell.getName() + " " + Wand.getBrushDisplayName(materialKey) + ChatColor.WHITE : ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell, String materialKey) {
        int remaining = this.getRemainingUses();
        ChatColor wandColor = remaining > 0 ? ChatColor.DARK_RED : (this.isModifiable() ? (this.bound ? ChatColor.DARK_AQUA : ChatColor.AQUA) : ChatColor.GOLD);
        String name = wandColor + this.getDisplayName();
        if (this.randomize) {
            return name;
        }
        Collection spells = this.getSpells();
        if (spell != null && (spells.size() > 1 || this.hasPath())) {
            name = Wand.getSpellDisplayName(spell, materialKey) + " (" + name + ChatColor.WHITE + ")";
        }
        if (remaining > 0) {
            String message = remaining == 1 ? Messages.get("wand.uses_remaining_singular") : Messages.get("wand.uses_remaining_brief");
            name = name + " (" + ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()) + ")";
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell) {
        return this.getActiveWandName(spell, this.activeMaterial);
    }

    private String getActiveWandName() {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    protected String getDisplayName() {
        return this.randomize ? Messages.get("wand.randomized_name") : this.wandName;
    }

    public void updateName(boolean isActive) {
        CompatibilityUtils.setDisplayName(this.item, isActive && !this.isUpgrade ? this.getActiveWandName() : ChatColor.GOLD + this.getDisplayName());
        if (EnableGlow) {
            CompatibilityUtils.addGlow(this.item);
        }
        CompatibilityUtils.makeUnbreakable(this.item);
    }

    private void updateName() {
        this.updateName(true);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        for (ChatColor c : ChatColor.values()) {
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
        }
        for (int i = 0; i < tagCount; ++i) {
            line = line + "</span>";
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    protected List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getBrushes().size());
    }

    protected void addPropertyLore(List<String> lore) {
        if (this.usesMana()) {
            lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + Wand.getLevelString("wand.mana_amount", this.xpMax, WandLevel.maxMaxXp));
            lore.add(ChatColor.RESET + "" + ChatColor.LIGHT_PURPLE + Wand.getLevelString("wand.mana_regeneration", this.xpRegeneration, WandLevel.maxXpRegeneration));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.cost_reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.cooldown_reduction", this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.power", this.power));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.haste", this.speedIncrease));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection", this.damageReduction, WandLevel.maxDamageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection_physical", this.damageReductionPhysical, WandLevel.maxDamageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection_projectile", this.damageReductionProjectiles, WandLevel.maxDamageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection_fall", this.damageReductionFalling, WandLevel.maxDamageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection_fire", this.damageReductionFire, WandLevel.maxDamageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString("wand.protection_blast", this.damageReductionExplosions, WandLevel.maxDamageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.health_regeneration", this.healthRegeneration));
        }
        if (this.hungerRegeneration > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString("wand.hunger_regeneration", this.hungerRegeneration));
        }
    }

    private String getLevelString(String templateName, float amount) {
        return Wand.getLevelString(templateName, amount, 1.0f);
    }

    private static String getLevelString(String templateName, float amount, float max) {
        String templateString = Messages.get(templateName);
        if (templateString.contains("$roman")) {
            templateString = templateString.replace("$roman", Wand.getRomanString(amount));
        }
        return templateString.replace("$amount", Integer.toString((int)amount));
    }

    private static String getRomanString(float amount) {
        String roman = "";
        roman = amount > 1.0f ? Messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? Messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? Messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? Messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? Messages.get("wand.enchantment_level_2") : Messages.get("wand.enchantment_level_1")))));
        return roman;
    }

    protected List<String> getLore(int spellCount, int materialCount) {
        int remaining;
        ArrayList<String> lore = new ArrayList<String>();
        if (this.description.length() > 0) {
            if (this.description.contains("$")) {
                String randomDescription = Messages.get("wand.randomized_lore");
                if (randomDescription.length() > 0) {
                    lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN + randomDescription);
                }
            } else {
                lore.add(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
            }
        }
        if (this.randomize) {
            return lore;
        }
        SpellTemplate spell = this.controller.getSpellTemplate(this.activeSpell);
        if (spell != null && spellCount == 1 && !this.hasInventory && !this.isUpgrade && this.hasPath()) {
            lore.add(Wand.getSpellDisplayName(spell, null));
            Wand.addSpellLore(spell, lore, this);
        }
        if (materialCount == 1 && this.activeMaterial != null && this.activeMaterial.length() > 0) {
            lore.add(Wand.getBrushDisplayName(this.activeMaterial));
        }
        if (!this.isUpgrade && this.owner.length() > 0) {
            String ownerDescription;
            if (this.bound) {
                ownerDescription = Messages.get("wand.bound_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_AQUA + ownerDescription);
            } else {
                ownerDescription = Messages.get("wand.owner_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN + ownerDescription);
            }
        }
        if (spellCount > 0) {
            if (this.isUpgrade) {
                lore.add(Messages.get("wand.upgrade_spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            } else if (spellCount > 1) {
                lore.add(Messages.get("wand.spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            }
        }
        if (materialCount > 0) {
            if (this.isUpgrade) {
                lore.add(Messages.get("wand.upgrade_material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            } else if (materialCount > 1) {
                lore.add(Messages.get("wand.material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            if (this.isUpgrade) {
                String message = remaining == 1 ? Messages.get("wand.upgrade_uses_singular") : Messages.get("wand.upgrade_uses");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            } else {
                String message = remaining == 1 ? Messages.get("wand.uses_remaining_singular") : Messages.get("wand.uses_remaining_brief");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            }
        }
        this.addPropertyLore(lore);
        if (this.isUpgrade) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.upgrade_item_description"));
        }
        return lore;
    }

    protected void updateLore() {
        CompatibilityUtils.setLore(this.item, this.getLore());
        if (EnableGlow) {
            CompatibilityUtils.addGlow(this.item);
        }
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (EnchantableWandMaterial == null) {
            return;
        }
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData());
        } else {
            Set<Material> enchantableMaterials = this.controller.getMaterialSet("enchantable");
            if (!enchantableMaterials.contains(this.item.getType())) {
                this.item.setType(EnchantableWandMaterial);
                this.item.setDurability((short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && (CompatibilityUtils.hasMetadata(item, metadataProvider, "wand") || Wand.isLegacyWand(item));
    }

    public static boolean isLegacyWand(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "wand") && !Wand.isLegacyUpgrade(item);
    }

    public static boolean isLegacyUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        Object wandNode = InventoryUtils.getNode(item, "wand");
        if (wandNode == null) {
            return false;
        }
        String upgradeData = InventoryUtils.getMeta(wandNode, "upgrade");
        return upgradeData != null && upgradeData.equals("true");
    }

    public static boolean isUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (Wand.isLegacyUpgrade(item)) {
            return true;
        }
        return item != null && CompatibilityUtils.hasMetadata(item, metadataProvider, "upgrade");
    }

    public static boolean isLegacySpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && (CompatibilityUtils.hasMetadata(item, metadataProvider, "spell") || Wand.isLegacySpell(item));
    }

    public static boolean isLegacyBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && (CompatibilityUtils.hasMetadata(item, metadataProvider, "brush") || Wand.isLegacyBrush(item));
    }

    public static String getLegacySpell(ItemStack item) {
        if (!Wand.isLegacySpell(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public static String getSpell(ItemStack item) {
        if (!Wand.isSpell(item)) {
            if (Wand.isLegacySpell(item)) {
                return Wand.getLegacySpell(item);
            }
            return null;
        }
        return CompatibilityUtils.getMetadata(item, metadataProvider, "spell");
    }

    public static String getLegacyBrush(ItemStack item) {
        if (!Wand.isLegacyBrush(item)) {
            return null;
        }
        Object brushNode = InventoryUtils.getNode(item, "brush");
        return InventoryUtils.getMeta(brushNode, "key");
    }

    public static String getBrush(ItemStack item) {
        if (!Wand.isBrush(item)) {
            if (Wand.isLegacyBrush(item)) {
                return Wand.getLegacyBrush(item);
            }
            return null;
        }
        return CompatibilityUtils.getMetadata(item, metadataProvider, "brush");
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellItem(item, spell, activeName ? this : null, this.activeMaterial, false);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateBrushItem(item, Wand.getBrush(item), activeName ? this : null);
        }
    }

    public static void updateSpellItem(ItemStack itemStack, SpellTemplate spell, Wand wand, String activeMaterial, boolean isItem) {
        String displayName = wand != null ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(spell, activeMaterial);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(spell, lore, wand);
        if (isItem) {
            lore.add(ChatColor.YELLOW + Messages.get("wand.spell_item_description"));
        }
        CompatibilityUtils.setLore(itemStack, lore);
        CompatibilityUtils.addGlow(itemStack);
        CompatibilityUtils.setMetadata(itemStack, metadataProvider, "spell", spell.getKey());
    }

    public static void updateBrushItem(ItemStack itemStack, String materialKey, Wand wand) {
        String displayName = null;
        displayName = wand != null ? wand.getActiveWandName(materialKey) : com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        CompatibilityUtils.setMetadata(itemStack, metadataProvider, "brush", materialKey);
    }

    public void updateHotbar() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.mage.hasStoredInventory()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            PlayerInventory inventory = player.getInventory();
            this.updateHotbar(inventory);
            player.updateInventory();
        }
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.mage.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            inventory.clear();
            this.updateHotbar(inventory);
            this.updateInventory((Inventory)inventory, 9, false);
            this.updateName();
            player.updateInventory();
        } else if (wandMode == WandMode.CHEST) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory, 0, true);
            player.updateInventory();
        }
    }

    private void updateHotbar(PlayerInventory playerInventory) {
        int currentSlot = playerInventory.getHeldItemSlot();
        ItemStack existingHotbar = this.hotbar.getItem(currentSlot);
        if (existingHotbar != null && existingHotbar.getType() != Material.AIR && !Wand.isWand(existingHotbar)) {
            this.hotbar.setItem(currentSlot, this.item);
            this.addToInventory(existingHotbar);
            this.hotbar.setItem(currentSlot, null);
        }
        playerInventory.setItem(currentSlot, this.item);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            if (hotbarSlot == currentSlot) continue;
            ItemStack hotbarItem = this.hotbar.getItem(hotbarSlot);
            this.updateInventoryName(hotbarItem, true);
            playerInventory.setItem(hotbarSlot, hotbarItem);
        }
    }

    private void updateInventory(Inventory targetInventory, int startOffset, boolean addHotbar) {
        int currentOffset = startOffset;
        if (this.openInventoryPage < this.inventories.size()) {
            Inventory inventory = this.inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
            }
        }
        if (addHotbar) {
            for (int i = 0; i < 9; ++i) {
                ItemStack inventoryItem = this.hotbar.getItem(i);
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset++, inventoryItem);
            }
        }
    }

    protected static void addSpellLore(SpellTemplate spell, List<String> lore, CostReducer reducer) {
        long duration;
        Collection<CastingCost> activeCosts;
        Collection<CastingCost> costs;
        String description = spell.getDescription();
        String usage = spell.getUsage();
        if (description != null && description.length() > 0) {
            lore.add(description);
        }
        if (usage != null && usage.length() > 0) {
            lore.add(usage);
        }
        if ((costs = spell.getCosts()) != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.costs_description").replace("$description", cost.getFullDescription(reducer)));
            }
        }
        if ((activeCosts = spell.getActiveCosts()) != null) {
            for (CastingCost cost : activeCosts) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(reducer)));
            }
        }
        if ((duration = spell.getDuration()) > 0L) {
            long seconds = duration / 1000L;
            if (seconds > 3600L) {
                long hours = seconds / 3600L;
                lore.add(Messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
            } else if (seconds > 60L) {
                long minutes = seconds / 60L;
                lore.add(Messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
            } else {
                lore.add(Messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
            }
        }
        if (spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride()) {
            lore.add(ChatColor.GOLD + Messages.get("spell.brush"));
        }
        if (spell instanceof UndoableSpell && ((UndoableSpell)spell).isUndoable()) {
            lore.add(ChatColor.GRAY + Messages.get("spell.undoable"));
        }
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.mage.hasStoredInventory()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (Wand.isWand(playerItem)) {
                playerItem = null;
            }
            this.hotbar.setItem(i, playerItem);
        }
        Inventory openInventory = this.getOpenInventory();
        for (int i = 0; i < openInventory.getSize(); ++i) {
            openInventory.setItem(i, playerInventory.getItem(i + 9));
        }
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    @Override
    public boolean enchant(int totalLevels) {
        return this.randomize(totalLevels, true);
    }

    protected boolean randomize(int totalLevels, boolean additive) {
        WandUpgradePath path = this.getPath();
        if (path == null) {
            return false;
        }
        int maxLevel = path.getMaxLevel();
        totalLevels = Math.min(totalLevels, maxLevel * 50);
        int addLevels = Math.min(totalLevels, maxLevel);
        boolean modified = true;
        while (addLevels > 0 && modified) {
            WandLevel level = path.getLevel(addLevels);
            modified = level.randomizeWand(this, additive);
            addLevels = Math.min(totalLevels -= maxLevel, maxLevel);
            additive = true;
        }
        return modified;
    }

    public static ItemStack createItem(MagicController controller, String templateName) {
        Wand wand;
        ItemStack item = Wand.createSpellItem(templateName, controller, null, true);
        if (item == null && (item = Wand.createBrushItem(templateName, controller, null, true)) == null && (wand = Wand.createWand(controller, templateName)) != null) {
            item = wand.getItem();
        }
        return item;
    }

    public static Wand createWand(MagicController controller, String templateName) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName);
        }
        catch (UnknownWandException ignore) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    protected void sendAddMessage(String messageKey, String nameParam) {
        if (this.mage == null) {
            return;
        }
        String message = Messages.get(messageKey).replace("$name", nameParam);
        this.mage.sendMessage(message);
    }

    public boolean add(Wand other) {
        Player player;
        if (!this.isModifiable() || !other.isModifiable()) {
            return false;
        }
        boolean modified = false;
        if (other.isForcedUpgrade() || other.costReduction > this.costReduction) {
            this.costReduction = other.costReduction;
            modified = true;
            if (this.costReduction > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.cost_reduction", this.costReduction));
            }
        }
        if (other.isForcedUpgrade() || other.power > this.power) {
            this.power = other.power;
            modified = true;
            if (this.power > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.power", this.power));
            }
        }
        if (other.isForcedUpgrade() || other.damageReduction > this.damageReduction) {
            this.damageReduction = other.damageReduction;
            modified = true;
            if (this.damageReduction > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection", this.damageReduction));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionPhysical > this.damageReductionPhysical) {
            this.damageReductionPhysical = other.damageReductionPhysical;
            modified = true;
            if (this.damageReductionPhysical > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection_physical", this.damageReductionPhysical));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionProjectiles > this.damageReductionProjectiles) {
            this.damageReductionProjectiles = other.damageReductionProjectiles;
            modified = true;
            if (this.damageReductionProjectiles > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection_projectile", this.damageReductionProjectiles));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionFalling > this.damageReductionFalling) {
            this.damageReductionFalling = other.damageReductionFalling;
            modified = true;
            if (this.damageReductionFalling > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection_falling", this.damageReductionFalling));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionFire > this.damageReductionFire) {
            this.damageReductionFire = other.damageReductionFire;
            modified = true;
            if (this.damageReductionFire > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection_fire", this.damageReductionFire));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionExplosions > this.damageReductionExplosions) {
            this.damageReductionExplosions = other.damageReductionExplosions;
            modified = true;
            if (this.damageReductionExplosions > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.protection_explosions", this.damageReductionExplosions));
            }
        }
        if (other.isForcedUpgrade() || other.healthRegeneration > this.healthRegeneration) {
            this.healthRegeneration = other.healthRegeneration;
            modified = true;
            if (this.healthRegeneration > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.health_regeneration", this.healthRegeneration));
            }
        }
        if (other.isForcedUpgrade() || other.hungerRegeneration > this.hungerRegeneration) {
            this.hungerRegeneration = other.hungerRegeneration;
            modified = true;
            if (this.hungerRegeneration > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.hunger_regeneration", this.hungerRegeneration));
            }
        }
        if (other.isForcedUpgrade() || other.speedIncrease > this.speedIncrease) {
            this.speedIncrease = other.speedIncrease;
            modified = true;
            if (this.speedIncrease > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", this.getLevelString("wand.haste", this.speedIncrease));
            }
        }
        if (other.effectColor != null) {
            this.effectColor = this.effectColor == null || other.isUpgrade() && other.effectColor != null ? other.effectColor : this.effectColor.mixColor(other.effectColor, (double)other.effectColorMixWeight);
            modified = true;
        }
        if (other.rename && other.template != null && other.template.length() > 0) {
            ConfigurationSection template = wandTemplates.get(other.template);
            this.wandName = template.getString("name", this.wandName);
            this.wandName = Messages.get("wands." + other.template + ".name", this.wandName);
            this.updateName();
        }
        modified |= !this.keep && other.keep;
        modified |= !this.bound && other.bound;
        modified |= !this.effectBubbles && other.effectBubbles;
        this.keep = this.keep || other.keep;
        this.bound = this.bound || other.bound;
        boolean bl = this.effectBubbles = this.effectBubbles || other.effectBubbles;
        if (other.effectParticle != null && (other.isUpgrade || this.effectParticle == null)) {
            modified |= this.effectParticle != other.effectParticle;
            this.effectParticle = other.effectParticle;
            modified |= this.effectParticleData != other.effectParticleData;
            this.effectParticleData = other.effectParticleData;
            modified |= this.effectParticleCount != other.effectParticleCount;
            this.effectParticleCount = other.effectParticleCount;
            modified |= this.effectParticleInterval != other.effectParticleInterval;
            this.effectParticleInterval = other.effectParticleInterval;
        }
        if (other.effectSound != null && (other.isUpgrade || this.effectSound == null)) {
            modified |= this.effectSound != other.effectSound;
            this.effectSound = other.effectSound;
            modified |= this.effectSoundInterval != other.effectSoundInterval;
            this.effectSoundInterval = other.effectSoundInterval;
            modified |= this.effectSoundVolume != other.effectSoundVolume;
            this.effectSoundVolume = other.effectSoundVolume;
            modified |= this.effectSoundPitch != other.effectSoundPitch;
            this.effectSoundPitch = other.effectSoundPitch;
        }
        if ((this.template == null || this.template.length() == 0) && other.template != null && other.template.length() > 0) {
            modified = true;
            this.template = other.template;
        }
        if (other.isUpgrade && other.mode != null) {
            modified |= this.mode != other.mode;
            this.setMode(other.mode);
        }
        if (this.isCostFree()) {
            this.xpRegeneration = 0;
            this.xpMax = 0;
            this.xp = 0;
        } else {
            if (other.isForcedUpgrade() || other.xpRegeneration > this.xpRegeneration) {
                this.xpRegeneration = other.xpRegeneration;
                modified = true;
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString("wand.mana_regeneration", this.xpRegeneration, WandLevel.maxXpRegeneration));
            }
            if (other.isForcedUpgrade() || other.xpMax > this.xpMax) {
                this.xpMax = other.xpMax;
                modified = true;
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString("wand.mana_amount", this.xpMax, WandLevel.maxMaxXp));
            }
            if (other.isForcedUpgrade() || other.xp > this.xp) {
                this.xp = other.xp;
                modified = true;
            }
        }
        if (this.uses == 0 || other.uses == 0) {
            modified |= this.uses != 0;
            this.uses = 0;
        } else {
            modified |= other.uses != 0;
            this.uses += other.uses;
        }
        Collection spells = other.getSpells();
        for (String spellKey : spells) {
            if (!this.addSpell(spellKey)) continue;
            modified = true;
            String spellName = spellKey;
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell != null) {
                spellName = spell.getName();
            }
            if (this.mage == null) continue;
            this.mage.sendMessage(Messages.get("wand.spell_added").replace("$name", spellName));
        }
        Collection materials = other.getBrushes();
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey)) continue;
            modified = true;
            if (this.mage == null) continue;
            this.mage.sendMessage(Messages.get("wand.brush_added").replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
        }
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (other.autoFill && player != null) {
            this.fill(player);
            modified = true;
            if (this.mage != null) {
                this.mage.sendMessage(Messages.get("wand.filled"));
            }
        }
        if (other.autoOrganize && this.mage != null) {
            this.organizeInventory(this.mage);
            modified = true;
            if (this.mage != null) {
                this.mage.sendMessage(Messages.get("wand.reorganized"));
            }
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return modified;
    }

    public boolean isForcedUpgrade() {
        return this.isUpgrade && this.forceUpgrade;
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static void loadTemplates(ConfigurationSection properties) {
        wandTemplates.clear();
        Set wandKeys = properties.getKeys(false);
        for (String key : wandKeys) {
            ConfigurationSection wandNode = properties.getConfigurationSection(key);
            wandNode.set("key", (Object)key);
            ConfigurationSection existing = wandTemplates.get(key);
            if (existing != null) {
                Set overrideKeys = existing.getKeys(false);
                for (String propertyKey : overrideKeys) {
                    existing.set(propertyKey, existing.get(key));
                }
            } else {
                wandTemplates.put(key, wandNode);
            }
            if (wandNode.getBoolean("enabled", true)) continue;
            wandTemplates.remove(key);
        }
    }

    public static Collection<String> getWandKeys() {
        return wandTemplates.keySet();
    }

    public static Collection<ConfigurationSection> getWandTemplates() {
        return wandTemplates.values();
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        for (WandMode testMode : WandMode.values()) {
            if (!testMode.name().equalsIgnoreCase(modeString)) continue;
            return testMode;
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeMaterial);
        }
    }

    public void toggleInventory() {
        if (!this.hasInventory) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                Collection spells = this.getSpells();
                if (spells.size() > 1) {
                    this.hasInventory = true;
                }
                if (spells.size() > 0) {
                    this.activeSpell = (String)spells.iterator().next();
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void cycleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            int inventoryCount = this.inventories.size();
            this.openInventoryPage = inventoryCount == 0 ? 0 : (this.openInventoryPage + 1) % inventoryCount;
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                this.mage.playSound(Sound.CHEST_OPEN, 0.3f, 1.5f);
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    private void openInventory() {
        if (this.mage == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST) {
            this.inventoryIsOpen = true;
            this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.mage.hasStoredInventory()) {
                return;
            }
            if (this.mage.storeInventory()) {
                this.inventoryIsOpen = true;
                this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
                this.updateInventory();
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    @Override
    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.saveInventory();
        this.inventoryIsOpen = false;
        if (this.mage != null) {
            this.mage.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
            if (this.getMode() == WandMode.INVENTORY) {
                this.mage.restoreInventory();
                Player player = this.mage.getPlayer();
                player.setItemInHand(this.item);
                player.updateInventory();
            } else {
                this.mage.getPlayer().closeInventory();
            }
        }
    }

    @Override
    public boolean fill(Player player) {
        Collection<SpellTemplate> allSpells = this.controller.getPlugin().getSpellTemplates();
        for (SpellTemplate spell : allSpells) {
            if (!spell.hasCastPermission((CommandSender)player) || spell.getIcon().getMaterial() == Material.AIR) continue;
            this.addSpell(spell.getKey());
        }
        this.autoFill = false;
        this.saveState();
        return true;
    }

    public void activate(Mage mage, ItemStack wandItem) {
        if (mage == null || wandItem == null) {
            return;
        }
        if (this.isUpgrade) {
            this.controller.getLogger().warning("Activated an upgrade item- this shouldn't happen");
            return;
        }
        this.item = wandItem;
        this.mage = mage;
        Player player = mage.getPlayer();
        boolean modified = false;
        ItemStack[] items = player.getInventory().getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (!this.addItem(item)) continue;
            modified = true;
            items[i] = null;
        }
        if (modified) {
            player.getInventory().setContents(items);
        }
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill) && this.getSpells().size() == 0) {
            this.fill(mage.getPlayer());
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
        }
        if (!(!this.bound || this.ownerId != null && this.ownerId.length() != 0 || this.controller.hasPermission(player, "Magic.wand.override_bind", false) || this.owner != null && this.owner.length() != 0 && !this.owner.equals(player.getName()))) {
            this.takeOwnership(mage.getPlayer());
            this.saveState();
        }
        if (this.randomize) {
            this.randomize();
        }
        this.checkActiveMaterial();
        mage.setActiveWand(this);
        if (this.usesMana()) {
            this.storedXpLevel = player.getLevel();
            this.storedXpProgress = player.getExp();
            this.storedXp = 0;
            this.updateMana();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.updateEffects();
    }

    protected void randomize() {
        ConfigurationSection wandConfig;
        boolean modified = this.randomize;
        if (this.description.contains("$")) {
            Matcher matcher = Messages.PARAMETER_PATTERN.matcher(this.description);
            while (matcher.find()) {
                String key = matcher.group(1);
                if (key == null) continue;
                modified = true;
                this.description = this.description.replace("$" + key, Messages.getRandomized(key));
                this.updateLore();
            }
        }
        if (this.template != null && this.template.length() > 0 && (wandConfig = wandTemplates.get(this.template)) != null && wandConfig.contains("icon")) {
            String iconKey = wandConfig.getString("icon");
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            modified = true;
        }
        this.randomize = false;
        if (modified) {
            this.saveState();
        }
    }

    protected void checkActiveMaterial() {
        Collection materials;
        if ((this.activeMaterial == null || this.activeMaterial.length() == 0) && (materials = this.getBrushes()).size() > 0) {
            this.activeMaterial = (String)materials.iterator().next();
        }
    }

    public boolean addItem(ItemStack item) {
        if (this.isUpgrade) {
            return false;
        }
        if (Wand.isSpell(item)) {
            SpellTemplate spell;
            String spellKey = Wand.getSpell(item);
            Collection spells = this.getSpells();
            if (!spells.contains(spellKey) && this.addSpell(spellKey) && (spell = this.controller.getSpellTemplate(spellKey)) != null) {
                this.mage.sendMessage(Messages.get("wand.spell_added").replace("$name", spell.getName()));
                return true;
            }
        } else if (Wand.isBrush(item)) {
            String materialKey = Wand.getBrush(item);
            Collection materials = this.getBrushes();
            if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                this.mage.sendMessage(Messages.get("wand.brush_added").replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
                return true;
            }
        } else if (Wand.isUpgrade(item)) {
            Wand wand = new Wand(this.controller, item);
            return this.add(wand);
        }
        return false;
    }

    protected void updateEffects() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles) {
            CompatibilityUtils.addPotionEffect((LivingEntity)player, this.effectColor.getColor());
        }
        Location location = this.mage.getLocation();
        if (this.effectParticle != null && location != null && this.effectParticleCounter++ % this.effectParticleInterval == 0) {
            if (this.effectPlayer == null) {
                this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                this.effectPlayer.setParticleCount(2);
                this.effectPlayer.setIterations(2);
                this.effectPlayer.setRadius(2.0f);
                this.effectPlayer.setSize(5);
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
            }
            this.effectPlayer.setParticleType(this.effectParticle);
            this.effectPlayer.setParticleData(this.effectParticleData);
            this.effectPlayer.setParticleCount(this.effectParticleCount);
            this.effectPlayer.start(player.getEyeLocation(), null);
        }
        if (this.effectSound != null && location != null && this.controller.soundsEnabled() && this.effectSoundCounter++ % this.effectSoundInterval == 0) {
            this.mage.getLocation().getWorld().playSound(location, this.effectSound, this.effectSoundVolume, this.effectSoundPitch);
        }
    }

    protected void updateMana() {
        if (this.mage != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.mage.getPlayer();
            if (displayManaAsBar) {
                if (!retainLevelDisplay) {
                    player.setLevel(0);
                }
                player.setExp((float)this.xp / (float)this.xpMax);
            } else {
                player.setLevel(this.xp);
                player.setExp(0.0f);
            }
        }
    }

    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    @Override
    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (this.effectBubbles && player != null) {
            CompatibilityUtils.removePotionEffect((LivingEntity)player);
        }
        this.mage.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.mage.restoreInventory();
        if (this.usesMana() && player != null) {
            player.setExp(this.storedXpProgress);
            player.setLevel(this.storedXpLevel);
            player.giveExp(this.storedXp);
            this.storedXp = 0;
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        this.mage.setActiveWand(null);
        this.mage = null;
        this.saveState();
    }

    @Override
    public Spell getActiveSpell() {
        if (this.mage == null || this.activeSpell == null || this.activeSpell.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.activeSpell);
    }

    @Override
    public String getActiveSpellKey() {
        return this.activeSpell;
    }

    @Override
    public String getActiveBrushKey() {
        return this.activeMaterial;
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null && spell.cast(this.castParameters)) {
            Color spellColor = spell.getColor();
            if (spellColor != null && this.effectColor != null) {
                this.effectColor = this.effectColor.mixColor(spellColor, (double)this.effectColorSpellMixWeight);
            }
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.mage == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                Player player = this.mage.getPlayer();
                this.mage.playSound(Sound.ITEM_BREAK, 1.0f, 0.8f);
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
                this.deactivate();
            } else {
                this.updateName();
                this.updateLore();
                this.saveState();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.mage == null) {
            return;
        }
        if (this.addExperience(event.getAmount())) {
            event.setAmount(0);
        }
    }

    public boolean addExperience(int xp) {
        if (this.usesMana()) {
            this.storedXp += xp;
            return true;
        }
        return false;
    }

    public void tick() {
        int regenLevel;
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.speedIncrease > 0.0f) {
            int hasteLevel = (int)(this.speedIncrease * WandLevel.maxHasteLevel);
            if (this.hasteEffect == null || this.hasteEffect.getAmplifier() != hasteLevel) {
                this.hasteEffect = new PotionEffect(PotionEffectType.SPEED, 80, hasteLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.hasteEffect);
        }
        if (this.healthRegeneration > 0.0f) {
            regenLevel = (int)(this.healthRegeneration * WandLevel.maxHealthRegeneration);
            if (this.healthRegenEffect == null || this.healthRegenEffect.getAmplifier() != regenLevel) {
                this.healthRegenEffect = new PotionEffect(PotionEffectType.REGENERATION, 80, regenLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.healthRegenEffect);
        }
        if (this.hungerRegeneration > 0.0f) {
            regenLevel = (int)(this.hungerRegeneration * WandLevel.maxHungerRegeneration);
            if (this.hungerRegenEffect == null || this.hungerRegenEffect.getAmplifier() != regenLevel) {
                this.hungerRegenEffect = new PotionEffect(PotionEffectType.SATURATION, 80, regenLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.hungerRegenEffect);
        }
        if (this.usesMana()) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
        this.updateEffects();
    }

    public MagicController getMaster() {
        return this.controller;
    }

    public void cycleSpells(ItemStack newItem) {
        Collection spellsSet;
        ArrayList spells;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((spells = new ArrayList(spellsSet = this.getSpells())).size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = ((String)spells.get(0)).split("@")[0];
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.size(); ++i) {
            if (!((String)spells.get(i)).split("@")[0].equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + 1) % spells.size();
        this.setActiveSpell(((String)spells.get(spellIndex)).split("@")[0]);
    }

    public void cycleMaterials(ItemStack newItem) {
        Collection materialsSet;
        ArrayList materials;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((materials = new ArrayList(materialsSet = this.getBrushes())).size() == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = ((String)materials.get(0)).split("@")[0];
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.size(); ++i) {
            if (!((String)materials.get(i)).split("@")[0].equals(this.activeMaterial)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + 1) % materials.size();
        this.activateBrush(((String)materials.get(materialIndex)).split("@")[0]);
    }

    public boolean hasExperience() {
        return this.xpRegeneration > 0;
    }

    public Mage getActivePlayer() {
        return this.mage;
    }

    protected void clearInventories() {
        this.inventories.clear();
        this.hotbar.clear();
    }

    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    public Inventory getHotbar() {
        return this.hotbar;
    }

    public WandMode getMode() {
        return this.mode != null ? this.mode : this.controller.getDefaultWandMode();
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    public boolean showMessages() {
        return this.quietLevel < 2;
    }

    @Override
    public boolean isLost() {
        return this.id != null;
    }

    @Override
    public boolean isLost(com.elmakers.mine.bukkit.api.wand.LostWand lostWand) {
        return this.id != null && this.id.equals(lostWand.getId());
    }

    @Override
    public LostWand makeLost(Location location) {
        if (this.id == null || this.id.length() == 0) {
            this.id = UUID.randomUUID().toString();
            this.saveState();
        }
        return new LostWand(this, location);
    }

    @Override
    public void activate(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Player player = mage.getPlayer();
        if (!Wand.hasActiveWand(player)) {
            this.controller.getLogger().warning("Wand activated without holding a wand!");
            try {
                throw new Exception("Wand activated without holding a wand!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!this.canUse(player)) {
            mage.sendMessage(Messages.get("wand.bound").replace("$name", this.owner));
            player.setItemInHand(null);
            Location location = player.getLocation();
            location.setY(location.getY() + 1.0);
            this.controller.addLostWand(this.makeLost(location));
            this.saveState();
            Item droppedItem = player.getWorld().dropItemNaturally(location, this.item);
            Vector velocity = droppedItem.getVelocity();
            velocity.setY(velocity.getY() * 2.0 + 1.0);
            droppedItem.setVelocity(velocity);
            return;
        }
        this.id = null;
        if (mage instanceof Mage) {
            this.activate((Mage)mage, player.getItemInHand());
        }
    }

    @Override
    public void organizeInventory(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        organizer.organize();
        this.openInventoryPage = 0;
        this.autoOrganize = false;
        this.saveState();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand duplicate() {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        Wand newWand = new Wand(this.controller, newItem);
        newWand.saveState();
        return newWand;
    }

    @Override
    public boolean configure(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toNodeList(convertedProperties), false);
        this.saveState();
        return true;
    }

    @Override
    public boolean upgrade(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toNodeList(convertedProperties), true);
        this.saveState();
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean canUse(Player player) {
        if (!this.bound || this.owner == null || this.owner.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind", false)) {
            return true;
        }
        if (this.ownerId == null || this.ownerId.length() == 0) {
            return this.owner.equalsIgnoreCase(player.getName());
        }
        return this.ownerId.equalsIgnoreCase(player.getUniqueId().toString());
    }

    @Override
    public boolean addSpell(String spellName) {
        ItemStack spellItem;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.hasSpell(spellName)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((spellItem = this.createSpellIcon(spellName)) == null) {
            return false;
        }
        this.spells.add(spellName);
        this.addToInventory(spellItem);
        this.updateInventory();
        this.hasInventory = this.getSpells().size() + this.getBrushes().size() > 1;
        this.updateLore();
        this.saveState();
        return true;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    @Override
    public boolean hasBrush(String materialKey) {
        return this.getBrushes().contains(materialKey);
    }

    @Override
    public boolean hasSpell(String spellName) {
        return this.getSpells().contains(spellName);
    }

    @Override
    public boolean addBrush(String materialKey) {
        ItemStack itemStack;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.hasBrush(materialKey)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((itemStack = this.createBrushIcon(materialKey)) == null) {
            return false;
        }
        this.brushes.add(materialKey);
        this.addToInventory(itemStack);
        if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
            this.setActiveBrush(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateLore();
        this.hasInventory = this.getSpells().size() + this.getBrushes().size() > 1;
        this.saveState();
        return true;
    }

    @Override
    public void setActiveBrush(String materialKey) {
        this.activeMaterial = materialKey;
        this.updateName();
        this.updateActiveMaterial();
        this.updateHotbar();
        this.saveState();
    }

    @Override
    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.saveState();
    }

    @Override
    public boolean removeBrush(String materialKey) {
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (materialKey.equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        this.brushes.remove(materialKey);
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || !Wand.isBrush(itemStack)) continue;
                String itemKey = Wand.getBrush(itemStack);
                if (itemKey.equals(materialKey)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeMaterial == null) {
                    this.activeMaterial = materialKey;
                }
                if (found && this.activeMaterial != null) continue block0;
            }
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return found;
    }

    @Override
    public boolean removeSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        this.spells.remove(spellName);
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || itemStack.getType() == Material.AIR || !Wand.isSpell(itemStack)) continue;
                if (Wand.getSpell(itemStack).equals(spellName)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeSpell == null) {
                    this.activeSpell = Wand.getSpell(itemStack);
                }
                if (found && this.activeSpell != null) continue block0;
            }
        }
        this.updateName();
        this.updateLore();
        this.saveState();
        this.updateInventory();
        return found;
    }

    static {
        PROPERTY_KEYS = new String[]{"active_spell", "active_material", "path", "xp", "xp_regeneration", "xp_max", "bound", "uses", "upgrade", "indestructible", "cost_reduction", "cooldown_reduction", "effect_bubbles", "effect_color", "effect_particle", "effect_particle_count", "effect_particle_data", "effect_particle_interval", "effect_sound", "effect_sound_interval", "effect_sound_pitch", "effect_sound_volume", "haste", "health_regeneration", "hunger_regeneration", "icon", "mode", "keep", "locked", "quiet", "force", "randomize", "rename", "power", "overrides", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "materials", "spells"};
        HIDDEN_PROPERTY_KEYS = new String[]{"id", "owner", "owner_id", "name", "description", "template", "organize", "fill"};
        ALL_PROPERTY_KEYS = (String[])ArrayUtils.addAll((Object[])PROPERTY_KEYS, (Object[])HIDDEN_PROPERTY_KEYS);
        wandTemplates = new HashMap<String, ConfigurationSection>();
        displayManaAsBar = true;
        retainLevelDisplay = true;
        DefaultUpgradeMaterial = Material.NETHER_STAR;
        DefaultWandMaterial = Material.BLAZE_ROD;
        EnchantableWandMaterial = null;
        EnableGlow = true;
    }
}

