/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.util;

import com.elmakers.mine.bukkit.slikey.effectlib.util.ReflectionHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public enum ParticleEffect {
    HUGE_EXPLOSION("hugeexplosion"),
    LARGE_EXPLODE("largeexplode"),
    FIREWORKS_SPARK("fireworksSpark"),
    BUBBLE("bubble"),
    SUSPEND("suspend"),
    DEPTH_SUSPEND("depthSuspend"),
    TOWN_AURA("townaura"),
    CRIT("crit"),
    MAGIC_CRIT("magicCrit"),
    SMOKE("smoke"),
    MOB_SPELL("mobSpell"),
    MOB_SPELL_AMBIENT("mobSpellAmbient"),
    SPELL("spell"),
    INSTANT_SPELL("instantSpell"),
    WITCH_MAGIC("witchMagic"),
    NOTE("note"),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchantmenttable"),
    EXPLODE("explode"),
    FLAME("flame"),
    LAVA("lava"),
    FOOTSTEP("footstep"),
    SPLASH("splash"),
    WAKE("wake"),
    LARGE_SMOKE("largesmoke"),
    CLOUD("cloud"),
    RED_DUST("reddust"),
    SNOWBALL_POOF("snowballpoof"),
    DRIP_WATER("dripWater"),
    DRIP_LAVA("dripLava"),
    SNOW_SHOVEL("snowshovel"),
    SLIME("slime"),
    HEART("heart"),
    ANGRY_VILLAGER("angryVillager"),
    HAPPY_VILLAGER("happyVillager");

    private static final Map<String, ParticleEffect> NAME_MAP;
    private static final double MAX_RANGE = 50.0;
    private static Constructor<?> packetPlayOutWorldParticles;
    private static boolean legacy;
    private static Method getHandle;
    private static Field playerConnection;
    private static Method sendPacket;
    private final String name;

    private ParticleEffect(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ParticleEffect fromName(String name) {
        if (name != null) {
            for (Map.Entry<String, ParticleEffect> e : NAME_MAP.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(name)) continue;
                return e.getValue();
            }
        }
        return null;
    }

    private static List<Player> getPlayers(Location center, double range) {
        ArrayList<Player> players = new ArrayList<Player>();
        double squared = range * range;
        for (Player p : center.getWorld().getPlayers()) {
            if (!(p.getLocation().distanceSquared(center) <= squared)) continue;
            players.add(p);
        }
        return players;
    }

    private static Object instantiatePacket(String name, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (amount < 1) {
            amount = 1;
        }
        try {
            if (legacy) {
                Object packet = packetPlayOutWorldParticles.newInstance(new Object[0]);
                for (Field field : packet.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    if (fieldName.equals("a")) {
                        field.set(packet, name);
                        continue;
                    }
                    if (fieldName.equals("b")) {
                        field.setFloat(packet, (float)center.getX());
                        continue;
                    }
                    if (fieldName.equals("c")) {
                        field.setFloat(packet, (float)center.getY());
                        continue;
                    }
                    if (fieldName.equals("d")) {
                        field.setFloat(packet, (float)center.getZ());
                        continue;
                    }
                    if (fieldName.equals("e")) {
                        field.setFloat(packet, offsetX);
                        continue;
                    }
                    if (fieldName.equals("f")) {
                        field.setFloat(packet, offsetY);
                        continue;
                    }
                    if (fieldName.equals("g")) {
                        field.setFloat(packet, offsetZ);
                        continue;
                    }
                    if (fieldName.equals("h")) {
                        field.setFloat(packet, speed);
                        continue;
                    }
                    if (!fieldName.equals("i")) continue;
                    field.setInt(packet, amount);
                }
                return packet;
            }
            return packetPlayOutWorldParticles.newInstance(name, Float.valueOf((float)center.getX()), Float.valueOf((float)center.getY()), Float.valueOf((float)center.getZ()), Float.valueOf(offsetX), Float.valueOf(offsetY), Float.valueOf(offsetZ), Float.valueOf(speed), amount);
        }
        catch (Exception e) {
            throw new PacketInstantiationException("Packet instantiation failed", e);
        }
    }

    private static Object instantiateIconCrackPacket(int id, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.instantiatePacket("iconcrack_" + id, center, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static Object instantiateBlockCrackPacket(int id, byte data, Location center, float offsetX, float offsetY, float offsetZ, int amount) {
        return ParticleEffect.instantiatePacket("blockcrack_" + id + "_" + data, center, offsetX, offsetY, offsetZ, 0.0f, amount);
    }

    private static Object instantiateBlockDustPacket(int id, byte data, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.instantiatePacket("blockdust_" + id + "_" + data, center, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static void sendPacket(Player p, Object packet) {
        try {
            sendPacket.invoke(playerConnection.get(getHandle.invoke((Object)p, new Object[0])), packet);
        }
        catch (Exception e) {
            throw new PacketSendingException("Failed to send a packet to player '" + p.getName() + "'", e);
        }
    }

    private static void sendPacket(Collection<Player> players, Object packet) {
        for (Player p : players) {
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public void display(Location center, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 50.0) {
            range = 50.0;
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayers(center, range), ParticleEffect.instantiatePacket(this.name, center, offsetX, offsetY, offsetZ, speed, amount));
    }

    public void display(Location center, double range) {
        this.display(center, range, 0.0f, 0.0f, 0.0f, 0.0f, 0);
    }

    public void display(Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        this.display(center, 50.0, offsetX, offsetY, offsetZ, speed, amount);
    }

    public static void displayIconCrack(Location center, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.instantiateIconCrackPacket(id, center, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayIconCrack(Location center, double range, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 50.0) {
            throw new IllegalArgumentException("Range has to be lower/equal the maximum of 16");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayers(center, range), ParticleEffect.instantiateIconCrackPacket(id, center, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayIconCrack(Location center, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.displayIconCrack(center, 50.0, id, offsetX, offsetY, offsetZ, speed, amount);
    }

    public static void displayBlockCrack(Location center, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.instantiateBlockCrackPacket(id, data, center, offsetX, offsetY, offsetZ, amount));
    }

    public static void displayBlockCrack(Location center, double range, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount) {
        if (range > 50.0) {
            throw new IllegalArgumentException("Range has to be lower/equal the maximum of 16");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayers(center, range), ParticleEffect.instantiateBlockCrackPacket(id, data, center, offsetX, offsetY, offsetZ, amount));
    }

    public static void displayBlockCrack(Location center, int id, byte data, float offsetX, float offsetY, float offsetZ, int amount) {
        ParticleEffect.displayBlockCrack(center, 50.0, id, data, offsetX, offsetY, offsetZ, amount);
    }

    public static void displayBlockDust(Location center, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.instantiateBlockDustPacket(id, data, center, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockDust(Location center, double range, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 50.0) {
            throw new IllegalArgumentException("Range has to be lower/equal the maximum of 16");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayers(center, range), ParticleEffect.instantiateBlockDustPacket(id, data, center, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockDust(Location center, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.displayBlockDust(center, 50.0, id, data, offsetX, offsetY, offsetZ, speed, amount);
    }

    static {
        NAME_MAP = new HashMap<String, ParticleEffect>();
        legacy = false;
        for (ParticleEffect p : ParticleEffect.values()) {
            NAME_MAP.put(p.name, p);
        }
        try {
            packetPlayOutWorldParticles = ReflectionHandler.getConstructor(ReflectionHandler.PacketType.PLAY_OUT_WORLD_PARTICLES.getPacket(), String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            if (packetPlayOutWorldParticles == null) {
                packetPlayOutWorldParticles = ReflectionHandler.getConstructor(ReflectionHandler.PacketType.PLAY_OUT_WORLD_PARTICLES.getPacket(), new Class[0]);
                legacy = true;
            }
            getHandle = ReflectionHandler.getMethod("CraftPlayer", ReflectionHandler.SubPackageType.ENTITY, "getHandle", new Class[0]);
            playerConnection = ReflectionHandler.getField("EntityPlayer", ReflectionHandler.PackageType.MINECRAFT_SERVER, "playerConnection");
            sendPacket = ReflectionHandler.getMethod(playerConnection.getType(), "sendPacket", ReflectionHandler.getClass("Packet", ReflectionHandler.PackageType.MINECRAFT_SERVER));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class PacketSendingException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public PacketSendingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class PacketInstantiationException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public PacketInstantiationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

