/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class EffectColorVariation
extends EffectPlayer {
    private Map<Double, Collection<EffectPlayer>> brightnessMap = new TreeMap<Double, Collection<EffectPlayer>>();

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        super.load(plugin, configuration);
        ConfigurationSection brightness = configuration.getConfigurationSection("brightness");
        if (brightness != null) {
            Set keys = brightness.getKeys(false);
            for (String key : keys) {
                try {
                    double level = Double.parseDouble(key);
                    this.brightnessMap.put(level, EffectPlayer.loadEffects(plugin, brightness, key));
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public void play() {
        if (this.brightnessMap.size() > 0) {
            Color color = this.getColor1();
            double brightness = (double)color.getRed() / 255.0 + (double)color.getBlue() / 255.0 + (double)color.getGreen() / 255.0;
            for (Map.Entry<Double, Collection<EffectPlayer>> entry : this.brightnessMap.entrySet()) {
                if (!(brightness < entry.getKey())) continue;
                for (EffectPlayer player : entry.getValue()) {
                    player.play();
                }
            }
        }
    }
}

