/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.AscendingPair;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class RandomUtils {
    private static final Random random = new Random();

    public static float lerp(String[] list, int levelIndex, int nextLevelIndex, float distance) {
        float previousValue = Float.parseFloat(list[levelIndex]);
        float nextValue = Float.parseFloat(list[nextLevelIndex]);
        return RandomUtils.lerp(Float.valueOf(previousValue), Float.valueOf(nextValue), distance).floatValue();
    }

    public static <T extends Number> T lerp(T previousValue, T nextValue, float distance) {
        return (T)Float.valueOf(((Float)previousValue).floatValue() + distance * (((Float)nextValue).floatValue() - ((Float)previousValue).floatValue()));
    }

    public static <T> T weightedRandom(LinkedList<WeightedPair<T>> weightList) {
        if (weightList.size() == 0) {
            return null;
        }
        Float maxWeight = weightList.getLast().getThreshold();
        Float selectedWeight = Float.valueOf(random.nextFloat() * maxWeight.floatValue());
        for (WeightedPair weightedPair : weightList) {
            if (!(selectedWeight.floatValue() < weightedPair.getThreshold().floatValue())) continue;
            return weightedPair.getValue();
        }
        return weightList.getFirst().getValue();
    }

    public static void populateIntegerProbabilityMap(LinkedList<WeightedPair<Integer>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateIntegerProbabilityMap(LinkedList<WeightedPair<Integer>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static void populateStringProbabilityMap(LinkedList<WeightedPair<String>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateStringProbabilityMap(LinkedList<WeightedPair<String>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static void populateFloatProbabilityMap(LinkedList<WeightedPair<Float>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateFloatProbabilityMap(LinkedList<WeightedPair<Float>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static <T> void populateProbabilityMap(Class<T> valueClass, LinkedList<WeightedPair<T>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        Float currentThreshold = Float.valueOf(0.0f);
        if (nodeMap != null) {
            Set keys = nodeMap.getKeys(false);
            for (String key : keys) {
                String value = nodeMap.getString(key);
                key = key.replace("^", ".");
                String[] pieces = value.split(",");
                currentThreshold = pieces != null && pieces.length > 1 ? Float.valueOf(currentThreshold.floatValue() + RandomUtils.lerp(pieces, levelIndex, nextLevelIndex, distance)) : Float.valueOf(currentThreshold.floatValue() + Float.parseFloat(value));
                probabilityMap.add(new WeightedPair<T>(currentThreshold, key, valueClass));
            }
        }
    }

    public static String getEntry(String csvList, int index) {
        if (csvList == null) {
            return null;
        }
        String[] pieces = csvList.split(",");
        if (pieces == null || pieces.length <= 1) {
            return csvList;
        }
        if (index < 0 || index >= pieces.length) {
            return null;
        }
        return pieces[index];
    }

    public static void extrapolateFloatList(List<AscendingPair<Float>> list) {
        RandomUtils.extrapolateList(Float.class, list);
    }

    public static void extrapolateIntegerList(List<AscendingPair<Integer>> list) {
        RandomUtils.extrapolateList(Integer.class, list);
    }

    public static <T extends Number> void extrapolateList(Class<T> valueClass, List<AscendingPair<T>> list) {
        Collections.sort(list);
        for (int index = 0; index < list.size() - 1; ++index) {
            AscendingPair<T> current = list.get(index);
            AscendingPair<T> next = list.get(index + 1);
            long currentIndex = current.getIndex();
            long nextIndex = next.getIndex();
            if (nextIndex <= currentIndex + 1L) continue;
            float distance = 1.0f / (float)(nextIndex - currentIndex);
            AscendingPair<T> inserted = new AscendingPair<T>(currentIndex + 1L, RandomUtils.lerp(current.getValue(), next.getValue(), distance));
            list.add(index, inserted);
        }
    }
}

