/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.BlockBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.batch.SpellBatch;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class UndoSpell
extends TargetingSpell {
    private String undoListName;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock;
        Target target = this.getTarget();
        Entity caster = this.mage.getEntity();
        int timeout = parameters.getInt("target_timeout", 0);
        if (target.hasEntity() && this.controller.isMage(target.getEntity())) {
            Mage mage = this.controller.getMage(target.getEntity());
            UndoQueue queue = mage.getUndoQueue();
            UndoList undoList = queue.undoRecent(timeout);
            if (undoList != null) {
                this.undoListName = undoList.getName();
            }
            return undoList != null ? SpellResult.CAST : SpellResult.FAIL;
        }
        if (!parameters.getBoolean("target_blocks", true)) {
            return SpellResult.NO_TARGET;
        }
        Block block = targetBlock = this.isLookingDown() ? this.getLocation().getBlock() : target.getBlock();
        if (targetBlock != null) {
            boolean targetAll = this.mage.isSuperPowered();
            if (targetAll) {
                UndoList undid = this.controller.undoRecent(targetBlock, timeout);
                if (undid != null) {
                    Mage targetMage = undid.getOwner();
                    this.undoListName = undid.getName();
                    this.setTargetName(targetMage.getName());
                    return SpellResult.CAST;
                }
            } else {
                this.setTargetName(this.mage.getName());
                BlockBatch batch = this.mage.cancelPending();
                if (batch != null) {
                    this.undoListName = batch instanceof SpellBatch ? ((SpellBatch)batch).getSpell().getName() : null;
                    return SpellResult.COST_FREE;
                }
                UndoList undoList = this.mage.undo(targetBlock);
                if (undoList != null) {
                    this.undoListName = undoList.getName();
                    return SpellResult.CAST;
                }
            }
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$spell", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

