/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

public class PotionEffectSpell
extends UndoableSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasEntity() || !(target.getEntity() instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity targetEntity = (LivingEntity)target.getEntity();
        if (targetEntity != this.mage.getEntity() && this.controller.isMage((Entity)targetEntity)) {
            Mage targetMage = this.controller.getMage((Entity)targetEntity);
            if (targetMage.isSuperProtected()) {
                return SpellResult.NO_TARGET;
            }
            if (parameters.getBoolean("deactivate_target_mage")) {
                targetMage.deactivateAllSpells();
            }
        }
        Collection<PotionEffect> effects = PotionEffectSpell.getPotionEffects(parameters);
        this.registerPotionEffects((Entity)targetEntity);
        CompatibilityUtils.applyPotionEffects(targetEntity, effects);
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

