/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class LevitateSpell
extends TargetingSpell
implements Listener {
    private static final float defaultFlySpeed = 0.1f;
    private long levitateEnded;
    private final long safetyLength = 10000L;
    private static final int effectSpeed = 2;
    private static final int effectPeriod = 2;
    private static final int minRingEffectRange = 1;
    private static final int maxRingEffectRange = 8;
    private static final int maxDamageAmount = 150;
    private float flySpeed = 0.0f;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Player player = this.mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.flySpeed = (float)parameters.getDouble("speed", 0.0);
        if (player.getAllowFlight()) {
            this.deactivate();
            return SpellResult.COST_FREE;
        }
        this.activate();
        return SpellResult.CAST;
    }

    @Override
    public void onDeactivate() {
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.flySpeed > 0.0f) {
            player.setFlySpeed(0.1f);
        }
        player.setFlying(false);
        player.setAllowFlight(false);
        this.mage.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.levitateEnded = System.currentTimeMillis();
    }

    @Override
    public void onActivate() {
        final Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.flySpeed > 0.0f) {
            player.setFlySpeed(this.flySpeed * 0.1f);
        }
        Vector velocity = player.getVelocity();
        velocity.setY(velocity.getY() + 2.0);
        player.setVelocity(velocity);
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                player.setAllowFlight(true);
                player.setFlying(true);
            }
        }, 2L);
    }

    @Override
    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.mage.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.levitateEnded == 0L) {
            return;
        }
        if (this.levitateEnded + 10000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.levitateEnded = 0L;
            Location effectLocation = event.getEntity().getLocation();
            Block block = event.getEntity().getLocation().getBlock();
            block = block.getRelative(BlockFace.DOWN);
            int ringEffectRange = (int)Math.ceil(7.0 * event.getDamage() / 150.0 + 1.0);
            int effectRange = Math.min(8, ringEffectRange);
            effectRange = Math.min(this.getMaxRange(), effectRange / 2);
            EffectRing effect = new EffectRing(this.controller.getPlugin());
            effect.setRadius(effectRange);
            effect.setEffect(Effect.STEP_SOUND);
            effect.setEffectData(block.getTypeId());
            effect.setPeriod(2);
            effect.start(effectLocation, null);
        }
    }
}

