/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.batch.BlockAction;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class TargetingSpell
extends BaseSpell {
    private static final int MAX_RANGE = 511;
    private Target target = null;
    private String targetName = null;
    private TargetType targetType = TargetType.OTHER;
    private boolean targetNPCs = false;
    private int verticalSearchDistance = 8;
    private boolean targetingComplete = false;
    private boolean targetSpaceRequired = false;
    protected Class<? extends Entity> targetEntityType = null;
    private Location targetLocation;
    private Vector targetLocationOffset;
    private String targetLocationWorldName;
    protected Location targetLocation2;
    private Entity targetEntity = null;
    private boolean bypassBuildRestriction = false;
    private boolean allowMaxRange = false;
    private int range = 32;
    private Set<Material> targetThroughMaterials = new HashSet<Material>();
    private boolean reverseTargeting = false;
    private BlockIterator blockIterator = null;
    private Block currentBlock = null;
    private Block previousBlock = null;
    private Block previousPreviousBlock = null;
    private boolean pvpRestricted = false;
    private boolean bypassPvpRestriction = false;

    @Override
    protected void preCast() {
        super.preCast();
        this.initializeTargeting();
    }

    protected void initializeTargeting() {
        this.blockIterator = null;
        this.targetSpaceRequired = false;
        this.reverseTargeting = false;
        this.targetingComplete = false;
    }

    public void setTargetType(TargetType t) {
        this.targetType = t;
        if (this.target != null) {
            this.target = null;
            this.initializeTargeting();
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        String useTargetName = this.targetName;
        if (useTargetName == null) {
            useTargetName = this.target != null && this.target.hasEntity() ? this.controller.getEntityName(this.target.getEntity()) : "Unknown";
        }
        message = message.replace("$target", useTargetName);
        return message;
    }

    protected void setTargetName(String name) {
        this.targetName = name;
    }

    public void clearTargetThrough() {
        this.targetThroughMaterials.clear();
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.add(mat);
    }

    public void targetThrough(Set<Material> mat) {
        this.targetThroughMaterials.clear();
        this.targetThroughMaterials.addAll(mat);
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.remove(mat);
    }

    public boolean isTargetable(Material mat) {
        if (!this.allowPassThrough(mat)) {
            return true;
        }
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public void setTargetSpaceRequired() {
        this.targetSpaceRequired = true;
    }

    public void setTarget(Location location) {
        this.target = new Target(this.getLocation(), location.getBlock());
    }

    public boolean hasBuildPermission(Block block) {
        if (this.bypassBuildRestriction) {
            return true;
        }
        return this.mage.hasBuildPermission(block);
    }

    protected void offsetTarget(int dx, int dy, int dz) {
        Location location = this.getLocation();
        if (location == null) {
            return;
        }
        location.add((double)dx, (double)dy, (double)dz);
        this.initializeBlockIterator(location);
    }

    protected boolean initializeBlockIterator(Location location) {
        if (location.getBlockY() < 0) {
            location = location.clone();
            location.setY(0.0);
        }
        if (location.getBlockY() > this.controller.getMaxY()) {
            location = location.clone();
            location.setY((double)this.controller.getMaxY());
        }
        try {
            this.blockIterator = new BlockIterator(location, 1.65, this.getMaxRange());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected Block getNextBlock() {
        this.previousPreviousBlock = this.previousBlock;
        this.previousBlock = this.currentBlock;
        this.currentBlock = this.blockIterator == null || !this.blockIterator.hasNext() ? null : this.blockIterator.next();
        return this.currentBlock;
    }

    public Block getCurBlock() {
        return this.currentBlock;
    }

    public Block getPreviousBlock() {
        return this.previousBlock;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    protected Target getTarget() {
        Location location;
        this.target = this.findTarget();
        if (this.targetLocationOffset != null) {
            this.target.add(this.targetLocationOffset);
        }
        if (this.targetLocationWorldName != null && this.targetLocationWorldName.length() > 0 && (location = this.target.getLocation()) != null) {
            World targetWorld = location.getWorld();
            this.target.setWorld(ConfigurationUtils.overrideWorld(this.targetLocationWorldName, targetWorld, this.controller.canCreateWorlds()));
        }
        return this.target;
    }

    public Target findTarget() {
        boolean noPvp;
        if (this.targetType != TargetType.NONE && this.targetType != TargetType.BLOCK && this.targetEntity != null) {
            return new Target(this.getLocation(), this.targetEntity);
        }
        Player player = this.mage.getPlayer();
        if (this.targetType == TargetType.SELF && player != null) {
            return new Target(this.getLocation(), (Entity)player);
        }
        CommandSender sender = this.mage.getCommandSender();
        if (this.targetType == TargetType.SELF && player == null && sender != null && sender instanceof BlockCommandSender) {
            BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
            return new Target(commandBlock.getBlock().getLocation(), commandBlock.getBlock());
        }
        Location location = this.getLocation();
        if (this.targetType == TargetType.SELF && location != null) {
            return new Target(location, location.getBlock());
        }
        if (this.targetType == TargetType.SELF) {
            return new Target(location);
        }
        if (this.targetType != TargetType.NONE && this.targetLocation != null) {
            return new Target(this.getLocation(), this.targetLocation.getBlock());
        }
        if (this.targetType == TargetType.NONE) {
            return new Target(this.getLocation());
        }
        this.findTargetBlock();
        Block block = this.getCurBlock();
        if (this.targetType == TargetType.BLOCK) {
            return new Target(this.getLocation(), block);
        }
        Target targetBlock = block == null ? null : new Target(this.getLocation(), block);
        Target targetEntity = this.getEntityTarget();
        boolean bl = noPvp = targetEntity != null && targetEntity instanceof Player && this.pvpRestricted && !this.bypassPvpRestriction && !this.controller.isPVPAllowed(targetEntity.getLocation());
        if (noPvp) {
            targetEntity = null;
            targetBlock = null;
        }
        if (targetEntity == null && this.targetType == TargetType.ANY && player != null) {
            return new Target(this.getLocation(), (Entity)player, targetBlock == null ? null : targetBlock.getBlock());
        }
        if (targetBlock != null && targetEntity != null) {
            if (targetBlock.getDistance() < targetEntity.getDistance()) {
                targetEntity = null;
            } else {
                targetBlock = null;
            }
        }
        if (targetEntity != null) {
            return targetEntity;
        }
        if (targetBlock != null) {
            return targetBlock;
        }
        return new Target(this.getLocation());
    }

    public Target getCurrentTarget() {
        if (this.target == null) {
            this.target = new Target(this.getLocation());
        }
        return this.target;
    }

    public void clearTarget() {
        this.target = null;
    }

    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    protected Target getEntityTarget() {
        if (this.targetEntityType == null) {
            return null;
        }
        List<Target> scored = this.getAllTargetEntities();
        if (scored.size() <= 0) {
            return null;
        }
        return scored.get(0);
    }

    protected List<Target> getAllTargetEntities() {
        ArrayList<Target> scored = new ArrayList<Target>();
        World world = this.getWorld();
        if (world == null) {
            return scored;
        }
        List entities = world.getEntities();
        for (Entity entity : entities) {
            Target newScore;
            Mage targetMage;
            if (entity == this.mage.getEntity() || !this.targetNPCs && this.controller.isNPC(entity) || !this.controller.isElemental(entity) && this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || this.controller.isMage(entity) && (targetMage = this.controller.getMage(entity)).isSuperProtected() || entity instanceof LivingEntity && ((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY) || (newScore = new Target(this.getLocation(), entity, this.getMaxRange())).getScore() <= 0) continue;
            scored.add(newScore);
        }
        Collections.sort(scored);
        return scored;
    }

    protected int getMaxRange() {
        if (this.allowMaxRange) {
            return Math.min(511, this.range);
        }
        return Math.min(511, (int)(this.mage.getRangeMultiplier() * (float)this.range));
    }

    protected int getMaxRangeSquared() {
        int maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    protected void setMaxRange(int range) {
        this.range = range;
    }

    protected boolean isTransparent(Material material) {
        return this.targetThroughMaterials.contains(material);
    }

    protected void findTargetBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return;
        }
        if (this.targetingComplete) {
            return;
        }
        if (!this.initializeBlockIterator(location)) {
            return;
        }
        this.currentBlock = null;
        this.previousBlock = null;
        this.previousPreviousBlock = null;
        Block block = this.getNextBlock();
        while (block != null) {
            if (this.targetSpaceRequired ? this.isOkToStandIn(block.getType()) && this.isOkToStandIn(block.getRelative(BlockFace.UP).getType()) : this.isTargetable(block.getType())) break;
            block = this.getNextBlock();
        }
        if (block == null && this.allowMaxRange) {
            this.currentBlock = this.previousBlock;
            this.previousBlock = this.previousPreviousBlock;
        }
        this.targetingComplete = true;
    }

    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock.getType())) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    /*
     * Unable to fully structure code
     */
    public void coverSurface(Location center, int radius, BlockAction action) {
        y = center.getBlockY();
        dx = -radius;
        while (dx < radius) {
            dz = -radius;
            while (dz < radius) {
                block5: {
                    block6: {
                        if (!this.isInCircle(dx, dz, radius)) break block5;
                        x = center.getBlockX() + dx;
                        z = center.getBlockZ() + dz;
                        block = this.getWorld().getBlockAt(x, y, z);
                        depth = 0;
                        if (!this.targetThroughMaterials.contains(block.getType())) ** GOTO lbl19
                        while (depth < this.verticalSearchDistance && this.targetThroughMaterials.contains(block.getType())) {
                            ++depth;
                            block = block.getRelative(BlockFace.DOWN);
                        }
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            ++depth;
                            block = block.getRelative(BlockFace.UP);
lbl19:
                            // 2 sources

                            ** while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains((Object)block.getType()))
                        }
lbl20:
                        // 1 sources

                        block = block.getRelative(BlockFace.DOWN);
                    }
                    coveringBlock = block.getRelative(BlockFace.UP);
                    if (!this.targetThroughMaterials.contains(block.getType()) && this.targetThroughMaterials.contains(coveringBlock.getType())) {
                        action.perform(block);
                    }
                }
                ++dz;
            }
            ++dx;
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.target = null;
        this.targetName = null;
        this.targetLocation = null;
    }

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.range = parameters.getInt("range", this.range);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", this.allowMaxRange);
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
        if (parameters.contains("transparent")) {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet(parameters.getString("transparent")));
        } else {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet("transparent"));
        }
        if (parameters.contains("target")) {
            String targetTypeName = parameters.getString("target");
            try {
                this.targetType = TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid target_type: " + targetTypeName);
                this.targetType = TargetType.OTHER;
            }
        } else {
            this.targetType = TargetType.OTHER;
        }
        this.targetNPCs = parameters.getBoolean("target_npc", false);
        if (parameters.contains("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                Class<?> typeClass = Class.forName("org.bukkit.entity." + entityTypeName);
                if (Entity.class.isAssignableFrom(typeClass)) {
                    this.targetEntityType = typeClass;
                } else {
                    this.controller.getLogger().warning("Entity type: " + entityTypeName + " not assignable to Entity");
                }
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity type: " + entityTypeName);
                this.targetEntityType = null;
            }
        }
        Location defaultLocation = this.getLocation();
        this.targetLocation = ConfigurationUtils.overrideLocation(parameters, "t", defaultLocation, this.controller.canCreateWorlds());
        this.targetLocationOffset = null;
        Double otxValue = ConfigurationUtils.getDouble(parameters, "otx", null);
        Double otyValue = ConfigurationUtils.getDouble(parameters, "oty", null);
        Double otzValue = ConfigurationUtils.getDouble(parameters, "otz", null);
        if (otxValue != null || otzValue != null || otyValue != null) {
            this.targetLocationOffset = new Vector(otxValue == null ? 0.0 : otxValue, otyValue == null ? 0.0 : otyValue, otzValue == null ? 0.0 : otzValue);
        }
        this.targetLocationWorldName = parameters.getString("otworld");
        defaultLocation = this.targetLocation == null ? defaultLocation : this.targetLocation;
        this.targetLocation2 = ConfigurationUtils.overrideLocation(parameters, "t2", defaultLocation, this.controller.canCreateWorlds());
        if (parameters.contains("player")) {
            Player player = this.controller.getPlugin().getServer().getPlayer(parameters.getString("player"));
            if (player != null) {
                this.targetLocation = player.getLocation();
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        if (this.isUnderwater()) {
            this.targetThroughMaterials.add(Material.WATER);
            this.targetThroughMaterials.add(Material.STATIONARY_WATER);
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        this.pvpRestricted = node.getBoolean("pvp_restricted", this.pvpRestricted);
    }

    @Override
    protected String getDisplayMaterialName() {
        if (this.target != null && this.target.isValid()) {
            return MaterialBrush.getMaterialName(this.target.getBlock().getType(), this.target.getBlock().getData());
        }
        return super.getDisplayMaterialName();
    }

    @Override
    protected boolean canCast() {
        if (!super.canCast()) {
            return false;
        }
        return !this.pvpRestricted || this.bypassPvpRestriction || this.controller.isPVPAllowed(this.mage.getLocation()) || this.mage.isSuperPowered();
    }

    @Override
    protected void onBackfire() {
        this.targetType = TargetType.SELF;
    }

    @Override
    public Location getTargetLocation() {
        if (this.target != null && this.target.isValid()) {
            return this.target.getLocation();
        }
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        if (this.target != null && this.target.isValid()) {
            return this.target.getEntity();
        }
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        if (this.target != null && this.target.isValid()) {
            Block block = this.target.getBlock();
            com.elmakers.mine.bukkit.block.MaterialAndData targetMaterial = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
            if (targetMaterial.getMaterial() == Material.AIR) {
                targetMaterial.setMaterial(DEFAULT_EFFECT_MATERIAL);
            }
            return targetMaterial;
        }
        return super.getEffectMaterial();
    }
}

