/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.BlockList;
import com.elmakers.mine.bukkit.api.block.BoundingBox;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.WorldEditSchematic;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.elementals.ElementalsController;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.listener.AnvilController;
import com.elmakers.mine.bukkit.magic.listener.CraftingController;
import com.elmakers.mine.bukkit.magic.listener.EnchantingController;
import com.elmakers.mine.bukkit.metrics.CategoryCastPlotter;
import com.elmakers.mine.bukkit.metrics.DeltaPlotter;
import com.elmakers.mine.bukkit.metrics.SpellCastPlotter;
import com.elmakers.mine.bukkit.plugins.magic.mcstats.Metrics;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.utilities.CompleteDragTask;
import com.elmakers.mine.bukkit.utilities.DataStore;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.URLMap;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.warp.WarpController;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MagicController
implements Listener,
MageController {
    private static final int MAX_Y = 255;
    private static final String BUILTIN_SPELL_CLASSPATH = "com.elmakers.mine.bukkit.spell.builtin";
    private static int VOLUME_UPDATE_THRESHOLD = 32;
    private static int MAGE_FORGET_THRESHOLD = 30000;
    private final String SPELLS_FILE = "spells";
    private final String CONFIG_FILE = "config";
    private final String WANDS_FILE = "wands";
    private final String MESSAGES_FILE = "messages";
    private final String MATERIALS_FILE = "materials";
    private final String LOST_WANDS_FILE = "lostwands";
    private final String SPELLS_DATA_FILE = "spells";
    private final String AUTOMATA_FILE = "automata";
    private final String URL_MAPS_FILE = "imagemaps";
    private boolean loadDefaultSpells = true;
    private boolean loadDefaultWands = true;
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private Set<Material> buildingMaterials = new HashSet<Material>();
    private Set<Material> indestructibleMaterials = new HashSet<Material>();
    private Set<Material> restrictedMaterials = new HashSet<Material>();
    private Set<Material> destructibleMaterials = new HashSet<Material>();
    private Map<String, Set<Material>> materialSets = new HashMap<String, Set<Material>>();
    private int undoTimeWindow = 6000;
    private int undoBlockBorderSize = 2;
    private int maxTNTPerChunk = 0;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean commitOnQuit = false;
    private long playerDataThreshold = 0L;
    private WandMode defaultWandMode = WandMode.INVENTORY;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private boolean indestructibleWands = true;
    private boolean keepWandsOnDeath = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private int clickCooldown = 150;
    private boolean bindingEnabled = false;
    private boolean keepingEnabled = false;
    private boolean fillingEnabled = false;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapShowSpells = true;
    private boolean createWorldsEnabled = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 1.0f;
    private float castCommandCostReduction = 1.0f;
    private float castCommandCooldownReduction = 1.0f;
    private float castCommandPowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int maxBlockUpdates = 100;
    private int ageDroppedItems = 0;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private WarpController warpController = null;
    private final Map<String, SpellTemplate> spells = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellCategory> categories = new HashMap<String, SpellCategory>();
    private final Map<String, com.elmakers.mine.bukkit.api.magic.Mage> mages = new HashMap<String, com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Map<String, Long> forgetMages = new HashMap<String, Long>();
    private final Map<String, com.elmakers.mine.bukkit.api.magic.Mage> pendingConstruction = new HashMap<String, com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Set<String> pendingUndo = new HashSet<String>();
    private final Map<String, WeakReference<WorldEditSchematic>> schematics = new HashMap<String, WeakReference<WorldEditSchematic>>();
    private MagicPlugin plugin = null;
    private final File configFolder;
    private final File dataFolder;
    private final File schematicFolder;
    private final File defaultsFolder;
    private final File playerDataFolder;
    private boolean enableItemHacks = true;
    private int toggleCooldown = 1000;
    private int toggleMessageRange = 1024;
    private boolean bypassBuildPermissions = false;
    private boolean bypassPvpPermissions = false;
    private FactionsManager factionsManager = new FactionsManager();
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private TradersController tradersController = null;
    private String extraSchematicFilePath = null;
    private Class<?> cuboidClipboardClass = null;
    private DynmapController dynmap = null;
    private ElementalsController elementals = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;
    private PhysicsHandler physicsHandler = null;
    private Map<String, Map<Long, Automaton>> automata = new HashMap<String, Map<Long, Automaton>>();
    private Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();
    private int metricsLevel = 5;
    private Metrics metrics = null;
    private boolean hasDynmap = false;
    private boolean hasEssentials = false;
    private boolean hasEffectLib = false;
    private boolean hasCommandBook = false;
    private boolean hasWorldEdit = false;
    private CraftingController crafting = null;
    private EnchantingController enchanting = null;
    private AnvilController anvil = null;

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.schematicFolder = new File(this.configFolder, "schematics");
        this.schematicFolder.mkdirs();
        this.playerDataFolder = new File(this.dataFolder, "players");
        this.playerDataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName) {
        return this.getMage(mageId, mageName, null, null);
    }

    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, CommandSender commandSender, Entity entity) {
        return this.getMage(mageId, null, commandSender, entity);
    }

    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName, CommandSender commandSender, Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = null;
        if (!this.mages.containsKey(mageId)) {
            File playerFile;
            Mage mage = new Mage(mageId, this);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (commandSender instanceof Player) {
                mage.setPlayer((Player)commandSender);
            }
            if ((playerFile = new File(this.playerDataFolder, mageId + ".dat")).exists()) {
                this.getLogger().info("Loading mage data from file " + playerFile.getName());
                try {
                    YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
                    mage.load((ConfigurationSection)playerData);
                }
                catch (Exception ex) {
                    this.getLogger().warning("Failed to load mage data from file " + playerFile.getName());
                    ex.printStackTrace();
                }
            }
            this.mages.put(mageId, mage);
            apiMage = mage;
        } else {
            apiMage = this.mages.get(mageId);
            if (apiMage instanceof Mage) {
                Mage mage = (Mage)apiMage;
                mage.setName(mageName);
                mage.setCommandSender(commandSender);
                mage.setEntity(entity);
                if (commandSender instanceof Player) {
                    mage.setPlayer((Player)commandSender);
                }
            }
        }
        return apiMage;
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Player player) {
        return this.getMage((Entity)player, (CommandSender)player);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity) {
        Player commandSender = entity instanceof Player ? (Player)entity : null;
        return this.getMage(entity, (CommandSender)commandSender);
    }

    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity, CommandSender commandSender) {
        if (entity == null) {
            return this.getMage(commandSender);
        }
        String id = entity.getUniqueId().toString();
        if (this.isNPC(entity)) {
            id = "NPC-" + id;
        }
        return this.getMage(id, commandSender, entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(CommandSender commandSender) {
        String mageId = "COMMAND";
        if (commandSender instanceof ConsoleCommandSender) {
            mageId = "CONSOLE";
        } else {
            BlockCommandSender commandBlock;
            String commandName;
            if (commandSender instanceof Player) {
                return this.getMage((Player)commandSender);
            }
            if (commandSender instanceof BlockCommandSender && (commandName = (commandBlock = (BlockCommandSender)commandSender).getName()) != null && commandName.length() > 0) {
                mageId = "COMMAND-" + commandBlock.getName();
            }
        }
        return this.getMage(mageId, commandSender, null);
    }

    protected void loadMage(String playerId, ConfigurationSection node) {
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.getMage(playerId, null, null);
        try {
            if (mage instanceof Mage) {
                ((Mage)mage).load(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addSpell(Spell variant) {
        SpellTemplate conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell key: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
        }
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    @Override
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    public boolean bindWands() {
        return this.bindingEnabled;
    }

    public boolean keepWands() {
        return this.keepingEnabled;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.contains(block.getType());
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.contains(material);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        boolean allowed = true;
        if (this.bypassBuildPermissions) {
            return true;
        }
        allowed = allowed && this.worldGuardManager.hasBuildPermission(player, block);
        allowed = allowed && this.factionsManager.hasBuildPermission(player, block);
        return allowed;
    }

    public boolean schematicsEnabled() {
        return this.cuboidClipboardClass != null;
    }

    public void clearCache() {
        String[] schematicFiles;
        for (String schematicFilename : schematicFiles = this.schematicFolder.list()) {
            InputStream builtin;
            if (!schematicFilename.endsWith(".schematic") || (builtin = this.plugin.getResource("schematics/" + schematicFilename)) == null) continue;
            File schematicFile = new File(this.schematicFolder, schematicFilename);
            schematicFile.delete();
            this.plugin.getLogger().info("Deleted file " + schematicFile.getAbsolutePath());
        }
        this.schematics.clear();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).clearCache();
        }
    }

    @Override
    public WorldEditSchematic loadSchematic(String schematicName) {
        WorldEditSchematic cached;
        WeakReference<WorldEditSchematic> schematic;
        if (schematicName == null || schematicName.length() == 0 || !this.schematicsEnabled()) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic = this.schematics.get(schematicName)) != null && (cached = (WorldEditSchematic)schematic.get()) != null) {
            return cached;
        }
        String fileName = schematicName + ".schematic";
        File schematicFile = new File(this.schematicFolder, fileName);
        if (!schematicFile.exists()) {
            try {
                File extraSchematicFile = null;
                if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                    File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                    extraSchematicFile = new File(schematicFolder, schematicName + ".schematic");
                    this.getLogger().info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath());
                }
                if (extraSchematicFile != null && extraSchematicFile.exists()) {
                    schematicFile = extraSchematicFile;
                    this.getLogger().info("Loading file: " + extraSchematicFile.getAbsolutePath());
                } else {
                    this.plugin.saveResource("schematics/" + fileName, true);
                    this.getLogger().info("Adding builtin schematic: schematics/" + fileName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!schematicFile.exists()) {
            this.getLogger().warning("Could not load file: " + schematicFile.getAbsolutePath());
            return null;
        }
        try {
            Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
            this.getLogger().info("Loading schematic file: " + schematicFile.getAbsolutePath());
            WorldEditSchematic schematic2 = new WorldEditSchematic(loadSchematicMethod.invoke(null, schematicFile));
            this.schematics.put(schematicName, new WeakReference<WorldEditSchematic>(schematic2));
            return schematic2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Collection<String> getBrushKeys() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        String schematicName;
        ArrayList<String> schematicNames = new ArrayList<String>();
        if (!MaterialBrush.SchematicsEnabled) {
            return schematicNames;
        }
        try {
            CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL jar = codeSource.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.startsWith("schematics/") && name.endsWith(".schematic")) {
                        schematicName = name.replace(".schematic", "").replace("schematics/", "");
                        schematicNames.add(schematicName);
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic")) continue;
                    schematicName = schematicFile.getName().replace(".schematic", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        this.warpController = new WarpController();
        this.crafting = new CraftingController(this);
        this.enchanting = new EnchantingController(this);
        this.anvil = new AnvilController(this);
        Plugin effectLib = this.plugin.getServer().getPluginManager().getPlugin("EffectLib");
        this.hasEffectLib = false;
        if (effectLib != null) {
            try {
                Class<?> effectManagerClass = Class.forName("de.slikey.effectlib.EffectManager");
                Constructor<?> managerConstructor = effectManagerClass.getConstructor(effectLib.getClass());
                Object effectManager = managerConstructor.newInstance(effectLib);
                this.hasEffectLib = EffectPlayer.setEffectManager(effectManager);
            }
            catch (Exception ex) {
                this.getLogger().warning("Found EffectLib, but encountered an error integrating: " + ex.getMessage());
                this.hasEffectLib = false;
            }
        }
        if (this.hasEffectLib) {
            this.getLogger().info("EffectLib found, will be used for effects");
        } else {
            this.getLogger().info("EffectLib not found, install it for better effects");
        }
        this.load();
        Plugin essentials = this.plugin.getServer().getPluginManager().getPlugin("Essentials");
        boolean bl = this.hasEssentials = essentials != null;
        if (this.hasEssentials) {
            if (this.warpController.setEssentials((Plugin)this.plugin)) {
                this.getLogger().info("Integrating with Essentials for Recall warps");
            }
            try {
                this.mailer = new Mailer(essentials);
            }
            catch (Exception ex) {
                this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                this.mailer = null;
            }
        }
        if (this.essentialsSignsEnabled) {
            final MagicController me = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                        if (essentials != null) {
                            Class<?> essentialsClass = essentials.getClass();
                            Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                            itemDbField.setAccessible(true);
                            Object oldEntry = itemDbField.get(essentials);
                            if (oldEntry instanceof MagicItemDb) {
                                MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                return;
                            }
                            if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                return;
                            }
                            MagicItemDb newEntry = new MagicItemDb(me, essentials);
                            itemDbField.set(essentials, (Object)newEntry);
                            Field confListField = essentialsClass.getDeclaredField("confList");
                            confListField.setAccessible(true);
                            List confList = (List)confListField.get(essentials);
                            confList.remove(oldEntry);
                            confList.add(newEntry);
                            MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }, 5L);
        }
        this.tradersController = null;
        try {
            Plugin tradersPlugin = this.plugin.getServer().getPluginManager().getPlugin("dtlTraders");
            if (tradersPlugin != null) {
                this.tradersController = new TradersController();
                this.tradersController.initialize(this, tradersPlugin);
                this.getLogger().info("dtlTraders found, integrating for selling Wands, Spells, Brushes and Upgrades");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.tradersController = null;
        }
        if (this.tradersController == null) {
            this.getLogger().info("dtlTraders not found, will not integrate.");
        }
        try {
            this.cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard");
            Method loadSchematicMethod = this.cuboidClipboardClass.getMethod("loadSchematic", File.class);
            if (loadSchematicMethod != null) {
                this.getLogger().info("WorldEdit found, schematic brushes enabled.");
                MaterialBrush.SchematicsEnabled = true;
                this.hasWorldEdit = true;
            } else {
                this.cuboidClipboardClass = null;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.hasCommandBook = false;
        try {
            Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
            if (commandBookPlugin != null) {
                if (this.warpController.setCommandBook(commandBookPlugin)) {
                    this.getLogger().info("CommandBook found, integrating for Recall warps");
                    this.hasCommandBook = true;
                } else {
                    this.getLogger().warning("CommandBook integration failed");
                }
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (this.cuboidClipboardClass == null) {
            this.getLogger().info("WorldEdit not found, schematic brushes will not work.");
            MaterialBrush.SchematicsEnabled = false;
            this.hasWorldEdit = false;
        }
        this.factionsManager.initialize((Plugin)this.plugin);
        this.worldGuardManager.initialize((Plugin)this.plugin);
        try {
            Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
            this.dynmap = dynmapPlugin != null ? new DynmapController((Plugin)this.plugin, dynmapPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.dynmap == null) {
            this.getLogger().info("dynmap not found, not integrating.");
        } else {
            this.getLogger().info("dynmap found, integrating.");
        }
        try {
            Plugin elementalsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Splateds_Elementals");
            this.elementals = elementalsPlugin != null ? new ElementalsController(elementalsPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.elementals != null) {
            this.getLogger().info("Elementals found, integrating.");
        }
        this.activateMetrics();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                long threshold = System.currentTimeMillis() - (long)MAGE_FORGET_THRESHOLD;
                for (Map.Entry mageEntry : MagicController.this.forgetMages.entrySet()) {
                    if ((Long)mageEntry.getValue() >= threshold) continue;
                    MagicController.this.mages.remove(mageEntry.getKey());
                }
                MagicController.this.forgetMages.clear();
                for (com.elmakers.mine.bukkit.api.magic.Mage mage : MagicController.this.mages.values()) {
                    if (!(mage instanceof Mage)) continue;
                    ((Mage)mage).tick();
                }
            }
        }, 0L, 20L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ArrayList pending = new ArrayList();
                pending.addAll(MagicController.this.pendingConstruction.values());
                for (com.elmakers.mine.bukkit.api.magic.Mage mage : pending) {
                    if (!(mage instanceof Mage)) continue;
                    ((Mage)mage).processPendingBatches(MagicController.this.maxBlockUpdates);
                }
            }
        }, 0L, 1L);
        this.registerListeners();
    }

    protected void activateMetrics() {
        final MagicController controller = this;
        this.metrics = null;
        if (this.metricsLevel > 0) {
            try {
                this.metrics = new Metrics((Plugin)this.plugin);
                if (this.metricsLevel > 1) {
                    Metrics.Graph integrationGraph = this.metrics.createGraph("Plugin Integration");
                    integrationGraph.addPlotter(new Metrics.Plotter("EffectLib"){

                        @Override
                        public int getValue() {
                            return controller.hasEffectLib ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Essentials"){

                        @Override
                        public int getValue() {
                            return controller.hasEssentials ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("WorldEdit"){

                        @Override
                        public int getValue() {
                            return controller.hasWorldEdit ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Dynmap"){

                        @Override
                        public int getValue() {
                            return controller.hasDynmap ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Factions"){

                        @Override
                        public int getValue() {
                            return controller.factionsManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("WorldGuard"){

                        @Override
                        public int getValue() {
                            return controller.worldGuardManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Elementals"){

                        @Override
                        public int getValue() {
                            return controller.elementalsEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Traders"){

                        @Override
                        public int getValue() {
                            return controller.tradersController != null ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("CommandBook"){

                        @Override
                        public int getValue() {
                            return controller.hasCommandBook ? 1 : 0;
                        }
                    });
                    Metrics.Graph featuresGraph = this.metrics.createGraph("Features Enabled");
                    featuresGraph.addPlotter(new Metrics.Plotter("Crafting"){

                        @Override
                        public int getValue() {
                            return controller.crafting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Enchanting"){

                        @Override
                        public int getValue() {
                            return controller.enchanting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Combining"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isCombiningEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Organizing"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isOrganizingEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Binding"){

                        @Override
                        public int getValue() {
                            return controller.bindingEnabled ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Keeping"){

                        @Override
                        public int getValue() {
                            return controller.keepingEnabled ? 1 : 0;
                        }
                    });
                }
                if (this.metricsLevel > 2) {
                    Metrics.Graph categoryGraph = this.metrics.createGraph("Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        categoryGraph.addPlotter(new DeltaPlotter(new CategoryCastPlotter(category)));
                    }
                    Metrics.Graph totalCategoryGraph = this.metrics.createGraph("Total Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        totalCategoryGraph.addPlotter(new CategoryCastPlotter(category));
                    }
                }
                if (this.metricsLevel > 3) {
                    Metrics.Graph spellGraph = this.metrics.createGraph("Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        spellGraph.addPlotter(new DeltaPlotter(new SpellCastPlotter((Spell)spell)));
                    }
                    Metrics.Graph totalCastGraph = this.metrics.createGraph("Total Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        totalCastGraph.addPlotter(new SpellCastPlotter((Spell)spell));
                    }
                }
                this.metrics.start();
                this.plugin.getLogger().info("Activated MCStats");
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to load MCStats: " + ex.getMessage());
            }
        }
    }

    protected void registerListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.crafting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.enchanting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.anvil, (Plugin)this.plugin);
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getPending() {
        return this.pendingConstruction.values();
    }

    protected void addPending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.put(mage.getName(), mage);
    }

    protected void removePending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.remove(mage.getName());
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            created = this.dynmap.addMarker(id, group, title, world, x, y, z, description);
        }
        return created;
    }

    protected File getDataFile(String fileName) {
        return new File(this.dataFolder, fileName + ".yml");
    }

    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected DataStore createDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        DataStore configuration = new DataStore(this.getLogger(), dataFile);
        return configuration;
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults) {
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.getLogger().info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        this.plugin.saveResource(defaultsFileName, true);
        this.getLogger().info("Loading " + configFile.getName());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!loadDefaults) {
            return config;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((InputStream)this.plugin.getResource(defaultsFileName));
        ConfigurationUtils.addConfigurations((ConfigurationSection)defaultConfig, (ConfigurationSection)config);
        return defaultConfig;
    }

    public void loadConfiguration() {
        this.schematics.clear();
        try {
            this.loadProperties(this.loadConfigFile("config", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Messages.reset();
            Messages.load(this.loadConfigFile("messages", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadMaterials(this.loadConfigFile("materials", true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadSpells(this.loadConfigFile("spells", this.loadDefaultSpells));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Wand.loadTemplates(this.loadConfigFile("wands", this.loadDefaultWands));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Magic: Loaded " + this.spells.size() + " spells and " + Wand.getWandTemplates().size() + " wands");
    }

    protected void loadSpellData() {
        try {
            ConfigurationSection configNode = this.loadDataFile("spells");
            if (configNode == null) {
                return;
            }
            Set keys = configNode.getKeys(false);
            for (String key : keys) {
                SpellTemplate spell = this.getSpellTemplate(key);
                if (spell == null || !(spell instanceof MageSpell)) continue;
                ConfigurationSection spellSection = configNode.getConfigurationSection(key);
                ((MageSpell)spell).load(spellSection);
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to load spell metrics");
        }
    }

    public void load() {
        this.loadConfiguration();
        this.loadSpellData();
        File[] playerFiles = this.playerDataFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".dat");
            }
        });
        this.getLogger().info("Scanning " + playerFiles.length + " save files for pending undo info. Adjust player_data_expire_threshold if this is taking a long time.");
        for (File playerFile : playerFiles) {
            YamlConfiguration playerData;
            if (this.playerDataThreshold > 0L && playerFile.lastModified() < System.currentTimeMillis() - this.playerDataThreshold || !(playerData = YamlConfiguration.loadConfiguration((File)playerFile)).contains("scheduled") || playerData.getList("scheduled").size() <= 0) continue;
            String playerId = playerFile.getName().replaceFirst("[.][^.]+$", "");
            this.loadMage(playerId, (ConfigurationSection)playerData);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                MagicController.this.getLogger().info("Loading lost wand data");
                MagicController.this.loadLostWands();
                MagicController.this.getLogger().info("Loading automata data");
                MagicController.this.loadAutomata();
                try {
                    URLMap.resetAll();
                    File urlMapFile = MagicController.this.getDataFile("imagemaps");
                    File imageCache = new File(MagicController.this.dataFolder, "imagemapcache");
                    imageCache.mkdirs();
                    URLMap.load((Plugin)MagicController.this.plugin, urlMapFile, imageCache);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MagicController.this.getLogger().info("Finished loading data.");
            }
        }, 10L);
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile("lostwands");
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    if (wandId == null || wandId.length() == 0) continue;
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.lostWands.size() + " lost wands");
    }

    protected void saveSpellData() {
        String lastKey = "";
        try {
            DataStore spellsDataFile = this.createDataFile("spells");
            for (SpellTemplate spell : this.spells.values()) {
                lastKey = spell.getKey();
                ConfigurationSection spellNode = spellsDataFile.createSection(lastKey);
                if (spellNode == null) {
                    this.getLogger().warning("Error saving spell data for " + lastKey);
                    continue;
                }
                if (spell == null || !(spell instanceof MageSpell)) continue;
                ((MageSpell)spell).save(spellNode);
            }
            spellsDataFile.save();
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving spell data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void saveLostWands() {
        String lastKey = "";
        try {
            DataStore lostWandsConfiguration = this.createDataFile("lostwands");
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                if (lastKey == null || lastKey.length() == 0) continue;
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey);
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey);
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            lostWandsConfiguration.save();
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void loadAutomata() {
        int automataCount = 0;
        try {
            ConfigurationSection toggleBlockData = this.loadDataFile("automata");
            if (toggleBlockData != null) {
                Set chunkIds = toggleBlockData.getKeys(false);
                for (String chunkId : chunkIds) {
                    ConfigurationSection chunkNode = toggleBlockData.getConfigurationSection(chunkId);
                    HashMap<Long, Automaton> restoreChunk = new HashMap<Long, Automaton>();
                    this.automata.put(chunkId, restoreChunk);
                    Set blockIds = chunkNode.getKeys(false);
                    for (String blockId : blockIds) {
                        ConfigurationSection toggleConfig = chunkNode.getConfigurationSection(blockId);
                        Automaton toggle = new Automaton(toggleConfig);
                        restoreChunk.put(toggle.getId(), toggle);
                        ++automataCount;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + automataCount + " automata");
    }

    protected void saveAutomata() {
        try {
            DataStore automataData = this.createDataFile("automata");
            for (Map.Entry<String, Map<Long, Automaton>> toggleEntry : this.automata.entrySet()) {
                Collection<Automaton> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                ConfigurationSection chunkNode = automataData.createSection(toggleEntry.getKey());
                for (Automaton block : blocks) {
                    ConfigurationSection node = chunkNode.createSection(Long.toString(block.getId()));
                    block.save(node);
                }
            }
            automataData.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    public boolean addLostWand(LostWand lostWand) {
        this.lostWands.put(lostWand.getId(), lostWand);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands == null) {
            chunkWands = new HashSet<String>();
            this.lostWandChunks.put(chunkKey, chunkWands);
        }
        chunkWands.add(lostWand.getId());
        if (this.dynmapShowWands) {
            this.addLostWandMarker(lostWand);
        }
        return true;
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        this.addLostWand(wand.makeLost(dropLocation));
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (wandId == null || wandId.length() == 0 || !this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation().getChunk());
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "Wands")) {
            this.getLogger().info("Wand removed from map");
        }
        return true;
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    protected void savePlayerData() {
        try {
            for (Map.Entry<String, com.elmakers.mine.bukkit.api.magic.Mage> mageEntry : this.mages.entrySet()) {
                com.elmakers.mine.bukkit.block.UndoQueue undoQueue;
                boolean isDeadEntity;
                File playerData = new File(this.playerDataFolder, mageEntry.getKey() + ".dat");
                DataStore playerConfig = new DataStore(this.getLogger(), playerData);
                com.elmakers.mine.bukkit.api.magic.Mage mage = mageEntry.getValue();
                if (mage instanceof Mage) {
                    ((Mage)mage).save((ConfigurationSection)playerConfig);
                }
                playerConfig.save();
                Player player = mage.getPlayer();
                LivingEntity livingEntity = mage.getLivingEntity();
                boolean isOfflinePlayer = player != null && !player.isOnline() && !this.isNPC((Entity)player);
                boolean bl = isDeadEntity = livingEntity != null && livingEntity.isDead() && player == null;
                if (!isOfflinePlayer && !isDeadEntity) continue;
                com.elmakers.mine.bukkit.block.UndoQueue undoQueue2 = undoQueue = mage instanceof Mage ? ((Mage)mage).getUndoQueue() : null;
                if (undoQueue != null && !undoQueue.isEmpty()) continue;
                this.getLogger().info("Offline mage " + mage.getName() + " has no pending undo actions, forgetting");
                this.forgetMages.put(mageEntry.getKey(), 0L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String forgetId : this.forgetMages.keySet()) {
            this.mages.remove(forgetId);
        }
        this.forgetMages.clear();
    }

    public void save() {
        this.getLogger().info("Saving player data");
        this.savePlayerData();
        this.getLogger().info("Saving spell data");
        this.saveSpellData();
        this.getLogger().info("Saving lost wands data");
        this.saveLostWands();
        this.getLogger().info("Saving image map data");
        URLMap.save();
        this.getLogger().info("Saving automata data");
        this.saveAutomata();
    }

    protected void loadSpells(ConfigurationSection config) {
        if (config == null) {
            return;
        }
        this.spells.clear();
        Set spellKeys = config.getKeys(false);
        for (String key : spellKeys) {
            ConfigurationSection spellNode = config.getConfigurationSection(key);
            if (!spellNode.getBoolean("enabled", true)) continue;
            Spell newSpell = MagicController.loadSpell(key, spellNode, this);
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).loadSpells(config);
        }
    }

    public static Spell loadSpell(String name, ConfigurationSection node, MageController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            ex.printStackTrace();
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            ex.printStackTrace();
            return null;
        }
        if (newObject == null || !(newObject instanceof MageSpell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it implement MageSpell?");
            return null;
        }
        MageSpell newSpell = (MageSpell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        com.elmakers.mine.bukkit.api.spell.SpellCategory category = newSpell.getCategory();
        if (category instanceof SpellCategory) {
            ((SpellCategory)category).addSpellTemplate(newSpell);
        }
        return newSpell;
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            this.materialSets.put(key, ConfigurationUtils.getMaterials(materialNode, key));
        }
        if (this.materialSets.containsKey("building")) {
            this.buildingMaterials = this.materialSets.get("building");
        }
        if (this.materialSets.containsKey("indestructible")) {
            this.indestructibleMaterials = this.materialSets.get("indestructible");
        }
        if (this.materialSets.containsKey("restricted")) {
            this.restrictedMaterials = this.materialSets.get("restricted");
        }
        if (this.materialSets.containsKey("destructible")) {
            this.destructibleMaterials = this.materialSets.get("destructible");
        }
    }

    protected void loadProperties(ConfigurationSection properties) {
        if (properties == null) {
            return;
        }
        if (this.autoSaveTaskId > 0) {
            Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = 0;
        }
        this.loadDefaultSpells = properties.getBoolean("load_default_spells", this.loadDefaultSpells);
        this.loadDefaultWands = properties.getBoolean("load_default_wands", this.loadDefaultWands);
        this.maxTNTPerChunk = properties.getInt("max_tnt_per_chunk", this.maxTNTPerChunk);
        this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
        this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
        this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
        this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
        this.playerDataThreshold = (long)(properties.getDouble("player_data_expire_threshold", 0.0) * 1000.0 * 24.0 * 3600.0);
        this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
        this.showMessages = properties.getBoolean("show_messages", this.showMessages);
        this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
        this.clickCooldown = properties.getInt("click_cooldown", this.clickCooldown);
        this.messageThrottle = properties.getInt("message_throttle", 0);
        this.maxBlockUpdates = properties.getInt("max_block_updates", this.maxBlockUpdates);
        this.ageDroppedItems = properties.getInt("age_dropped_items", this.ageDroppedItems);
        this.enableItemHacks = properties.getBoolean("enable_custom_item_hacks", this.enableItemHacks);
        this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
        this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
        this.indestructibleWands = properties.getBoolean("indestructible_wands", this.indestructibleWands);
        this.keepWandsOnDeath = properties.getBoolean("keep_wands_on_death", this.keepWandsOnDeath);
        this.welcomeWand = properties.getString("welcome_wand", "");
        this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
        this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
        this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
        this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
        this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
        this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
        this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
        this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
        this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.castCommandCostReduction = (float)properties.getDouble("cast_command_cost_reduction", (double)this.castCommandCostReduction);
        this.castCommandCooldownReduction = (float)properties.getDouble("cast_command_cooldown_reduction", (double)this.castCommandCooldownReduction);
        this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
        this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
        this.bindingEnabled = properties.getBoolean("enable_binding", this.bindingEnabled);
        this.keepingEnabled = properties.getBoolean("enable_keeping", this.keepingEnabled);
        this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
        this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
        this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
        this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
        this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
        this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
        this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
        this.createWorldsEnabled = properties.getBoolean("enable_world_creation", this.createWorldsEnabled);
        this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
        this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
        this.messagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagePrefix);
        this.castMessagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.castMessagePrefix);
        this.worldGuardManager.setEnabled(properties.getBoolean("region_manager_enabled", this.factionsManager.isEnabled()));
        this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
        this.metricsLevel = properties.getInt("metrics_level", this.metricsLevel);
        if (properties.contains("mana_display")) {
            Wand.retainLevelDisplay = properties.getString("mana_display").equals("hybrid");
            Wand.displayManaAsBar = !properties.getString("mana_display").equals("number");
        }
        Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
        Wand.EnableGlow = properties.getBoolean("enable_glow", Wand.EnableGlow);
        MaterialBrush.CopyMaterial = ConfigurationUtils.getMaterial(properties, "copy_item", MaterialBrush.CopyMaterial);
        MaterialBrush.EraseMaterial = ConfigurationUtils.getMaterial(properties, "erase_item", MaterialBrush.EraseMaterial);
        MaterialBrush.CloneMaterial = ConfigurationUtils.getMaterial(properties, "clone_item", MaterialBrush.CloneMaterial);
        MaterialBrush.ReplicateMaterial = ConfigurationUtils.getMaterial(properties, "replicate_item", MaterialBrush.ReplicateMaterial);
        MaterialBrush.SchematicMaterial = ConfigurationUtils.getMaterial(properties, "schematic_item", MaterialBrush.SchematicMaterial);
        MaterialBrush.MapMaterial = ConfigurationUtils.getMaterial(properties, "map_item", MaterialBrush.MapMaterial);
        EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
        final MagicController saveController = this;
        int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
        if (autoSaveIntervalTicks > 1) {
            this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    saveController.getLogger().info("Auto-saving Magic data");
                    saveController.save();
                    saveController.getLogger().info("... Done auto-saving.");
                }
            }, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
        }
        WandLevel.load(properties);
        this.crafting.load(properties);
        this.enchanting.load(properties);
        this.anvil.load(properties);
    }

    protected void clear() {
        this.mages.clear();
        this.pendingConstruction.clear();
        this.spells.clear();
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    protected void registerForUndo(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingUndo.add(mage.getId());
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet;
        String parentNode;
        boolean isParentSet;
        if (player == null) {
            return true;
        }
        if (pNode.contains(".") && (isParentSet = player.isPermissionSet(parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*"))) {
            defaultValue = player.hasPermission(parentNode);
        }
        return (isSet = player.isPermissionSet(pNode)) ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            if (event.getEntity().hasMetadata("MagicBlockList")) {
                List values = entity.getMetadata("MagicBlockList");
                for (MetadataValue value : values) {
                    if (value.getOwningPlugin() != this.plugin) continue;
                    UndoList blockList = (UndoList)value.value();
                    blockList.convert(entity, event.getBlock());
                }
            } else {
                this.registerFallingBlock(entity, event.getBlock());
            }
        }
    }

    protected void registerFallingBlock(Entity fallingBlock, Block block) {
        long now = System.currentTimeMillis();
        ArrayList<String> keys = new ArrayList<String>(this.pendingUndo);
        for (String key : keys) {
            if (this.mages.containsKey(key)) {
                com.elmakers.mine.bukkit.api.magic.Mage mage = this.mages.get(key);
                if (!(mage instanceof Mage)) continue;
                UndoList lastUndo = ((Mage)mage).getLastUndoList();
                if (lastUndo == null || lastUndo.getModifiedTime() < now - (long)this.undoTimeWindow) {
                    this.pendingUndo.remove(key);
                    continue;
                }
                if (!lastUndo.contains(fallingBlock.getLocation(), this.undoBlockBorderSize)) continue;
                lastUndo.fall(fallingBlock, block);
                continue;
            }
            this.pendingUndo.remove(key);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.enableItemHacks || event.isCancelled()) {
            return;
        }
        ItemStack oldStack = event.getOldCursor();
        HumanEntity entity = event.getWhoClicked();
        if (oldStack != null && oldStack.hasItemMeta() && entity instanceof Player) {
            Map draggedSlots = event.getNewItems();
            if (draggedSlots.size() != 1) {
                return;
            }
            event.setCancelled(true);
            InventoryView view = event.getView();
            for (Integer dslot : draggedSlots.keySet()) {
                CompleteDragTask completeDrag = new CompleteDragTask((Player)entity, view, dslot);
                completeDrag.runTaskLater((Plugin)this.plugin, 1L);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        Entity damager = event.getDamager();
        UndoList undoList = this.getEntityUndo(damager);
        if (undoList != null) {
            undoList.modify(entity);
        }
    }

    protected UndoList getEntityUndo(Entity entity) {
        UndoList blockList = null;
        if (entity == null) {
            return null;
        }
        if (this.isMage(entity)) {
            UndoList lastUndo;
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.getMage(entity);
            if (mage instanceof Mage && (lastUndo = ((Mage)mage).getLastUndoList()) instanceof UndoList) {
                blockList = lastUndo;
            }
        } else if (entity.hasMetadata("MagicBlockList")) {
            List values = entity.getMetadata("MagicBlockList");
            for (MetadataValue value : values) {
                if (value.getOwningPlugin() != this.plugin) continue;
                blockList = (UndoList)value.value();
            }
        }
        return blockList;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        UndoList blockList = this.getEntityUndo(explodingEntity);
        if (event.isCancelled()) {
            if (blockList != null) {
                blockList.cancelExplosion(explodingEntity);
            }
        } else if (this.maxTNTPerChunk > 0 && explodingEntity.getType() == EntityType.PRIMED_TNT) {
            Entity[] entities;
            Chunk chunk = explodingEntity.getLocation().getChunk();
            if (chunk == null || !chunk.isLoaded()) {
                return;
            }
            int tntCount = 0;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity == null || entity.getType() != EntityType.PRIMED_TNT) continue;
                ++tntCount;
            }
            if (tntCount > this.maxTNTPerChunk) {
                event.setCancelled(true);
                if (blockList != null) {
                    blockList.cancelExplosion(explodingEntity);
                }
            } else if (blockList != null) {
                blockList.explode(explodingEntity, event.blockList());
            }
        } else if (blockList != null) {
            blockList.explode(explodingEntity, event.blockList());
        }
    }

    protected void onPlayerActivateIcon(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand activeWand, ItemStack icon) {
        if (icon != null && icon.getType() != Material.AIR) {
            Spell spell = mage.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                activeWand.saveInventory();
                activeWand.setActiveSpell(spell.getKey());
                mage.getPlayer().setItemInHand(activeWand.getItem());
            } else if (Wand.isBrush(icon)) {
                activeWand.saveInventory();
                activeWand.activateBrush(icon);
                mage.getPlayer().setItemInHand(activeWand.getItem());
            }
        } else {
            activeWand.setActiveSpell("");
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null && Wand.isWand(previous)) {
            if (activeWand.isInventoryOpen()) {
                this.onPlayerActivateIcon(mage, activeWand, next);
                event.setCancelled(true);
                return;
            }
            activeWand.deactivate();
        }
        if (next != null && Wand.isWand(next)) {
            Wand newWand = new Wand(this, next);
            newWand.activate(mage, next);
        }
        if ((activeWand = mage.getActiveWand()) == null && next != null && next.getType() == Material.MAP) {
            mage.setLastHeldMapId(next.getDurability());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null) {
            ItemStack droppedItem = event.getItemDrop().getItemStack();
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(droppedItem) && (inHand == null || inHand.getType() == Material.AIR)) {
                activeWand.deactivate();
                if (Wand.hasActiveWand(player)) {
                    player.setItemInHand(new ItemStack(Material.AIR, 1));
                }
            } else if (activeWand.isInventoryOpen()) {
                this.removeItemFromWand(activeWand, droppedItem);
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!this.isMage((Entity)entity)) {
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage((Entity)entity);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.onPlayerDeath(event);
        if (!(entity instanceof Player)) {
            return;
        }
        final Player player = (Player)entity;
        String rule = entity.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] armor;
                drops.clear();
                ItemStack[] stored = mage.getStoredInventory().getContents();
                wand.deactivate();
                for (ItemStack stack : stored) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
                for (ItemStack stack : armor = player.getInventory().getArmorContents()) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            } else {
                wand.deactivate();
            }
        }
        ArrayList oldDrops = new ArrayList(drops);
        final ArrayList<ItemStack> keepWands = new ArrayList<ItemStack>();
        drops.clear();
        for (ItemStack itemStack : oldDrops) {
            boolean keepItem = false;
            if (Wand.isWand(itemStack) && !(keepItem = this.keepWandsOnDeath)) {
                Wand testWand = new Wand(this, itemStack);
                keepItem = testWand.keepOnDeath();
            }
            if (keepItem) {
                keepWands.add(itemStack);
                continue;
            }
            drops.add(itemStack);
        }
        if (keepWands.size() > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    for (ItemStack itemStack : keepWands) {
                        player.getInventory().addItem(new ItemStack[]{itemStack});
                    }
                }
            }, 5L);
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        if (this.isMage(entity)) {
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getEntity());
            if (!(apiMage instanceof Mage)) {
                return;
            }
            Mage mage = (Mage)apiMage;
            mage.onPlayerCombust(event);
        }
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, event.getEntity().getItemStack());
            if (wand.isIndestructible()) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else if (this.dynmapShowWands) {
                this.removeLostWand(wand.getLostId());
            }
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this, event.getEntity().getItemStack());
            if (wand.isIndestructible()) {
                InventoryUtils.setInvulnerable((Entity)event.getEntity());
                this.addLostWand(wand, event.getEntity().getLocation());
                Location dropLocation = event.getLocation();
                this.getLogger().info("Wand " + wand.getName() + ", id " + wand.getLostId() + " spawned at " + dropLocation.getBlockX() + " " + dropLocation.getBlockY() + " " + dropLocation.getBlockZ());
            }
        } else {
            this.registerEntityForUndo((Entity)event.getEntity());
            if (this.ageDroppedItems > 0) {
                int ticks = this.ageDroppedItems * 20 / 1000;
                Item item = event.getEntity();
                this.ageItem(item, ticks);
            }
        }
    }

    protected void registerEntityForUndo(Entity entity) {
        long now = System.currentTimeMillis();
        ArrayList<String> keys = new ArrayList<String>(this.pendingUndo);
        for (String key : keys) {
            if (this.mages.containsKey(key)) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.mages.get(key);
                if (!(apiMage instanceof Mage)) continue;
                Mage mage = (Mage)apiMage;
                UndoList lastUndo = mage.getLastUndoList();
                if (lastUndo == null || lastUndo.getModifiedTime() < now - (long)this.undoTimeWindow) {
                    this.pendingUndo.remove(key);
                    continue;
                }
                if (!lastUndo.contains(entity.getLocation(), this.undoBlockBorderSize)) continue;
                lastUndo.add(entity);
                continue;
            }
            this.pendingUndo.remove(key);
        }
    }

    protected void ageItem(Item item, int ticksToAge) {
        try {
            Class<?> itemClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityItem");
            Object handle = NMSUtils.getHandle((Entity)item);
            Field ageField = itemClass.getDeclaredField("age");
            ageField.setAccessible(true);
            ageField.set(handle, ticksToAge);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            Item item;
            ItemStack itemStack;
            Entity entity = event.getEntity();
            if (this.isMage(entity)) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getEntity());
                if (!(apiMage instanceof Mage)) {
                    return;
                }
                Mage mage = (Mage)apiMage;
                mage.onPlayerDamage(event);
            }
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                Wand wand = new Wand(this, item.getItemStack());
                if (wand.isIndestructible()) {
                    event.setCancelled(true);
                } else if (event.getDamage() >= (double)itemStack.getDurability() && this.removeLostWand(wand.getLostId())) {
                    this.plugin.getLogger().info("Wand " + wand.getName() + ", id " + wand.getLostId() + " destroyed");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.isNPC(event.getRightClicked())) {
            Player player = event.getPlayer();
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(event.getPlayer());
            if (!(apiMage instanceof Mage)) {
                return;
            }
            Mage mage = (Mage)apiMage;
            Wand wand = mage.getActiveWand();
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        Wand wand = mage.getActiveWand();
        if (wand == null && Wand.hasActiveWand(player)) {
            if (mage.hasStoredInventory()) {
                mage.restoreInventory();
            }
            wand = Wand.getActiveWand(this, player);
            wand.activate(mage);
            this.getLogger().warning("Player was holding an inactive wand on interact- activating.");
        }
        if (wand == null && mage.hasStoredInventory()) {
            this.getLogger().warning("Player had no active wand, but a stored inventory- restoring.");
            mage.restoreInventory();
            return;
        }
        if (wand == null) {
            return;
        }
        if (!this.hasWandPermission(player)) {
            if (this.hasPermission(player, "Magic.wand.destruct", false)) {
                wand.deactivate();
                PlayerInventory inventory = player.getInventory();
                ItemStack[] items = inventory.getContents();
                for (int i = 0; i < items.length; ++i) {
                    ItemStack item = items[i];
                    if (!Wand.isWand(item) && !Wand.isSpell(item) && !Wand.isBrush(item)) continue;
                    items[i] = null;
                }
                inventory.setContents(items);
                mage.sendMessage(Messages.get("wand.self_destruct"));
            }
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK && !wand.isUpgrade()) {
            wand.cast();
            event.setCancelled(true);
            return;
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl2 = toggleInventory = material != Material.CHEST && material != Material.WOODEN_DOOR && material != Material.IRON_DOOR_BLOCK && material != Material.ENDER_CHEST && material != Material.ANVIL && material != Material.BREWING_STAND && material != Material.ENCHANTMENT_TABLE && material != Material.STONE_BUTTON && material != Material.LEVER && material != Material.FURNACE && material != Material.BED && material != Material.SIGN_POST && material != Material.COMMAND && material != Material.WALL_SIGN;
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                wand.closeInventory();
            }
        }
        if (toggleInventory) {
            if (!mage.cancel()) {
                if (wand.getMode() == WandMode.CYCLE) {
                    if (player.isSneaking()) {
                        Spell activeSpell = wand.getActiveSpell();
                        boolean cycleMaterials = false;
                        if (activeSpell != null) {
                            boolean bl3 = cycleMaterials = activeSpell.hasBrushOverride() && wand.getBrushes().size() > 0;
                        }
                        if (cycleMaterials) {
                            wand.cycleMaterials(player.getItemInHand());
                        } else {
                            wand.cycleSpells(player.getItemInHand());
                        }
                    } else {
                        wand.cycleSpells(player.getItemInHand());
                    }
                } else {
                    wand.toggleInventory();
                }
                event.setCancelled(true);
            } else {
                mage.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = Wand.getActiveWand(this, player);
        if (wand != null) {
            wand.activate(mage);
        } else if (mage.isNewPlayer() && this.welcomeWand.length() > 0) {
            mage.clearNewPlayer();
            wand = Wand.createWand(this, this.welcomeWand);
            if (wand != null) {
                wand.takeOwnership(player, false, false);
                this.giveItemToPlayer(player, wand.getItem());
                this.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
            } else {
                this.getLogger().warning("Unable to give welcome wand '" + this.welcomeWand + "' to " + player.getName());
            }
        }
        Collection<Spell> spells = mage.getSpells();
        for (Spell spell : spells) {
            if (!spell.isActive()) continue;
            mage.sendMessage(Messages.get("spell.reactivate").replace("$name", spell.getName()));
            mage.activateSpell(spell);
        }
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory()) {
            mage.addToStoredInventory(itemStack);
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItem(inventory.getHeldItemSlot(), itemStack);
            if (Wand.isWand(itemStack)) {
                Wand wand = new Wand(this, itemStack);
                wand.activate(this.getMage((CommandSender)player));
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            if (returned.size() > 0) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (event.getAmount() <= 0) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.onPlayerExpChange(event);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        URLMap.resend(player.getName());
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.onPlayerQuit(event);
        com.elmakers.mine.bukkit.block.UndoQueue undoQueue = mage.getUndoQueue();
        if (this.commitOnQuit && undoQueue != null && !undoQueue.isEmpty()) {
            this.getLogger().info("Player logged out, committing constructions: " + mage.getName());
            undoQueue.commit();
            undoQueue.undoScheduled();
        }
        try {
            File playerData = new File(this.playerDataFolder, player.getUniqueId().toString() + ".dat");
            this.getLogger().info("Player logged out, saving data to " + playerData.getName());
            DataStore playerConfig = new DataStore(this.getLogger(), playerData);
            mage.save((ConfigurationSection)playerConfig);
            playerConfig.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.closeInventory();
        }
        mage.restoreInventory();
        if (undoQueue == null || undoQueue.isEmpty()) {
            this.getLogger().info("Player has no pending undo actions, forgetting: " + mage.getName());
            this.mages.remove(player.getUniqueId().toString());
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        for (com.elmakers.mine.bukkit.api.magic.Mage apiMage : this.mages.values()) {
            Mage mage;
            Player player;
            if (!(apiMage instanceof Mage) || (player = (mage = (Mage)apiMage).getPlayer()) == null) continue;
            Wand wand = mage.getActiveWand();
            if (wand != null) {
                wand.deactivate();
            }
            mage.restoreInventory();
            player.updateInventory();
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Player[] players;
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            Wand wand = Wand.getActiveWand(this, player);
            if (wand == null) continue;
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.getMage(player);
            wand.activate(mage);
            player.updateInventory();
        }
        this.crafting.enable((Plugin)this.plugin);
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (!(wand == null || event.getView().getType() == InventoryType.CRAFTING || wand.getMode() != WandMode.INVENTORY && wand.isInventoryOpen())) {
            wand.deactivate();
        }
    }

    protected ItemStack removeItemFromWand(Wand wand, ItemStack droppedItem) {
        if (wand == null || droppedItem == null || Wand.isWand(droppedItem)) {
            return null;
        }
        if (Wand.isSpell(droppedItem)) {
            String spellKey = Wand.getSpell(droppedItem);
            wand.removeSpell(spellKey);
            wand.saveInventory();
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                Wand.updateSpellItem(droppedItem, spell, null, null, true);
            }
        } else if (Wand.isBrush(droppedItem)) {
            String brushKey = Wand.getBrush(droppedItem);
            wand.removeBrush(brushKey);
            wand.saveInventory();
            Wand.updateBrushItem(droppedItem, brushKey, null);
        }
        return droppedItem;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && NMSUtils.isTemporary(clickedItem)) {
            String message = NMSUtils.getTemporaryMessage(clickedItem);
            if (message != null && message.length() > 1) {
                mage.sendMessage(message);
            }
            event.setCurrentItem(null);
            event.setCancelled(true);
            return;
        }
        Wand activeWand = mage.getActiveWand();
        InventoryType inventoryType = event.getInventory().getType();
        if (event.getAction() == InventoryAction.DROP_ONE_SLOT && activeWand != null && activeWand.isInventoryOpen()) {
            ItemStack droppedItem = clickedItem;
            ItemStack newDrop = this.removeItemFromWand(activeWand, droppedItem);
            if (newDrop != null) {
                Location location = player.getLocation();
                Item item = location.getWorld().dropItem(location, newDrop);
                item.setVelocity(location.getDirection().normalize());
            } else {
                event.setCancelled(true);
            }
            return;
        }
        if (activeWand != null) {
            WandMode wandMode = activeWand.getMode();
            if ((wandMode == WandMode.INVENTORY && inventoryType == InventoryType.CRAFTING || wandMode == WandMode.CHEST && inventoryType == InventoryType.CHEST) && activeWand != null && activeWand.isInventoryOpen()) {
                if (event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.NOTHING) {
                    activeWand.cycleInventory();
                    event.setCancelled(true);
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    event.setCancelled(true);
                    return;
                }
                if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || wandMode == WandMode.CHEST) {
                    this.onPlayerActivateIcon(mage, activeWand, clickedItem);
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (Wand.isWand(event.getCursor()) || Wand.isWand(clickedItem)) {
                    event.setCancelled(true);
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand previousWand = mage.getActiveWand();
        if (previousWand != null && previousWand.isInventoryOpen()) {
            if (previousWand.getMode() == WandMode.INVENTORY) {
                previousWand.saveInventory();
            } else if (previousWand.getMode() == WandMode.CHEST) {
                previousWand.closeInventory();
                return;
            }
        } else {
            Wand wand = Wand.getActiveWand(this, player);
            boolean changedWands = false;
            if (previousWand != null && wand == null) {
                changedWands = true;
            }
            if (previousWand == null && wand != null) {
                changedWands = true;
            }
            if (previousWand != null && wand != null && !previousWand.equals(wand)) {
                changedWands = true;
            }
            if (changedWands) {
                if (previousWand != null) {
                    previousWand.deactivate();
                }
                if (wand != null) {
                    wand.activate(mage);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE && this.enableItemHacks) {
            boolean ejected = false;
            Player player = event.getPlayer();
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
            if (!(apiMage instanceof Mage)) {
                return;
            }
            Mage mage = (Mage)apiMage;
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.deactivate();
            }
            PlayerInventory inventory = player.getInventory();
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!Wand.isWand(item)) continue;
                ejected = true;
                inventory.setItem(i, null);
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            if (ejected) {
                mage.sendMessage("Ejecting wands, creative mode will destroy them!");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        ItemStack pickup = event.getItem().getItemStack();
        boolean isWand = Wand.isWand(pickup);
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && isWand && this.enableItemHacks) {
            event.setCancelled(true);
            return;
        }
        if (isWand) {
            Wand wand = new Wand(this, pickup);
            if (this.removeLostWand(wand.getLostId())) {
                this.plugin.getLogger().info("Player " + mage.getName() + " picked up wand " + wand.getName() + ", id " + wand.getLostId());
            }
            wand.clearLostId();
        }
        if ((activeWand = mage.getActiveWand()) != null && (!Wand.isWand(pickup) || Wand.isWandUpgrade(pickup)) && activeWand.isModifiable() && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (isWand && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(mage);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemStack;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory() || mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
        if (Wand.isWand(itemStack = event.getItemInHand()) || Wand.isBrush(itemStack) || Wand.isSpell(itemStack)) {
            event.setCancelled(true);
        }
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        Location location = lostWand.getLocation();
        if (!lostWand.isIndestructible()) {
            return true;
        }
        return this.addMarker("wand-" + lostWand.getId(), "Wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        this.triggerBlockToggle(e.getChunk());
    }

    public void toggleCastCommandOverrides(com.elmakers.mine.bukkit.api.magic.Mage apiMage, boolean override) {
        if (apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            mage.setCostReduction(override ? this.castCommandCostReduction : 0.0f);
            mage.setCooldownReduction(override ? this.castCommandCooldownReduction : 0.0f);
            mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
        }
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.wand.LostWand> getLostWands() {
        return new ArrayList<com.elmakers.mine.bukkit.api.wand.LostWand>(this.lostWands.values());
    }

    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> all = new ArrayList<Automaton>();
        for (Map<Long, Automaton> chunkList : this.automata.values()) {
            all.addAll(chunkList.values());
        }
        return all;
    }

    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, String[] parameters, CommandSender sender, Entity entity) {
        SpellTemplate template;
        Player usePermissions;
        Player player = sender == entity && entity instanceof Player ? (Player)entity : (usePermissions = sender instanceof Player ? (Player)sender : null);
        if (entity == null && sender instanceof Player) {
            entity = (Player)sender;
        }
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = entity != null && entity instanceof Player ? (Player)entity : sender;
            if (sender != null && entity != null && sender != entity) {
                if (sender instanceof BlockCommandSender) {
                    targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
                } else if (entity != null) {
                    targetLocation = entity.getLocation();
                }
            }
            mage = this.getMage(mageController);
        }
        if ((template = this.getSpellTemplate(spellName)) == null || !template.hasCastPermission((CommandSender)usePermissions)) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        Spell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, true);
        spell.cast(parameters, targetLocation);
        this.toggleCastCommandOverrides(mage, false);
        if (sender != entity && sender != null) {
            String castMessage = "Cast " + spellName;
            if (entity != null) {
                castMessage = castMessage + " on " + this.getEntityName(entity);
            }
            sender.sendMessage(castMessage);
        }
        return true;
    }

    public void onCast(com.elmakers.mine.bukkit.api.magic.Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null) {
            this.dynmap.showCastMarker(mage, spell, result);
        }
    }

    protected void triggerBlockToggle(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            final ArrayList<Automaton> restored = new ArrayList<Automaton>();
            ArrayList<Long> blockKeys = new ArrayList<Long>(chunkData.keySet());
            long timeThreshold = System.currentTimeMillis() - (long)this.toggleCooldown;
            for (Long blockKey : blockKeys) {
                Automaton toggleBlock = chunkData.get(blockKey);
                if (toggleBlock.getCreatedTime() >= timeThreshold) continue;
                Block current = toggleBlock.getBlock();
                if (current.getType() == toggleBlock.getMaterial()) {
                    current.setType(Material.AIR);
                    restored.add(toggleBlock);
                }
                chunkData.remove(blockKey);
            }
            if (restored.size() > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Automaton restoreBlock : restored) {
                            MagicController.this.getLogger().info("Resuming block at " + restoreBlock.getPosition() + ": " + restoreBlock.getName());
                            restoreBlock.restore();
                            MagicController.this.sendToMages(restoreBlock.getMessage(), restoreBlock.getPosition().toLocation(restoreBlock.getWorld()));
                        }
                    }
                }, 5L);
            }
            if (chunkData.size() == 0) {
                this.automata.remove(chunkKey);
            }
        }
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    public boolean getIndestructibleWands() {
        return this.indestructibleWands;
    }

    @Override
    public void forgetMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.forgetMages.put(mage.getId(), System.currentTimeMillis());
    }

    @Override
    public boolean isAutomata(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            return toReload.containsKey(BlockData.getBlockId(block));
        }
        return false;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return entity != null && (entity.hasMetadata("NPC") || entity.hasMetadata("shopkeeper"));
    }

    @Override
    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    @Override
    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public void update(String worldName, BoundingBox area) {
        if (this.dynmap != null && this.dynmapUpdate && area != null && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, area.getMin().getBlockX(), area.getMin().getBlockY(), area.getMin().getBlockZ(), area.getMax().getBlockX(), area.getMax().getBlockY(), area.getMax().getBlockZ());
        }
    }

    @Override
    public void update(BlockList blockList) {
        if (blockList != null) {
            if (blockList.size() > VOLUME_UPDATE_THRESHOLD) {
                this.update(blockList.getWorldName(), blockList.getArea());
            } else {
                for (com.elmakers.mine.bukkit.api.block.BlockData blockData : blockList) {
                    this.updateBlock(blockData.getWorldName(), blockData.getPosition().getBlockX(), blockData.getPosition().getBlockY(), blockData.getPosition().getBlockZ());
                }
            }
        }
    }

    @Override
    public boolean canCreateWorlds() {
        return this.createWorldsEnabled;
    }

    @Override
    public Set<Material> getMaterialSet(String name) {
        if (name.contains(",")) {
            return ConfigurationUtils.parseMaterials(name);
        }
        if (!this.materialSets.containsKey(name)) {
            return ConfigurationUtils.parseMaterials(name);
        }
        return this.materialSets.get(name);
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, this.toggleMessageRange);
    }

    @Override
    public void registerAutomata(Block block, String name, String message) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload == null) {
            toReload = new HashMap<Long, Automaton>();
            this.automata.put(chunkId, toReload);
        }
        Automaton data = new Automaton(block, name, message);
        toReload.put(data.getId(), data);
    }

    @Override
    public boolean unregisterAutomata(Block block) {
        String chunkId = this.getChunkKey(block.getChunk());
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            toReload.remove(BlockData.getBlockId(block));
        }
        return toReload != null;
    }

    @Override
    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> mageInterfaces = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.mages.values());
        return mageInterfaces;
    }

    @Override
    public Set<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    @Override
    public Set<Material> getDestructibleMaterials() {
        return this.destructibleMaterials;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        return this.restrictedMaterials;
    }

    @Override
    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    @Override
    public boolean isMage(Entity entity) {
        return this.mages.containsKey(entity.getUniqueId().toString());
    }

    @Override
    public Collection<String> getMaterialSets() {
        return this.materialSets.keySet();
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        List worlds = Bukkit.getWorlds();
        for (World world : worlds) {
            List players = world.getPlayers();
            for (Player player : players) {
                if (this.isNPC((Entity)player)) continue;
                playerNames.add(player.getName());
            }
        }
        return playerNames;
    }

    @Override
    public void disablePhysics(int interval) {
        if (this.physicsHandler == null && interval > 0) {
            this.physicsHandler = new PhysicsHandler(this, interval);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
    }

    @Override
    public boolean commitAll() {
        boolean undid = false;
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        return undid;
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        if (this.bypassPvpPermissions) {
            return true;
        }
        return this.worldGuardManager.isPVPAllowed(location);
    }

    @Override
    public Location getWarp(String warpName) {
        if (this.warpController == null) {
            return null;
        }
        return this.warpController.getWarp(warpName);
    }

    @Override
    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    @Override
    public UndoList undoAny(Block target) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoList undid = mage.undo(target);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    public UndoList undoRecent(Block target, int timeout) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoQueue queue = mage.getUndoQueue();
            UndoList undid = queue.undoRecent(target, timeout);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this, wandKey);
    }

    @Override
    public boolean elementalsEnabled() {
        return this.elementals != null;
    }

    @Override
    public boolean createElemental(Location location, String templateName, CommandSender creator) {
        return this.elementals.createElemental(location, templateName, creator);
    }

    @Override
    public boolean isElemental(Entity entity) {
        if (this.elementals == null || entity.getType() != EntityType.FALLING_BLOCK) {
            return false;
        }
        return this.elementals.isElemental(entity);
    }

    @Override
    public boolean damageElemental(Entity entity, double damage, int fireTicks, CommandSender attacker) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.damageElemental(entity, damage, fireTicks, attacker);
    }

    @Override
    public boolean setElementalScale(Entity entity, double scale) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.setElementalScale(entity, scale);
    }

    @Override
    public double getElementalScale(Entity entity) {
        if (this.elementals == null) {
            return 0.0;
        }
        return this.elementals.getElementalScale(entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.spell.SpellCategory getCategory(String key) {
        SpellCategory category = this.categories.get(key);
        if (category == null) {
            category = new SpellCategory(key, this);
            this.categories.put(key, category);
        }
        return category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> getCategories() {
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        allCategories.addAll(this.categories.values());
        return allCategories;
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        ArrayList<SpellTemplate> allSpells = new ArrayList<SpellTemplate>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    @Override
    public SpellTemplate getSpellTemplate(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.spells.get(name);
    }

    @Override
    public String getEntityName(Entity target) {
        LivingEntity li;
        String customName;
        if (target instanceof Player) {
            return ((Player)target).getName();
        }
        if (this.isElemental(target)) {
            return "Elemental";
        }
        if (target instanceof LivingEntity && (customName = (li = (LivingEntity)target).getCustomName()) != null && customName.length() > 0) {
            return customName;
        }
        return target.getType().name().toLowerCase().replace('_', ' ');
    }
}

