/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.effect.ParticleType;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.effect.EffectRepeating;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class EffectLibManager {
    private final Object manager;
    private Class<?> particleEffectClass;
    private Method particleEffectLookupMethod;

    public EffectLibManager(Object manager) {
        this.manager = manager;
    }

    public boolean initialize() {
        if (this.manager == null) {
            return false;
        }
        try {
            this.particleEffectClass = Class.forName("de.slikey.effectlib.util.ParticleEffect");
            this.particleEffectLookupMethod = this.particleEffectClass.getMethod("fromName", String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.particleEffectClass != null && this.particleEffectLookupMethod != null;
    }

    protected Object[] tryPointConstructor(Class<?> effectLibClass, EffectPlayer effectPlayer) {
        Location origin;
        Location target = effectPlayer.playAtTarget ? effectPlayer.target : null;
        Location location = origin = effectPlayer.playAtOrigin ? effectPlayer.origin : null;
        if (origin == null && target == null) {
            return null;
        }
        Object[] players = null;
        try {
            Constructor<?> constructor = effectLibClass.getConstructor(this.manager.getClass(), Location.class);
            if (target != null && origin != null) {
                players = new Object[]{constructor.newInstance(this.manager, target), constructor.newInstance(this.manager, origin)};
            } else if (target != null) {
                players = new Object[]{constructor.newInstance(this.manager, target)};
            } else if (origin != null) {
                players = new Object[]{constructor.newInstance(this.manager, origin)};
            }
        }
        catch (Exception ex) {
            players = null;
        }
        return players;
    }

    protected Object[] tryEntityConstructor(Class<?> effectLibClass, EffectPlayer effectPlayer) {
        Entity origin;
        Entity target = effectPlayer.targetEntity != null && effectPlayer.playAtTarget ? (Entity)effectPlayer.targetEntity.get() : null;
        Entity entity = origin = effectPlayer.originEntity != null && effectPlayer.playAtOrigin ? (Entity)effectPlayer.originEntity.get() : null;
        if (target == null && origin == null) {
            return null;
        }
        Object[] players = null;
        try {
            Constructor<?> constructor = effectLibClass.getConstructor(this.manager.getClass(), Entity.class);
            if (target != null && origin != null) {
                players = new Object[]{constructor.newInstance(this.manager, target), constructor.newInstance(this.manager, origin)};
            } else if (target != null) {
                players = new Object[]{constructor.newInstance(this.manager, target)};
            } else if (origin != null) {
                players = new Object[]{constructor.newInstance(this.manager, origin)};
            }
        }
        catch (Exception ex) {
            players = null;
        }
        return players;
    }

    protected Object tryLineConstructor(Class<?> effectLibClass, EffectPlayer effectPlayer) {
        if (effectPlayer.origin == null || effectPlayer.target == null) {
            return null;
        }
        Object player = null;
        try {
            Constructor<?> constructor = effectLibClass.getConstructor(this.manager.getClass(), Location.class, Location.class);
            player = constructor.newInstance(this.manager, effectPlayer.origin, effectPlayer.target);
        }
        catch (Exception ex) {
            player = null;
        }
        return player;
    }

    public void play(Plugin plugin, ConfigurationSection configuration, EffectPlayer player) {
        Object lineEffect;
        Class<?> effectLibClass = null;
        String className = configuration.getString("class");
        try {
            effectLibClass = Class.forName("de.slikey.effectlib.effect." + className);
        }
        catch (Throwable ex) {
            plugin.getLogger().info("Error loading EffectLib class: " + className);
            ex.printStackTrace();
            return;
        }
        Object[] effects = this.tryPointConstructor(effectLibClass, player);
        if (effects == null && (effects = this.tryEntityConstructor(effectLibClass, player)) == null && (lineEffect = this.tryLineConstructor(effectLibClass, player)) != null) {
            effects = new Object[]{lineEffect};
        }
        if (effects == null) {
            plugin.getLogger().info("Failed to construct EffectLib class: " + effectLibClass.getName());
            return;
        }
        ParticleType particleType = player.particleType;
        for (Object effect : effects) {
            Object converted;
            if (particleType != null && (converted = this.convertParticleEffect(particleType)) != null) {
                try {
                    Field particleField = effectLibClass.getField("particle");
                    particleField.set(effect, converted);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (player instanceof EffectRepeating) {
                EffectRepeating repeating = (EffectRepeating)player;
                try {
                    Field periodField = effectLibClass.getField("period");
                    periodField.set(effect, repeating.period);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            Set keys = configuration.getKeys(false);
            for (String key : keys) {
                if (key.equals("class") || this.setField(effect, key, configuration)) continue;
                plugin.getLogger().warning("Unable to assign EffectLib property " + key + " of class " + className);
            }
            try {
                Method startMethod = effectLibClass.getMethod("start", new Class[0]);
                startMethod.invoke(effect, new Object[0]);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    protected boolean setField(Object effect, String key, ConfigurationSection section) {
        try {
            Field field = effect.getClass().getField(key);
            if (field.getType().equals(Integer.TYPE)) {
                field.set(effect, section.getInt(key));
            } else if (field.getType().equals(Float.TYPE)) {
                field.set(effect, Float.valueOf((float)section.getDouble(key)));
            } else if (field.getType().equals(Double.TYPE)) {
                field.set(effect, section.getDouble(key));
            } else if (field.getType().equals(Boolean.TYPE)) {
                field.set(effect, section.getBoolean(key));
            } else if (field.getType().equals(Long.TYPE)) {
                field.set(effect, section.getLong(key));
            } else if (field.getType().isAssignableFrom(String.class)) {
                field.set(effect, section.getString(key));
            } else if (field.getType().isAssignableFrom(this.particleEffectClass)) {
                field.set(effect, this.convertParticleEffect(ParticleType.valueOf(section.getString(key).toUpperCase())));
            } else {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Object convertParticleEffect(ParticleType particleType) {
        Object converted = null;
        try {
            converted = this.particleEffectLookupMethod.invoke(null, particleType.getParticleName());
        }
        catch (Throwable ex) {
            converted = null;
            ex.printStackTrace();
        }
        return converted;
    }
}

