/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();
    public static float maxValue = 1.0f;
    public static int maxUses = 500;
    public static int maxMaxXp = 1500;
    public static int maxXpRegeneration = 150;
    public static float maxHungerRegeneration = 5.0f;
    public static float maxHealthRegeneration = 5.0f;
    public static float maxDamageReduction = 0.4f;
    public static float maxDamageReductionExplosions = 0.3f;
    public static float maxDamageReductionFalling = 0.9f;
    public static float maxDamageReductionFire = 0.5f;
    public static float maxDamageReductionPhysical = 0.1f;
    public static float maxDamageReductionProjectiles = 0.2f;
    public static float maxCostReduction = 0.5f;
    public static float maxCooldownReduction = 0.5f;
    public static float maxHasteLevel = 20.0f;
    public static int minLevel = 10;
    public static int maxLevel = 40;

    public static void load(ConfigurationSection properties) {
        maxValue = (float)properties.getDouble("max_property_value", (double)maxValue);
        maxUses = properties.getInt("max_uses", maxUses);
        maxMaxXp = properties.getInt("max_mana", maxMaxXp);
        maxXpRegeneration = properties.getInt("max_mana_regeneration", maxXpRegeneration);
        maxHealthRegeneration = (float)properties.getDouble("max_health_regeneration", (double)maxHealthRegeneration);
        maxHungerRegeneration = (float)properties.getDouble("max_hunger_regeneration", (double)maxHungerRegeneration);
        minLevel = properties.getInt("min_enchant_level", minLevel);
        maxLevel = properties.getInt("max_enchant_level", maxLevel);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction", (double)maxDamageReduction);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction_explosions", (double)maxDamageReductionExplosions);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction_falling", (double)maxDamageReductionFalling);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction_fire", (double)maxDamageReductionFire);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction_physical", (double)maxDamageReductionPhysical);
        maxDamageReduction = (float)properties.getDouble("max_damage_reduction_projectiles", (double)maxDamageReductionProjectiles);
        maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)maxCostReduction);
        maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)maxCooldownReduction);
        maxHasteLevel = (float)properties.getDouble("max_haste", (double)maxHasteLevel);
    }

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationSection template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        for (int i = 0; i < levels.length; ++i) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
        }
        for (int level = 1; level <= levels[levels.length - 1]; ++level) {
            levelMap.put(level, new WandLevel(level, template));
        }
    }

    private WandLevel(int level, ConfigurationSection template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        for (levelIndex = 0; levelIndex < levels.length; ++levelIndex) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level <= levels[levelIndex]) continue;
            nextLevelIndex = levelIndex + 1;
            int previousLevel = levels[levelIndex];
            int nextLevel = levels[nextLevelIndex];
            distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
        }
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getConfigurationSection("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getConfigurationSection("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template.getConfigurationSection("materials"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getConfigurationSection("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getConfigurationSection("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template.getConfigurationSection("property_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getConfigurationSection("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getConfigurationSection("protection"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getConfigurationSection("protection_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getConfigurationSection("protection_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getConfigurationSection("protection_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getConfigurationSection("protection_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getConfigurationSection("protection_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getConfigurationSection("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getConfigurationSection("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getConfigurationSection("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getConfigurationSection("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getConfigurationSection("haste"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template.getConfigurationSection("power"), levelIndex, nextLevelIndex, distance);
    }

    /*
     * WARNING - void declaration
     */
    private boolean randomizeWand(Wand wand, boolean additive) {
        boolean bl;
        boolean addedSpells = false;
        Collection wandSpells = wand.getSpells();
        LinkedList remainingSpells = new LinkedList();
        for (WeightedPair weightedPair : this.spellProbability) {
            if (wandSpells.contains(weightedPair.getValue())) continue;
            remainingSpells.add(weightedPair);
        }
        SpellTemplate firstSpell = null;
        if (remainingSpells.size() > 0) {
            Integer n = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            int retries = 10;
            for (int i = 0; i < n; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                if (wand.addSpell(spellKey)) {
                    if (firstSpell == null) {
                        firstSpell = wand.getMaster().getSpellTemplate(spellKey);
                    }
                    addedSpells = true;
                    continue;
                }
                if (retries-- <= 0) continue;
                --i;
            }
        }
        boolean bl2 = false;
        int maxXpCost = 0;
        Collection spells = wand.getSpells();
        for (String spellName : spells) {
            SpellTemplate spell = wand.getMaster().getSpellTemplate(spellName);
            if (spell == null) continue;
            boolean bl3 = bl = bl || spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxXpCost = Math.max(maxXpCost, cost.getXP());
            }
        }
        boolean addedMaterials = false;
        Collection wandMaterials = wand.getBrushes();
        LinkedList remainingMaterials = new LinkedList();
        for (WeightedPair weightedPair : this.materialProbability) {
            String materialKey = (String)weightedPair.getValue();
            materialKey = materialKey.replace("|", ":");
            if (wandMaterials.contains(weightedPair.getValue()) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(weightedPair);
        }
        if (bl && remainingMaterials.size() > 0) {
            void var14_27;
            int currentMaterialCount = wand.getBrushes().size();
            Integer n = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (currentMaterialCount == 0) {
                Integer n2 = Math.max(1, n);
            }
            int retries = 100;
            for (int i = 0; i < var14_27.intValue(); ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
            }
        }
        boolean addedProperties = false;
        Integer n = (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        MemoryConfiguration wandProperties = new MemoryConfiguration();
        double costReduction = wand.getCostReduction();
        while (true) {
            Integer n3;
            void var14_30;
            void var20_39 = var14_30;
            Integer n4 = n3 = Integer.valueOf(var14_30.intValue() - 1);
            if (var20_39.intValue() <= 0) break;
            int randomProperty = (int)(Math.random() * 10.0);
            switch (randomProperty) {
                case 0: {
                    if (!(costReduction < (double)maxValue)) break;
                    addedProperties = true;
                    costReduction = Math.min((double)maxValue, costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                    wandProperties.set("cost_reduction", (Object)costReduction);
                    break;
                }
                case 1: {
                    float power = wand.getPower();
                    if (!(power < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("power", (Object)Math.min(maxValue, power + ((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue()));
                    break;
                }
                case 2: {
                    float damageReduction = wand.getDamageReduction();
                    if (!(damageReduction < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection", (Object)Math.min(maxValue, damageReduction + ((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue()));
                    break;
                }
                case 3: {
                    float damageReductionPhysical = wand.getDamageReductionPhysical();
                    if (!(damageReductionPhysical < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection_physical", (Object)Math.min(maxValue, damageReductionPhysical + ((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue()));
                    break;
                }
                case 4: {
                    float damageReductionProjectiles = wand.getDamageReductionProjectiles();
                    if (!(damageReductionProjectiles < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection_projectiles", (Object)Math.min(maxValue, damageReductionProjectiles + ((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue()));
                    break;
                }
                case 5: {
                    float damageReductionFalling = wand.getDamageReductionFalling();
                    if (!(damageReductionFalling < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection_falling", (Object)Math.min(maxValue, damageReductionFalling + ((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue()));
                    break;
                }
                case 6: {
                    float damageReductionFire = wand.getDamageReductionFire();
                    if (!(damageReductionFire < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection_fire", (Object)Math.min(maxValue, damageReductionFire + ((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue()));
                    break;
                }
                case 7: {
                    float damageReductionExplosions = wand.getDamageReductionExplosions();
                    if (!(damageReductionExplosions < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("protection_explosions", (Object)Math.min(maxValue, damageReductionExplosions + ((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue()));
                    break;
                }
                case 10: {
                    float healthRegeneration = wand.getHealthRegeneration();
                    if (!(healthRegeneration < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("health_regeneration", (Object)((int)Math.min(maxValue, healthRegeneration + (float)((Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)).intValue())));
                    break;
                }
                case 11: {
                    float hungerRegeneration = wand.getHungerRegeneration();
                    if (!(hungerRegeneration < maxValue)) break;
                    addedProperties = true;
                    wandProperties.set("hunger_regeneration", (Object)((int)Math.min(maxValue, hungerRegeneration + (float)((Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)).intValue())));
                }
            }
        }
        if (costReduction > 1.0) {
            wandProperties.set("xp_regeneration", (Object)0);
            wandProperties.set("xp_max", (Object)0);
            wandProperties.set("xp", (Object)0);
        } else {
            int xpMax;
            int xpRegeneration = wand.getXpRegeneration();
            if (xpRegeneration < maxXpRegeneration) {
                addedProperties = true;
                wandProperties.set("xp_regeneration", (Object)Math.min(maxXpRegeneration, xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability)));
            }
            if ((xpMax = wand.getXpMax()) < maxMaxXp) {
                xpMax = Math.min(maxMaxXp, xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability));
                xpMax = Math.max(maxXpCost, xpMax);
                wandProperties.set("xp_max", (Object)xpMax);
                addedProperties = true;
            }
            wandProperties.set("xp", (Object)xpMax);
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < maxUses) {
                wandProperties.set("uses", (Object)Math.min(maxUses, wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
                addedProperties = true;
            }
        } else {
            wandProperties.set("uses", (Object)Math.min(maxUses, (Integer)RandomUtils.weightedRandom(this.useProbability)));
            String spellName = "Nothing";
            if (firstSpell != null) {
                spellName = firstSpell.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
        wand.loadProperties((ConfigurationSection)wandProperties);
        return addedMaterials || addedSpells || addedProperties;
    }

    public static boolean randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        return wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        int[] arr$ = levels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer level = arr$[i$];
            if (level < minLevel || level > maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }

    public static int getMaxLevel() {
        if (levels == null) {
            return 0;
        }
        return Math.min(levels[levels.length - 1], maxLevel);
    }
}

