/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.BlockBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.batch.SpellBatch;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class UndoSpell
extends TargetingSpell {
    private String undoListName;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock;
        Target target = this.getTarget();
        Player player = this.getPlayer();
        if (target.hasEntity() && target.getEntity() instanceof Player) {
            if (player != null && target.getEntity() != player && !this.mage.isSuperPowered()) {
                return SpellResult.NO_TARGET;
            }
            Mage mage = this.controller.getMage((CommandSender)((Player)target.getEntity()));
            UndoList undoList = mage.undo();
            if (undoList != null) {
                this.undoListName = undoList.getName();
            }
            return undoList != null ? SpellResult.CAST : SpellResult.FAIL;
        }
        Block block = targetBlock = this.isLookingDown() ? this.getLocation().getBlock() : target.getBlock();
        if (targetBlock != null) {
            boolean targetAll = this.mage.isSuperPowered();
            if (targetAll) {
                UndoList undid = this.controller.undoAny(targetBlock);
                if (undid != null) {
                    Mage targetMage = undid.getOwner();
                    this.undoListName = undid.getName();
                    this.setTargetName(targetMage.getName());
                    return SpellResult.CAST;
                }
            } else {
                this.setTargetName(this.mage.getName());
                BlockBatch batch = this.mage.cancelPending();
                if (batch != null) {
                    this.undoListName = batch instanceof SpellBatch ? ((SpellBatch)batch).getSpell().getName() : null;
                    return SpellResult.COST_FREE;
                }
                UndoList undoList = this.mage.undo(targetBlock);
                this.undoListName = undoList.getName();
                return SpellResult.CAST;
            }
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$spell", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

