/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CastCommandExecutor
extends MagicTabExecutor {
    public CastCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (commandLabel.equalsIgnoreCase("castp")) {
            if (!this.api.hasPermission(sender, "Magic.commands.castp")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage("Usage: /castp [player] [spell] <parameters>");
                return true;
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + args[0] + " is not online");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processCastCommand(sender, player, args2);
        }
        if (commandLabel.equalsIgnoreCase("cast")) {
            if (!this.api.hasPermission(sender, "Magic.commands.cast")) {
                this.sendNoPermission(sender);
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            return this.processCastCommand(sender, player, args);
        }
        return false;
    }

    public boolean processCastCommand(CommandSender sender, Player player, String[] castParameters) {
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = new String[castParameters.length - 1];
        for (int i = 1; i < castParameters.length; ++i) {
            parameters[i - 1] = castParameters[i];
        }
        this.api.cast(spellName, parameters, sender, player);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String spellName;
        SpellTemplate spell;
        ArrayList<String> options = new ArrayList<String>();
        if (commandName.equalsIgnoreCase("castp")) {
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                Collections.sort(options);
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            Collection<SpellTemplate> spellList = this.api.getSpellTemplates();
            for (SpellTemplate spell2 : spellList) {
                this.addIfPermissible(sender, options, "Magic." + commandName + ".", spell2.getKey(), true);
            }
        }
        if (args.length > 1 && (spell = this.api.getSpellTemplate(spellName = args[0])) != null) {
            if (args.length % 2 == 0 || args.length < 2) {
                spell.getParameters(options);
            } else {
                spell.getParameterOptions(options, args[args.length - 2]);
            }
        }
        Collections.sort(options);
        return options;
    }
}

