/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.Automaton;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.CastCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.SpellsCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.WandCommandExecutor;
import com.elmakers.mine.bukkit.utility.URLMap;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin
implements MagicAPI {
    private MagicController controller = null;

    public void onEnable() {
        if (this.controller == null) {
            this.controller = new MagicController(this);
        }
        this.initialize();
    }

    protected void initialize() {
        this.controller.initialize();
        MagicCommandExecutor magicCommand = new MagicCommandExecutor(this);
        this.getCommand("magic").setExecutor((CommandExecutor)magicCommand);
        this.getCommand("magic").setTabCompleter((TabCompleter)magicCommand);
        CastCommandExecutor castCommand = new CastCommandExecutor(this);
        this.getCommand("cast").setExecutor((CommandExecutor)castCommand);
        this.getCommand("cast").setTabCompleter((TabCompleter)castCommand);
        this.getCommand("castp").setExecutor((CommandExecutor)castCommand);
        this.getCommand("castp").setTabCompleter((TabCompleter)castCommand);
        WandCommandExecutor wandCommand = new WandCommandExecutor(this);
        this.getCommand("wand").setExecutor((CommandExecutor)wandCommand);
        this.getCommand("wand").setTabCompleter((TabCompleter)wandCommand);
        this.getCommand("wandp").setExecutor((CommandExecutor)wandCommand);
        this.getCommand("wandp").setTabCompleter((TabCompleter)wandCommand);
        SpellsCommandExecutor spellsCommand = new SpellsCommandExecutor(this);
        this.getCommand("spells").setExecutor((CommandExecutor)spellsCommand);
    }

    public void onDisable() {
        this.controller.save();
        this.controller.clear();
    }

    @Override
    public Plugin getPlugin() {
        return this;
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode) {
        return this.controller.hasPermission(sender, pNode);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultPermission) {
        return this.controller.hasPermission(sender, pNode, defaultPermission);
    }

    @Override
    public void save() {
        this.controller.save();
        URLMap.save();
    }

    @Override
    public void reload() {
        this.controller.loadConfiguration();
        URLMap.loadConfiguration();
    }

    @Override
    public void clearCache() {
        this.controller.clearCache();
        URLMap.clearCache();
    }

    @Override
    public boolean commit() {
        return this.controller.commitAll();
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        return this.controller.getMages();
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMagesWithPendingBatches() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> mages = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        Collection<Mage> internal = this.controller.getPending();
        mages.addAll(internal);
        return mages;
    }

    @Override
    public Collection<LostWand> getLostWands() {
        ArrayList<LostWand> lostWands = new ArrayList<LostWand>();
        lostWands.addAll(this.controller.getLostWands());
        return lostWands;
    }

    @Override
    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        automata.addAll(this.controller.getAutomata());
        return automata;
    }

    @Override
    public void removeLostWand(String id) {
        this.controller.removeLostWand(id);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getWand(ItemStack itemStack) {
        return new Wand(this.controller, itemStack);
    }

    @Override
    public boolean isWand(ItemStack item) {
        return Wand.isWand(item);
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        this.controller.giveItemToPlayer(player, itemStack);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(CommandSender sender) {
        return this.controller.getMage(sender);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this.controller, wandKey);
    }

    @Override
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, null, true);
    }

    @Override
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this.controller, null, true);
    }

    @Override
    public void cast(String spellName, String[] parameters) {
        this.controller.cast(null, spellName, parameters, null, null);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.controller.getSpellTemplates();
    }

    @Override
    public Collection<String> getWandKeys() {
        return Wand.getWandKeys();
    }

    @Override
    public void cast(String spellName, String[] parameters, CommandSender sender, Player player) {
        this.controller.cast(null, spellName, parameters, sender, player);
    }

    @Override
    public Collection<String> getPlayerNames() {
        return this.controller.getPlayerNames();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(Material iconMaterial, short iconData) {
        return new Wand(this.controller, iconMaterial, iconData);
    }

    @Override
    public SpellTemplate getSpellTemplate(String key) {
        return this.controller.getSpellTemplate(key);
    }

    @Override
    public Collection<String> getSchematicNames() {
        return this.controller.getSchematicNames();
    }

    @Override
    public Collection<String> getBrushes() {
        return this.controller.getBrushKeys();
    }

    @Override
    public MageController getController() {
        return this.controller;
    }
}

