/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class ProjectileSpell
extends UndoableSpell {
    private int defaultSize = 1;
    private Random random = new Random();

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        int count = parameters.getInt("count", 1);
        int size = parameters.getInt("size", this.defaultSize);
        int radius = parameters.getInt("radius", 0);
        double damage = parameters.getDouble("damage", 0.0);
        float speed = (float)parameters.getDouble("speed", (double)0.6f);
        float spread = (float)parameters.getDouble("spread", 12.0);
        Collection<PotionEffect> effects = null;
        if (radius > 0) {
            effects = ProjectileSpell.getPotionEffects(parameters);
            radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        }
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        float damageMultiplier = this.mage.getDamageMultiplier();
        damage *= (double)damageMultiplier;
        spread /= damageMultiplier;
        boolean useFire = parameters.getBoolean("fire", true);
        int tickIncrease = parameters.getInt("tick_increase", 1180);
        String projectileTypeName = parameters.getString("projectile", "Arrow");
        Class<?> projectileClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityProjectile");
        Class<?> fireballClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityFireball");
        Class<?> arrowClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityArrow");
        Class<?> worldClass = NMSUtils.getBukkitClass("net.minecraft.server.World");
        Class<?> entityClass = NMSUtils.getBukkitClass("net.minecraft.server.Entity");
        Class<?> craftArrowClass = NMSUtils.getBukkitClass("org.bukkit.craftbukkit.entity.CraftArrow");
        if (projectileClass == null || worldClass == null || fireballClass == null || arrowClass == null || craftArrowClass == null) {
            this.controller.getLogger().warning("Can't find NMS classess");
            return SpellResult.FAIL;
        }
        Class<?> projectileType = NMSUtils.getBukkitClass("net.minecraft.server.Entity" + projectileTypeName);
        if (projectileType == null || !arrowClass.isAssignableFrom(projectileType) && !projectileClass.isAssignableFrom(projectileType) && !fireballClass.isAssignableFrom(projectileType)) {
            this.controller.getLogger().warning("Bad projectile class: " + projectileTypeName);
            return SpellResult.FAIL;
        }
        Constructor<?> constructor = null;
        Method shootMethod = null;
        Method setPositionRotationMethod = null;
        Field dirXField = null;
        Field dirYField = null;
        Field dirZField = null;
        Method addEntityMethod = null;
        try {
            constructor = projectileType.getConstructor(worldClass);
            if (fireballClass.isAssignableFrom(projectileType)) {
                dirXField = projectileType.getField("dirX");
                dirYField = projectileType.getField("dirY");
                dirZField = projectileType.getField("dirZ");
            }
            if (projectileClass.isAssignableFrom(projectileType) || arrowClass.isAssignableFrom(projectileType)) {
                shootMethod = projectileType.getMethod("shoot", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            }
            setPositionRotationMethod = projectileType.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            addEntityMethod = worldClass.getMethod("addEntity", entityClass);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return SpellResult.FAIL;
        }
        Location location = this.getEyeLocation();
        Vector direction = this.getDirection().normalize();
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        Object nmsWorld = NMSUtils.getHandle(location.getWorld());
        Player player = this.getPlayer();
        for (int i = 0; i < count; ++i) {
            try {
                Entity entity;
                Object nmsProjectile = null;
                nmsProjectile = constructor.newInstance(nmsWorld);
                if (nmsProjectile == null) {
                    throw new Exception("Failed to spawn projectile of class " + projectileTypeName);
                }
                if (dirXField != null && dirYField != null && dirZField != null) {
                    double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                    double dx = (double)speed * (direction.getX() + this.random.nextGaussian() * spreadWeight);
                    double dy = (double)speed * (direction.getY() + this.random.nextGaussian() * spreadWeight);
                    double dz = (double)speed * (direction.getZ() + this.random.nextGaussian() * spreadWeight);
                    dirXField.set(nmsProjectile, dx * 0.1);
                    dirYField.set(nmsProjectile, dy * 0.1);
                    dirZField.set(nmsProjectile, dz * 0.1);
                }
                Vector modifiedLocation = location.toVector().clone();
                if (i > 0 && fireballClass.isAssignableFrom(projectileType) && spread > 0.0f) {
                    modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + this.random.nextGaussian() * (double)spread / 5.0);
                    modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + this.random.nextGaussian() * (double)spread / 5.0);
                    modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + this.random.nextGaussian() * (double)spread / 5.0);
                }
                setPositionRotationMethod.invoke(nmsProjectile, modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                if (shootMethod != null) {
                    shootMethod.invoke(nmsProjectile, direction.getX(), direction.getY(), direction.getZ(), Float.valueOf(speed), Float.valueOf(spread));
                }
                if ((entity = NMSUtils.getBukkitEntity(nmsProjectile)) == null || !(entity instanceof Projectile)) {
                    throw new Exception("Got invalid bukkit entity from projectile of class " + projectileTypeName);
                }
                Projectile projectile = (Projectile)entity;
                if (player != null) {
                    projectile.setShooter((LivingEntity)player);
                }
                projectiles.add(projectile);
                addEntityMethod.invoke(nmsWorld, nmsProjectile);
                if (projectile instanceof Fireball) {
                    Fireball fireball = (Fireball)projectile;
                    fireball.setIsIncendiary(useFire);
                    fireball.setYield((float)size);
                }
                if (projectile instanceof Arrow) {
                    Arrow arrow = (Arrow)projectile;
                    if (useFire) {
                        arrow.setFireTicks(300);
                    }
                    try {
                        if (arrowClass == null || craftArrowClass == null) {
                            this.controller.getLogger().warning("Can not access NMS EntityArrow class");
                        } else {
                            Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                            Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                            Field fromPlayerField = arrowClass.getField("fromPlayer");
                            fromPlayerField.setInt(handle, 2);
                            if (damage > 0.0) {
                                Field damageField = arrowClass.getDeclaredField("damage");
                                damageField.setAccessible(true);
                                damageField.set(handle, damage);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                this.registerForUndo((Entity)projectile);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (tickIncrease > 0 && projectiles.size() > 0 && arrowClass != null) {
            this.scheduleProjectileCheck(projectiles, tickIncrease, effects, radius, arrowClass, craftArrowClass, 5);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void scheduleProjectileCheck(final Collection<Projectile> projectiles, final int tickIncrease, final Collection<PotionEffect> effects, final int radius, final Class<?> arrowClass, final Class<?> craftArrowClass, final int retries) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ProjectileSpell.this.checkProjectiles(projectiles, tickIncrease, effects, radius, arrowClass, craftArrowClass, retries);
            }
        }, 40L);
    }

    protected void checkProjectiles(Collection<Projectile> projectiles, int tickIncrease, Collection<PotionEffect> effects, int radius, Class<?> arrowClass, Class<?> craftArrowClass, int retries) {
        Field lifeField = null;
        Method getHandleMethod = null;
        try {
            try {
                lifeField = arrowClass.getDeclaredField("at");
            }
            catch (Throwable ignore) {
                lifeField = arrowClass.getDeclaredField("j");
            }
            getHandleMethod = craftArrowClass.getMethod("getHandle", new Class[0]);
        }
        catch (Throwable ex) {
            lifeField = null;
            getHandleMethod = null;
            this.controller.getLogger().warning("Failed to create short-lived arrow. Are you running bukkit? Set tick_increase to 0 to avoid this message");
        }
        ArrayList<Projectile> remaining = new ArrayList<Projectile>();
        for (Projectile projectile : projectiles) {
            if (projectile.isDead()) {
                this.applyPotionEffects(projectile.getLocation(), radius, effects);
                continue;
            }
            remaining.add(projectile);
            if (!(projectile instanceof Arrow) || tickIncrease <= 0 || lifeField == null || getHandleMethod == null) continue;
            try {
                Object handle = getHandleMethod.invoke((Object)projectile, new Object[0]);
                lifeField.setAccessible(true);
                int currentLife = (Integer)lifeField.get(handle);
                if (currentLife >= tickIncrease) continue;
                lifeField.set(handle, tickIncrease);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (remaining.size() > 0 && retries > 0) {
            this.scheduleProjectileCheck(remaining, tickIncrease, effects, radius, arrowClass, craftArrowClass, retries - 1);
        }
    }
}

