/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.ParticleType;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.effect.builtin.EffectSingle;
import com.elmakers.mine.bukkit.effect.builtin.EffectTrail;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class BaseSpell
implements MageSpell,
Cloneable {
    protected static final double VIEW_HEIGHT = 1.65;
    protected static final double LOOK_THRESHOLD_RADIANS = 0.8;
    private static final String EFFECT_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.effect.builtin";
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.STATIONARY_WATER;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "*1", "*-1", "*-0.5", "*0.5", "*1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "bypass_build", "bypass_pvp", "target_npc"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MageController controller;
    protected Mage mage;
    protected Location location;
    private String key;
    private String name;
    private String description;
    private String usage;
    private Color color;
    private SpellCategory category;
    private BaseSpell template;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    protected ConfigurationSection parameters = null;
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private boolean isActive = false;
    private Map<SpellResult, List<EffectPlayer>> effects = new HashMap<SpellResult, List<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;
    private long lastMessageSent = 0L;
    private Set<Material> preventPassThroughMaterials = null;

    @Override
    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    @Override
    public CommandSender getCommandSender() {
        return this.mage.getCommandSender();
    }

    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.contains(mat);
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER || mat == Material.SNOW || mat == Material.TORCH || mat == Material.SIGN_POST || mat == Material.REDSTONE_TORCH_ON || mat == Material.REDSTONE_TORCH_OFF || mat == Material.YELLOW_FLOWER || mat == Material.RED_ROSE || mat == Material.RED_MUSHROOM || mat == Material.BROWN_MUSHROOM || mat == Material.LONG_GRASS;
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > 255) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown.getType()) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, 255, 255);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        Location location = this.findPlaceToStand(targetLoc, maxDownDelta, maxUpDelta);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int minY = 4;
        int maxY = targetLoc.getWorld().getEnvironment() == World.Environment.NETHER ? 120 : 255;
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, maxUpDelta);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, maxDownDelta);
        } else {
            int testMinY = Math.max(maxDownDelta, 4);
            location = this.findPlaceToStand(targetLoc, false, testMinY);
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, maxUpDelta);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, maxDownDelta);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, 255);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int maxDelta) {
        int maxY;
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        int minY = 4;
        int n = maxY = targetLocation.getWorld().getEnvironment() == World.Environment.NETHER ? 120 : 255;
        for (int yDelta = 0; (double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY && yDelta < maxDelta; ++yDelta) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                return targetLocation;
            }
            if (!this.allowPassThrough(block.getType())) {
                return null;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        return BaseSpell.getFacing(this.getLocation());
    }

    public static BlockFace getFacing(Location location) {
        float playerRot;
        for (playerRot = location.getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    public void castMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    public void sendMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    public Location getEyeLocation() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        location.setY(location.getY() + 1.5);
        return location;
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.8;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.8;
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (Math.random() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
                break;
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            String[] pieces = value.split(",");
            try {
                Integer ticks = Integer.parseInt(pieces[0]);
                Integer power = 1;
                if (pieces.length > 0) {
                    power = Integer.parseInt(pieces[1]);
                }
                PotionEffect effect = new PotionEffect(effectType, ticks.intValue(), power.intValue(), true);
                effects.add(effect);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    public FireworkEffect getFireworkEffect() {
        return this.getFireworkEffect(null, null, null, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Color wandColor = this.mage == null ? null : this.mage.getEffectColor();
        Random rand = new Random();
        if (wandColor != null) {
            color1 = wandColor;
            color2 = wandColor.mixColors(new Color[]{color1, Color.WHITE});
        } else {
            if (color1 == null) {
                color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
            if (color2 == null) {
                color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public boolean hasBrushOverride() {
        return false;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                return;
            }
            cost.use(this);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected List<CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getDouble(key, 1.0)));
        }
        return castingCosts;
    }

    protected void loadTemplate(ConfigurationSection node) {
        this.name = this.key;
        this.name = node.getString("name", this.name);
        this.name = Messages.get("spells." + this.key + ".name", this.name);
        this.description = node.getString("description", "");
        this.description = Messages.get("spells." + this.key + ".description", this.description);
        this.usage = Messages.get("spells." + this.key + ".usage", this.usage);
        this.icon = ConfigurationUtils.getMaterialAndData(node, "icon", this.icon);
        this.color = ConfigurationUtils.getColor(node, "color", null);
        this.category = this.controller.getCategory(node.getString("category"));
        this.parameters = node.getConfigurationSection("parameters");
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            for (SpellResult resultType : SpellResult.values()) {
                Collection<ConfigurationSection> effectNodes;
                String typeName = resultType.name().toLowerCase();
                if (!effectsNode.contains(typeName) || (effectNodes = ConfigurationUtils.getNodeList(effectsNode, typeName)) == null) continue;
                ArrayList<EffectPlayer> players = new ArrayList<EffectPlayer>();
                for (ConfigurationSection effectValues : effectNodes) {
                    if (!effectValues.contains("class")) continue;
                    String effectClass = effectValues.getString("class");
                    try {
                        Class<?> genericClass = Class.forName("com.elmakers.mine.bukkit.effect.builtin." + effectClass);
                        if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                            throw new Exception("Must extend EffectPlayer");
                        }
                        Class<?> playerClass = genericClass;
                        EffectPlayer player = (EffectPlayer)playerClass.newInstance();
                        player.load(this.controller.getPlugin(), effectValues);
                        players.add(player);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.controller.getLogger().info("Error creating effect class: " + effectClass + " " + ex.getMessage());
                    }
                }
                this.effects.put(resultType, players);
            }
        }
        this.initializeDefaultSound(SpellResult.FAIL, Sound.NOTE_BASS_DRUM, 0.9f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_RESOURCES, Sound.NOTE_BASS, 1.0f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_PERMISSION, Sound.NOTE_BASS, 1.1f, 1.5f);
        this.initializeDefaultSound(SpellResult.COOLDOWN, Sound.NOTE_SNARE_DRUM, 1.1f, 0.9f);
        this.initializeDefaultSound(SpellResult.NO_TARGET, Sound.NOTE_STICKS, 1.1f, 0.9f);
        if (!this.effects.containsKey((Object)SpellResult.TARGET_SELECTED)) {
            ArrayList<EffectPlayer> effectList = new ArrayList<EffectPlayer>();
            EffectSingle targetHighlight = new EffectSingle(this.controller.getPlugin());
            targetHighlight.setSound(Sound.ANVIL_USE);
            targetHighlight.setParticleType(ParticleType.HAPPY_VILLAGER);
            targetHighlight.setLocationType("target");
            targetHighlight.setOffset(0.5f, 0.5f, 0.5f);
            effectList.add(targetHighlight);
            EffectTrail trail = new EffectTrail(this.controller.getPlugin());
            trail.setParticleType(ParticleType.WATER_DRIPPING);
            effectList.add(trail);
            this.effects.put(SpellResult.TARGET_SELECTED, effectList);
        }
        if (!this.effects.containsKey((Object)SpellResult.COST_FREE) && this.effects.containsKey((Object)SpellResult.CAST)) {
            this.effects.put(SpellResult.COST_FREE, this.effects.get((Object)SpellResult.CAST));
        }
    }

    protected void initializeDefaultSound(SpellResult result, Sound sound, float volume, float pitch) {
        if (this.effects.containsKey((Object)result)) {
            return;
        }
        EffectSingle defaultEffect = new EffectSingle(this.controller.getPlugin());
        defaultEffect.setSound(sound, volume, pitch);
        ArrayList<EffectSingle> effectList = new ArrayList<EffectSingle>();
        effectList.add(defaultEffect);
        this.effects.put(result, effectList);
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.key.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
    }

    @Override
    public boolean cast(String[] extraParameters, Location defaultLocation) {
        double cooldownReduction;
        this.reset();
        if (!this.canCast()) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION);
            return false;
        }
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        this.location = defaultLocation;
        MemoryConfiguration parameters = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.parameters);
        ConfigurationUtils.addParameters(extraParameters, (ConfigurationSection)parameters);
        this.processParameters((ConfigurationSection)parameters);
        this.preCast();
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        long currentTime = System.currentTimeMillis();
        if (!this.mage.isCooldownFree() && (cooldownReduction = (double)(this.mage.getCooldownReduction() + this.cooldownReduction)) < 1.0 && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                long seconds = (this.lastCast - (currentTime - (long)reducedCooldown)) / 1000L;
                if (seconds > 3600L) {
                    long hours = seconds / 3600L;
                    this.sendMessage(Messages.get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString()));
                } else if (seconds > 60L) {
                    long minutes = seconds / 60L;
                    this.sendMessage(Messages.get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                } else if (seconds > 1L) {
                    this.sendMessage(Messages.get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                } else {
                    this.sendMessage(Messages.get("cooldown.wait_moment"));
                }
                this.processResult(SpellResult.COOLDOWN);
                return false;
            }
        }
        if (!this.mage.isCostFree() && this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                String baseMessage = Messages.get("costs.insufficient_resources");
                String costDescription = cost.getDescription(this.mage);
                this.sendMessage(baseMessage.replace("$cost", costDescription));
                this.processResult(SpellResult.INSUFFICIENT_RESOURCES);
                return false;
            }
        }
        return this.finalizeCast((ConfigurationSection)parameters);
    }

    protected boolean canCast() {
        return this.hasCastPermission(this.mage.getCommandSender());
    }

    protected void onBackfire() {
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        SpellResult result = null;
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && Math.random() < (double)this.backfireChance) {
                this.onBackfire();
                this.onCast(parameters);
                result = SpellResult.BACKFIRE;
            } else if (this.fizzleChance > 0.0f && Math.random() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        this.processResult(result);
        if (result.isSuccess()) {
            this.lastCast = System.currentTimeMillis();
            if (this.costs != null && !this.mage.isCostFree()) {
                for (CastingCost cost : this.costs) {
                    cost.use(this);
                }
            }
            ++this.castCount;
            if (this.template != null) {
                ++this.template.castCount;
            }
        }
        return result.isSuccess();
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String message = Messages.get("spells.default." + messageKey, def);
        message = Messages.get("spells." + this.key + "." + messageKey, message);
        if (message == null) {
            message = "";
        }
        String playerName = this.mage.getName();
        message = message.replace("$player", playerName);
        String materialName = this.getDisplayMaterialName();
        materialName = materialName == null ? "None" : materialName;
        message = message.replace("$material", materialName);
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result) {
        if (this.mage != null) {
            this.mage.onCast(this, result);
        }
        if (result == SpellResult.CAST) {
            String message = this.getMessage(result.name().toLowerCase());
            Player player = this.mage.getPlayer();
            Entity targetEntity = this.getTargetEntity();
            if (targetEntity == player) {
                message = this.getMessage("cast_self", message);
            } else if (targetEntity instanceof Player) {
                message = this.getMessage("cast_player", message);
                String playerMessage = this.getMessage("cast_player_message");
                if (playerMessage.length() > 0) {
                    playerMessage = playerMessage.replace("$spell", this.getName());
                    Player targetPlayer = (Player)targetEntity;
                    Mage targetMage = this.controller.getMage((CommandSender)targetPlayer);
                    targetMage.sendMessage(playerMessage);
                }
            } else if (targetEntity instanceof LivingEntity) {
                message = this.getMessage("cast_livingentity", message);
            } else if (targetEntity instanceof Entity) {
                message = this.getMessage("cast_entity", message);
            }
            this.castMessage(message);
        } else {
            this.sendMessage(this.getMessage(result.name().toLowerCase()));
        }
        Location mageLocation = this.getEffectLocation();
        if (this.effects.containsKey((Object)result) && mageLocation != null) {
            Location targetLocation = this.getTargetLocation();
            List<EffectPlayer> resultEffects = this.effects.get((Object)result);
            for (EffectPlayer player : resultEffects) {
                player.setMaterial(this.getEffectMaterial());
                player.setColor(this.mage.getEffectColor());
                player.start(mageLocation, targetLocation);
            }
        }
    }

    @Override
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        return null;
    }

    public MaterialAndData getEffectMaterial() {
        return new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    protected void processParameters(ConfigurationSection parameters) {
        this.duration = parameters.getInt("duration", this.duration);
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", (double)this.fizzleChance);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", (double)this.backfireChance);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.overrideLocation(parameters, "p", defaultLocation, this.controller.canCreateWorlds());
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
        this.preventPassThroughMaterials = parameters.contains("prevent_passthrough") ? this.controller.getMaterialSet(parameters.getString("prevent_passthrough")) : this.controller.getMaterialSet("indestructible");
    }

    public String getPermissionNode() {
        return "Magic.cast." + this.key;
    }

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    @Override
    public void initialize(MageController instance) {
        this.controller = instance;
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public void onLoad(ConfigurationSection node) {
    }

    public void onSave(ConfigurationSection node) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getCostReduction() {
        return this.costReduction + this.mage.getCostReduction();
    }

    @Override
    public boolean usesMana() {
        return this.mage.usesMana();
    }

    @Override
    public Spell createSpell() {
        BaseSpell spell = (BaseSpell)this.clone();
        spell.template = this;
        return spell;
    }

    @Override
    public boolean cast() {
        return this.cast(new String[0], null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final SpellCategory getCategory() {
        return this.category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(SpellResult result) {
        ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectList = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>((Collection)this.effects.get((Object)result));
        return effectList;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setMage(Mage mage) {
        this.mage = mage;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        return cancelled;
    }

    @Override
    public void reactivate() {
        this.isActive = true;
        this.onActivate();
    }

    @Override
    public void activate() {
        if (!this.isActive) {
            this.reactivate();
            this.mage.activateSpell(this);
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.onDeactivate();
            this.mage.deactivateSpell(this);
            this.sendMessage(this.getMessage("deactivate"));
        }
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public void load(ConfigurationSection node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            if (this.category != null && this.template == null) {
                this.category.addCasts(this.castCount, this.lastCast);
            }
            this.isActive = node.getBoolean("active", false);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    @Override
    public void save(ConfigurationSection node) {
        try {
            node.set("cast_count", (Object)this.castCount);
            node.set("last_cast", (Object)this.lastCast);
            node.set("active", (Object)this.isActive);
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name);
            ex.printStackTrace();
        }
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection node) {
        this.key = key;
        this.loadTemplate(node);
    }

    @Override
    public void tick() {
        this.checkActiveDuration();
        this.checkActiveCosts();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        if (sender == null) {
            return true;
        }
        return this.controller.hasPermission(sender, this.getPermissionNode(), true);
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.category != null) {
            return this.category.getColor();
        }
        return null;
    }

    public abstract SpellResult onCast(ConfigurationSection var1);
}

