/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class CraftingController
implements Listener {
    private final MagicController controller;
    private boolean craftingEnabled = false;
    private Material wantItemSubstitute = null;
    private Recipe wandRecipe = null;
    private Material wandRecipeUpperMaterial = Material.NETHER_STAR;
    private Material wandRecipeLowerMaterial = Material.BLAZE_ROD;
    private String recipeOutputTemplate = "random(1)";

    public CraftingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        this.wantItemSubstitute = ConfigurationUtils.getMaterial(properties, "wand_item_substitute", null);
        this.craftingEnabled = properties.getBoolean("enable_crafting", this.craftingEnabled);
        if (this.craftingEnabled) {
            this.recipeOutputTemplate = properties.getString("crafting_output", this.recipeOutputTemplate);
            this.wandRecipeUpperMaterial = ConfigurationUtils.getMaterial(properties, "crafting_material_upper", this.wandRecipeUpperMaterial);
            this.wandRecipeLowerMaterial = ConfigurationUtils.getMaterial(properties, "crafting_material_lower", this.wandRecipeLowerMaterial);
        }
        if (this.craftingEnabled) {
            Wand wand = new Wand(this.controller);
            ShapedRecipe recipe = new ShapedRecipe(wand.getItem());
            recipe.shape(new String[]{"o", "i"}).setIngredient('o', this.wandRecipeUpperMaterial).setIngredient('i', this.wandRecipeLowerMaterial);
            this.wandRecipe = recipe;
            this.controller.getLogger().info("Wand crafting is enabled");
        }
    }

    public void enable(Plugin plugin) {
        if (this.wandRecipe != null) {
            plugin.getServer().addRecipe(this.wandRecipe);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.controller.getMage((CommandSender)player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (this.craftingEnabled && this.wandRecipe != null && recipe.getResult().getType() == Wand.DefaultWandMaterial) {
            CraftingInventory inventory = event.getInventory();
            if (inventory.contains(this.wandRecipeLowerMaterial) && inventory.contains(this.wandRecipeUpperMaterial)) {
                Wand defaultWand;
                Wand wand = defaultWand = Wand.createWand(this.controller, null);
                if (this.recipeOutputTemplate != null && this.recipeOutputTemplate.length() > 0) {
                    Wand templateWand = Wand.createWand(this.controller, this.recipeOutputTemplate);
                    templateWand.add(defaultWand);
                    wand = templateWand;
                }
                event.getInventory().setResult(wand.getItem());
            } else if (this.wantItemSubstitute != null) {
                event.getInventory().setResult(new ItemStack(this.wantItemSubstitute, 1));
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType == InventoryType.SlotType.CRAFTING && (inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.WORKBENCH) && (Wand.isWand(cursor = event.getCursor()) || Wand.isBrush(cursor) || Wand.isSpell(cursor))) {
            event.setCancelled(true);
            return;
        }
    }

    public boolean isEnabled() {
        return this.craftingEnabled;
    }
}

