/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.ParticleType;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.security.InvalidParameterException;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class EffectPlayer
implements com.elmakers.mine.bukkit.api.effect.EffectPlayer {
    public static boolean SOUNDS_ENABLED = true;
    protected Plugin plugin;
    protected Location origin;
    protected Location target;
    protected boolean playAtOrigin = true;
    protected boolean playAtTarget = false;
    protected Color color;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material;
    protected int delayTicks = 0;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material1;
    protected Color color1 = Color.PURPLE;
    protected Color color2 = Color.TEAL;
    protected Effect effect = null;
    protected Integer effectData = null;
    protected Sound sound = null;
    protected float soundVolume = 0.7f;
    protected float soundPitch = 1.5f;
    protected boolean hasFirework = false;
    protected FireworkEffect.Type fireworkType;
    protected int fireworkPower = 1;
    protected Boolean fireworkFlicker;
    protected FireworkEffect fireworkEffect;
    protected ParticleType particleType = null;
    protected String particleSubType = "";
    protected float particleData = 0.0f;
    protected float particleXOffset = 0.3f;
    protected float particleYOffset = 0.3f;
    protected float particleZOffset = 0.3f;
    protected int particleCount = 1;
    protected Vector offset = new Vector(0, 0, 0);

    public EffectPlayer() {
    }

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void load(Plugin plugin, ConfigurationSection configuration) {
        String typeName;
        this.plugin = plugin;
        this.delayTicks = configuration.getInt("delay", this.delayTicks) * 20 / 1000;
        this.material1 = ConfigurationUtils.getMaterialAndData(configuration, "material");
        this.color1 = ConfigurationUtils.getColor(configuration, "color", Color.PURPLE);
        this.color2 = ConfigurationUtils.getColor(configuration, "color2", Color.TEAL);
        if (configuration.contains("effect")) {
            String effectName = configuration.getString("effect");
            this.effect = Effect.valueOf((String)effectName.toUpperCase());
            if (this.effect == null) {
                plugin.getLogger().warning("Unknown effect type " + effectName);
            } else {
                this.effectData = ConfigurationUtils.getInteger(configuration, "effect_data", this.effectData);
            }
        }
        if (configuration.contains("sound")) {
            String soundName = configuration.getString("sound");
            this.sound = Sound.valueOf((String)soundName.toUpperCase());
            if (this.sound == null) {
                plugin.getLogger().warning("Unknown sound type " + soundName);
            } else {
                this.soundVolume = (float)configuration.getDouble("sound_volume", (double)this.soundVolume);
                this.soundPitch = (float)configuration.getDouble("sound_pitch", (double)this.soundPitch);
            }
        }
        if (configuration.contains("firework") || configuration.contains("firework_power")) {
            this.hasFirework = true;
            this.fireworkType = null;
            if (configuration.contains("firework")) {
                typeName = configuration.getString("firework");
                this.fireworkType = FireworkEffect.Type.valueOf((String)typeName.toUpperCase());
                if (this.fireworkType == null) {
                    plugin.getLogger().warning("Unknown firework type " + typeName);
                }
            }
            this.fireworkPower = configuration.getInt("firework_power", this.fireworkPower);
            this.fireworkFlicker = ConfigurationUtils.getBoolean(configuration, "firework_flicker", this.fireworkFlicker);
        }
        if (configuration.contains("particle")) {
            typeName = configuration.getString("particle");
            this.particleType = ParticleType.valueOf(typeName.toUpperCase());
            if (this.particleType == null) {
                plugin.getLogger().warning("Unknown particle type " + typeName);
            } else {
                this.particleSubType = configuration.getString("particle_sub_type", this.particleSubType);
                this.particleData = (float)configuration.getDouble("particle_data", (double)this.particleData);
                this.particleXOffset = (float)configuration.getDouble("particle_offset_x", (double)this.particleXOffset);
                this.particleYOffset = (float)configuration.getDouble("particle_offset_y", (double)this.particleYOffset);
                this.particleZOffset = (float)configuration.getDouble("particle_offset_z", (double)this.particleZOffset);
                this.particleCount = configuration.getInt("particle_count", this.particleCount);
            }
        }
        this.setLocationType(configuration.getString("location", "origin"));
    }

    public void setLocationType(String locationType) {
        if (locationType.equals("target")) {
            this.playAtOrigin = false;
            this.playAtTarget = true;
        } else if (locationType.equals("origin")) {
            this.playAtTarget = false;
            this.playAtOrigin = true;
        } else if (locationType.equals("both")) {
            this.playAtTarget = true;
            this.playAtOrigin = true;
        }
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Random rand = new Random();
        if (color1 == null) {
            color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (color2 == null) {
            color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    @Override
    public void setParticleType(ParticleType particleType) {
        this.particleType = particleType;
    }

    @Override
    public void setParticleSubType(String particleSubType) {
        this.particleSubType = particleSubType;
    }

    @Override
    public void setEffectData(int data) {
        this.effectData = data;
    }

    protected com.elmakers.mine.bukkit.block.MaterialAndData getWorkingMaterial() {
        if (this.material1 != null) {
            return this.material1;
        }
        com.elmakers.mine.bukkit.block.MaterialAndData result = this.material;
        if (result == null && this.target != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(this.target.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null && this.origin != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(this.origin.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
        }
        return result;
    }

    protected void playEffect(Location targetLocation) {
        Material material;
        Location location = targetLocation.clone();
        location.add(this.offset);
        if (this.effect != null) {
            int data;
            int n = data = this.effectData == null ? 0 : this.effectData;
            if (this.effect == Effect.STEP_SOUND && this.effectData == null) {
                material = this.getWorkingMaterial().getMaterial();
                if (!material.isSolid()) {
                    return;
                }
                data = material.getId();
            }
            location.getWorld().playEffect(location, this.effect, data);
        }
        if (this.sound != null) {
            location.getWorld().playSound(location, this.sound, this.soundVolume, this.soundPitch);
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(location, this.fireworkEffect, this.fireworkPower);
        }
        if (this.particleType != null) {
            String subType = this.particleSubType;
            if ((this.particleType == ParticleType.BLOCK_BREAKING || this.particleType == ParticleType.TOOL_BREAKING) && this.particleSubType.length() == 0) {
                material = this.getWorkingMaterial().getMaterial();
                if (this.particleType == ParticleType.BLOCK_BREAKING && !material.isSolid()) {
                    return;
                }
                if (this.particleType == ParticleType.TOOL_BREAKING) {
                    material = Material.DIAMOND_AXE;
                }
                subType = "" + material.getId();
            }
            EffectUtils.playEffect(location, this.particleType, subType, this.particleXOffset, this.particleYOffset, this.particleZOffset, this.particleData, this.particleCount);
        }
    }

    @Override
    public void setParticleData(float effectData) {
        this.particleData = effectData;
    }

    @Override
    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    @Override
    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.particleXOffset = xOffset;
        this.particleYOffset = yOffset;
        this.particleZOffset = zOffset;
    }

    @Override
    public void setSound(Sound sound) {
        this.sound = sound;
    }

    @Override
    public void setSound(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.soundVolume = volume;
        this.soundPitch = pitch;
    }

    @Override
    public void setDelayTicks(int ticks) {
        this.delayTicks = ticks;
    }

    @Override
    public void start(Location origin, Location target) {
        if (origin == null) {
            throw new InvalidParameterException("Origin cannot be null");
        }
        if (target != null && !origin.getWorld().equals(target.getWorld())) {
            target.setWorld(origin.getWorld());
        }
        this.origin = origin;
        this.target = target;
        this.fireworkEffect = this.hasFirework ? this.getFireworkEffect(this.getColor1(), this.getColor2(), this.fireworkType, this.fireworkFlicker, false) : null;
        if (this.delayTicks > 0 && this.plugin != null) {
            final EffectPlayer player = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.play();
                }
            }, (long)this.delayTicks);
        } else {
            this.play();
        }
    }

    protected Vector getDirection() {
        Vector direction = this.target == null ? this.origin.getDirection() : this.target.toVector().subtract(this.origin.toVector());
        return direction.normalize();
    }

    @Override
    public void setMaterial(MaterialAndData material) {
        this.material = new com.elmakers.mine.bukkit.block.MaterialAndData(material);
    }

    @Override
    public void setMaterial(Block block) {
        this.material = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor1() {
        return this.color != null ? this.color : this.color1;
    }

    public Color getColor2() {
        return this.color != null ? this.color1 : this.color2;
    }

    @Override
    public void setOffset(float x, float y, float z) {
        this.offset.setX(x);
        this.offset.setY(y);
        this.offset.setZ(z);
    }

    public abstract void play();
}

