/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.BoundingBox;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SpellBatch;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegenerateBatch
extends SpellBatch {
    private static final BlockData[] template = new BlockData[0];
    private final UndoList restoredBlocks;
    private final World world;
    private final Mage mage;
    private final BlockSpell spell;
    private final int absx;
    private final int absz;
    private final int dx;
    private final int dz;
    private final int x;
    private final int z;
    private int ix = 0;
    private int iz = 0;
    private int blockY = 0;
    private int blockX = 0;
    private int blockZ = 0;
    private BlockData[] restoreBlocks;
    private int restoringIndex = 0;
    private boolean expand = false;
    private BoundingBox bounds = new BoundingBox();
    private RegenerateState state;

    public RegenerateBatch(BlockSpell spell, Location p1, Location p2) {
        super(spell);
        this.spell = spell;
        this.restoredBlocks = new UndoList(spell.getMage(), spell.getName());
        this.mage = spell.getMage();
        this.world = this.mage.getPlayer().getWorld();
        this.state = RegenerateState.SAVING;
        int deltax = p2.getBlock().getChunk().getX() - p1.getChunk().getX();
        int deltaz = p2.getChunk().getZ() - p1.getChunk().getZ();
        this.absx = Math.abs(deltax) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getChunk().getX();
        this.z = p1.getChunk().getZ();
        this.bounds = new BoundingBox(p1.toVector(), p2.toVector());
    }

    @Override
    public int size() {
        return this.absx * this.absz * 16 * 16 * 256;
    }

    @Override
    public int remaining() {
        return (this.absx - this.ix) * (this.absz - this.iz) * 16 * 16 * 256;
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx * 16 <= maxDimension && this.absz * 16 <= maxDimension;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks;
        switch (this.state) {
            case SAVING: {
                while (processedBlocks <= maxBlocks && this.ix < this.absx) {
                    while (processedBlocks <= maxBlocks && this.blockY < 256) {
                        Chunk chunk = this.world.getChunkAt(this.x + this.ix * this.dx, this.z + this.iz * this.dz);
                        if (!chunk.isLoaded()) {
                            chunk.load();
                            return processedBlocks;
                        }
                        Block block = chunk.getBlock(this.blockX, this.blockY, this.blockZ);
                        if (!this.spell.hasBuildPermission(block)) {
                            this.spell.sendMessage(this.spell.getMessage("insufficient_permission"));
                            this.finish();
                            return processedBlocks;
                        }
                        if (!this.expand && !this.bounds.contains(block.getLocation().toVector())) {
                            this.restoredBlocks.add(block);
                        } else {
                            this.registerForUndo(block);
                        }
                        ++processedBlocks;
                        ++this.blockX;
                        if (this.blockX <= 15) continue;
                        this.blockX = 0;
                        ++this.blockZ;
                        if (this.blockZ <= 15) continue;
                        this.blockZ = 0;
                        ++this.blockY;
                    }
                    if (this.blockY < 256) continue;
                    this.blockX = 0;
                    this.blockZ = 0;
                    this.blockY = 0;
                    ++this.iz;
                    if (this.iz < this.absz) continue;
                    this.iz = 0;
                    ++this.ix;
                }
                if (this.ix < this.absx) break;
                this.state = RegenerateState.REGENERATING;
                this.ix = 0;
                this.iz = 0;
                break;
            }
            case REGENERATING: {
                while (processedBlocks <= maxBlocks && this.ix < this.absx) {
                    Chunk chunk = this.world.getChunkAt(this.x + this.ix * this.dx, this.z + this.iz * this.dz);
                    if (!chunk.isLoaded()) {
                        chunk.load();
                        return processedBlocks;
                    }
                    processedBlocks += 65536;
                    this.world.regenerateChunk(chunk.getX(), chunk.getZ());
                    ++this.iz;
                    if (this.iz < this.absz) continue;
                    this.iz = 0;
                    ++this.ix;
                }
                if (this.ix < this.absx) break;
                this.restoreBlocks = this.restoredBlocks.toArray(template);
                this.state = RegenerateState.RESTORING;
                break;
            }
            case RESTORING: {
                for (processedBlocks = 0; this.restoreBlocks != null && processedBlocks < maxBlocks && this.restoringIndex < this.restoreBlocks.length; ++processedBlocks) {
                    this.restoreBlocks[this.restoringIndex].restore();
                    ++this.restoringIndex;
                }
                if (this.restoreBlocks != null && this.restoringIndex < this.restoredBlocks.size()) break;
                this.finish();
            }
        }
        return processedBlocks;
    }

    public int getXSize() {
        return this.absx;
    }

    public int getZSize() {
        return this.absz;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            UndoList modified = this.spell.getUndoList();
            modified.prune();
            super.finish();
        }
    }

    private static enum RegenerateState {
        SAVING,
        REGENERATING,
        RESTORING;

    }
}

