/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class UndoQueue
implements com.elmakers.mine.bukkit.api.block.UndoQueue {
    private final Mage owner;
    private final LinkedList<com.elmakers.mine.bukkit.api.block.UndoList> changeQueue = new LinkedList();
    private final Set<com.elmakers.mine.bukkit.api.block.UndoList> scheduledBlocks = new HashSet<com.elmakers.mine.bukkit.api.block.UndoList>();
    private int maxSize = 0;

    public UndoQueue(Mage mage) {
        this.owner = mage;
    }

    @Override
    public void add(com.elmakers.mine.bukkit.api.block.UndoList blocks) {
        if (this.maxSize > 0 && this.changeQueue.size() > this.maxSize) {
            com.elmakers.mine.bukkit.api.block.UndoList expired = this.changeQueue.removeFirst();
            expired.commit();
        }
        this.changeQueue.add(blocks);
    }

    public void scheduleCleanup(Mage mage, com.elmakers.mine.bukkit.api.block.UndoList blocks) {
        this.scheduledBlocks.add(blocks);
        blocks.scheduleCleanup();
    }

    public void undoScheduled(Mage mage) {
        if (this.scheduledBlocks.size() == 0) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.block.UndoList list : this.scheduledBlocks) {
            list.undoScheduled();
        }
        this.scheduledBlocks.clear();
    }

    public boolean isEmpty() {
        return this.scheduledBlocks.isEmpty() && this.changeQueue.isEmpty();
    }

    @Override
    public void removeScheduledCleanup(com.elmakers.mine.bukkit.api.block.UndoList blockList) {
        this.scheduledBlocks.remove(blockList);
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList getLast() {
        if (this.changeQueue.isEmpty()) {
            return null;
        }
        return this.changeQueue.getLast();
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList getLast(Block target) {
        if (this.changeQueue.size() == 0) {
            return null;
        }
        for (com.elmakers.mine.bukkit.api.block.UndoList blocks : this.changeQueue) {
            if (!blocks.contains(target)) continue;
            return blocks;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public com.elmakers.mine.bukkit.api.block.UndoList undo(Mage mage) {
        if (this.changeQueue.size() == 0) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.UndoList blocks = this.changeQueue.removeLast();
        if (blocks.undo()) {
            return blocks;
        }
        this.changeQueue.add(blocks);
        return null;
    }

    public com.elmakers.mine.bukkit.api.block.UndoList undo(Mage mage, Block target) {
        com.elmakers.mine.bukkit.api.block.UndoList lastActionOnTarget = this.getLast(target);
        if (lastActionOnTarget == null) {
            return null;
        }
        if (lastActionOnTarget.undo()) {
            this.changeQueue.remove(lastActionOnTarget);
            return lastActionOnTarget;
        }
        return null;
    }

    public void load(Mage mage, ConfigurationSection node) {
        try {
            UndoList list;
            if (node == null) {
                return;
            }
            Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(node, "undo");
            if (nodeList != null) {
                for (ConfigurationSection listNode : nodeList) {
                    list = new UndoList(this.owner);
                    list.load(listNode);
                    this.changeQueue.add(list);
                }
            }
            if ((nodeList = ConfigurationUtils.getNodeList(node, "scheduled")) != null) {
                for (ConfigurationSection listNode : nodeList) {
                    list = new UndoList(this.owner);
                    list.load(listNode);
                    this.scheduleCleanup(mage, list);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            mage.getController().getLogger().warning("Failed to load undo data: " + ex.getMessage());
        }
    }

    public void save(Mage mage, ConfigurationSection node) {
        MageController controller = mage.getController();
        int maxSize = controller.getMaxUndoPersistSize();
        try {
            MemoryConfiguration listNode;
            int discarded = 0;
            ArrayList<Map> nodeList = new ArrayList<Map>();
            for (com.elmakers.mine.bukkit.api.block.UndoList list : this.changeQueue) {
                if (maxSize > 0 && list.size() > maxSize) {
                    ++discarded;
                    continue;
                }
                listNode = new MemoryConfiguration();
                list.save((ConfigurationSection)listNode);
                nodeList.add(listNode.getValues(true));
            }
            if (discarded > 0) {
                controller.getLogger().info("Not saving " + discarded + " undo batches for player " + mage.getName() + ", over max size of " + maxSize);
            }
            node.set("undo", nodeList);
            nodeList = new ArrayList();
            for (com.elmakers.mine.bukkit.api.block.UndoList list : this.scheduledBlocks) {
                listNode = new MemoryConfiguration();
                list.save((ConfigurationSection)listNode);
                nodeList.add(listNode.getValues(true));
            }
            node.set("scheduled", nodeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            controller.getLogger().warning("Failed to save undo data: " + ex.getMessage());
        }
    }

    public int getSize() {
        return this.changeQueue.size();
    }

    public boolean commit() {
        if (this.changeQueue.size() == 0) {
            return false;
        }
        for (com.elmakers.mine.bukkit.api.block.UndoList list : this.changeQueue) {
            list.commit();
        }
        this.changeQueue.clear();
        return true;
    }
}

