/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.batch.CleanupBlocksTask;
import com.elmakers.mine.bukkit.block.batch.UndoBatch;
import com.elmakers.mine.bukkit.entity.EntityData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    protected static Map<Long, BlockData> modified = new HashMap<Long, BlockData>();
    protected Set<UUID> entities;
    protected List<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected final Mage owner;
    protected final Plugin plugin;
    protected int passesRemaining = 1;
    protected int timeToLive = 0;
    protected int taskId = 0;
    protected boolean bypass = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected String name;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(Mage mage) {
        this.plugin = mage.getController().getPlugin();
        this.owner = mage;
        Location location = mage.getLocation();
        this.worldName = location == null ? null : location.getWorld().getName();
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public UndoList(UndoList other) {
        super(other);
        this.worldName = other.worldName;
        this.owner = other.owner;
        this.name = other.name;
        this.plugin = other.plugin;
        this.timeToLive = other.timeToLive;
        this.passesRemaining = other.passesRemaining;
        this.createdTime = other.createdTime;
        this.modifiedTime = other.modifiedTime;
    }

    @Override
    public int size() {
        return (this.blockList == null ? 0 : this.blockList.size()) + (this.entities == null ? 0 : this.entities.size()) + (this.runnables == null ? 0 : this.runnables.size());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    public void setRepetitions(int repeat) {
        this.passesRemaining = repeat;
    }

    public boolean isComplete() {
        return this.passesRemaining <= 0;
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean add(BlockData blockData) {
        if (!super.add(blockData)) {
            return false;
        }
        if (this.bypass) {
            return true;
        }
        BlockData priorState = modified.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        modified.put(blockData.getId(), blockData);
        this.modifiedTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void commit() {
        if (this.blockList == null) {
            return;
        }
        for (BlockData block : this.blockList) {
            BlockData currentState = modified.get(block.getId());
            if (currentState == block) {
                modified.remove(block.getId());
            }
            block.commit();
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockData) {
            BlockData block = (BlockData)o;
            UndoList.removeFromModified(block);
        }
        return super.remove(o);
    }

    protected static void removeFromModified(BlockData block) {
        BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            BlockData priorState = block.getPriorState();
            if (priorState == null) {
                modified.remove(block.getId());
            } else {
                modified.put(block.getId(), priorState);
            }
        }
    }

    public static boolean undo(BlockData undoBlock) {
        if (undoBlock.undo()) {
            UndoList.removeFromModified(undoBlock);
            return true;
        }
        return false;
    }

    @Override
    public boolean undo() {
        if (this.entities != null || this.modifiedEntities != null) {
            Entity entity;
            World world;
            HashMap<UUID, Entity> currentEntities = new HashMap<UUID, Entity>();
            World world2 = world = this.worldName != null && this.worldName.length() > 0 ? Bukkit.getWorld((String)this.worldName) : null;
            if (world != null) {
                List entities = world.getEntities();
                for (Entity entity2 : entities) {
                    currentEntities.put(entity2.getUniqueId(), entity2);
                }
            }
            if (this.entities != null) {
                for (UUID uUID : this.entities) {
                    entity = (Entity)currentEntities.get(uUID);
                    if (entity == null || !entity.isValid()) continue;
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (Map.Entry entry : this.modifiedEntities.entrySet()) {
                    entity = (Entity)currentEntities.get(entry.getKey());
                    if (entity == null) {
                        ((EntityData)entry.getValue()).spawn();
                        continue;
                    }
                    ((EntityData)entry.getValue()).modify(entity);
                }
                this.modifiedEntities = null;
            }
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            return true;
        }
        UndoBatch batch = new UndoBatch(this);
        if (!this.owner.addPendingBlockBatch(batch)) {
            return false;
        }
        --this.passesRemaining;
        return true;
    }

    @Override
    public void load(ConfigurationSection node) {
        super.load(node);
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.passesRemaining = node.getInt("passes_remaining", this.passesRemaining);
        this.name = node.getString("name", this.name);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("passes_remaining", (Object)this.passesRemaining);
        node.set("name", (Object)this.name);
    }

    @Override
    public void scheduleCleanup() {
        Server server = this.plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = this.timeToLive * 20 / 1000;
        this.taskId = scheduler.scheduleSyncDelayedTask(this.plugin, (Runnable)new CleanupBlocksTask(this.owner, this), ticksToLive);
    }

    @Override
    public boolean undoScheduled() {
        if (this.taskId > 0) {
            Server server = this.plugin.getServer();
            BukkitScheduler scheduler = server.getScheduler();
            scheduler.cancelTask(this.taskId);
            this.taskId = 0;
        }
        return this.undo();
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Entity entity) {
        if (this.entities == null) {
            this.entities = new HashSet<UUID>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(entity.getUniqueId());
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void modify(Entity entity) {
        this.modify(entity, false, false);
    }

    protected void modify(Entity entity, boolean hasMoved, boolean hasPotionEffects) {
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        if (this.entities != null && this.entities.contains(entity) && !entity.isValid()) {
            this.entities.remove(entity);
        } else {
            EntityData entityData;
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entity)) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entity.getUniqueId(), entityData);
            }
            entityData.setHasMoved(hasMoved);
            entityData.setHasPotionEffects(hasPotionEffects);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    public void move(Entity entity) {
        this.modify(entity, true, false);
    }

    public void addPotionEffects(Entity entity) {
        this.modify(entity, false, true);
    }

    @Override
    public void remove(Entity entity) {
        if (this.entities != null && this.entities.contains(entity)) {
            this.entities.remove(entity);
        }
        if (this.modifiedEntities != null && this.modifiedEntities.containsKey(entity)) {
            this.entities.remove(entity);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        if (this.entities != null) {
            this.entities.remove(fallingBlock);
        }
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
        }
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
            this.modifiedTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        ArrayList current = new ArrayList(this.blockList);
        this.blockList = null;
        this.blockIdMap = null;
        for (BlockData block : current) {
            if (block.isDifferent()) {
                super.add(block);
                continue;
            }
            UndoList.removeFromModified(block);
            block.unlink();
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }
}

