/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.Mage;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Target
implements Comparable<Target> {
    protected int maxDistance = 512;
    protected int minDistance = 0;
    protected double maxAngle = 0.3;
    private Location source;
    private Location location;
    private Entity entity;
    private Mage mage;
    private boolean reverseDistance = false;
    private double distance = 100000.0;
    private double angle = 10000.0;
    private int score = 0;
    private Object extraData = null;

    public Target(Location sourceLocation) {
        this.source = sourceLocation;
    }

    public Target(Location sourceLocation, Block block) {
        this.source = sourceLocation;
        if (block != null) {
            this.location = block.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Block block, int range) {
        this(sourceLocation, block, range, 0.3, false);
    }

    public Target(Location sourceLocation, Block block, int range, double angle) {
        this(sourceLocation, block, range, angle, false);
    }

    public Target(Location sourceLocation, Block block, int range, double angle, boolean reverseDistance) {
        this.maxDistance = range;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        if (block != null) {
            this.location = block.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Block block, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistance = maxRange;
        this.minDistance = minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        if (block != null) {
            this.location = block.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range) {
        this.maxDistance = range;
        this.source = sourceLocation;
        this.entity = entity;
        if (entity != null) {
            this.location = entity.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle) {
        this.maxDistance = range;
        this.maxAngle = angle;
        this.source = sourceLocation;
        this.entity = entity;
        if (entity != null) {
            this.location = entity.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle, boolean reverseDistance) {
        this.maxDistance = range;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this.entity = entity;
        if (entity != null) {
            this.location = entity.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistance = maxRange;
        this.minDistance = minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this.entity = entity;
        if (entity != null) {
            this.location = entity.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Mage mage, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistance = maxRange;
        this.minDistance = minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this.mage = mage;
        if (mage != null) {
            this.entity = mage.getPlayer();
        }
        if (mage != null) {
            this.location = mage.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity) {
        this.maxDistance = 0;
        this.source = sourceLocation;
        this.entity = entity;
        if (entity != null) {
            this.location = entity.getLocation();
        }
    }

    public Target(Location sourceLocation, Entity entity, Block block) {
        this.maxDistance = 0;
        this.source = sourceLocation;
        this.entity = entity;
        if (block != null) {
            this.location = block.getLocation();
        } else if (entity != null) {
            this.location = entity.getLocation();
        }
    }

    public int getScore() {
        return this.score;
    }

    protected void calculateScore() {
        if (this.source == null) {
            return;
        }
        Vector playerFacing = this.source.getDirection();
        Vector playerLoc = new Vector(this.source.getBlockX(), this.source.getBlockY(), this.source.getBlockZ());
        Location targetLocation = this.getLocation();
        if (targetLocation == null) {
            return;
        }
        Vector targetLoc = new Vector(targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ());
        Vector targetDirection = new Vector(targetLoc.getBlockX() - playerLoc.getBlockX(), targetLoc.getBlockY() - playerLoc.getBlockY(), targetLoc.getBlockZ() - playerLoc.getBlockZ());
        this.angle = targetDirection.angle(playerFacing);
        this.distance = targetDirection.length();
        this.score = 0;
        if (this.maxAngle > 0.0 && this.angle > this.maxAngle) {
            return;
        }
        if (this.maxDistance > 0 && this.distance > (double)this.maxDistance) {
            return;
        }
        if (this.distance < (double)this.minDistance) {
            return;
        }
        if (this.reverseDistance) {
            this.distance = (double)this.maxDistance - this.distance;
        }
        this.score = 0;
        if (this.maxDistance > 0) {
            this.score = (int)((double)this.score + ((double)this.maxDistance - this.distance));
        }
        if (this.angle > 0.0) {
            this.score = (int)((double)this.score + (3.0 - this.angle) * 4.0);
        }
        this.score = this.entity != null && this.entity.hasMetadata("NPC") ? --this.score : (this.mage != null ? (this.score += 5) : (this.entity instanceof Player ? (this.score += 3) : (this.entity instanceof LivingEntity ? (this.score += 2) : ++this.score)));
    }

    @Override
    public int compareTo(Target other) {
        return other.score - this.score;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean isValid() {
        return this.location != null;
    }

    public boolean hasTarget() {
        return this.location != null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Block getBlock() {
        if (this.location == null) {
            return null;
        }
        return this.location.getBlock();
    }

    public double getDistance() {
        return this.distance;
    }

    public Location getLocation() {
        return this.location;
    }

    public void add(Vector offset) {
        if (this.location != null) {
            this.location = this.location.add(offset);
        }
    }

    public void setWorld(World world) {
        if (this.location != null) {
            this.location.setWorld(world);
        }
    }

    public Object getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Object extraData) {
        this.extraData = extraData;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        this.location = entity.getLocation();
        this.calculateScore();
    }
}

